/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.compensation;

import io.camunda.zeebe.engine.state.compensation.CompensationSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableCompensationSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.compensation.CompensationSubscriptionRecord;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class CompensationSubscriptionStateTest {
    private static final String TENANT_ID = "tenantId";
    private static final long PROCESS_INSTANCE_KEY = 1L;
    private static final long PROCESS_DEFINITION_KEY = 2L;
    private static final String COMPENSABLE_ACTIVITY_ID = "compensableActivityId";
    private static final long COMPENSABLE_ACTIVITY_INSTANCE_KEY = 3L;
    private static final long COMPENSABLE_ACTIVITY_SCOPE_KEY = 4L;
    private static final String THROW_EVENT_ID = "throwEventId";
    private static final long THROW_EVENT_INSTANCE_KEY = 5L;
    private static final String COMPENSATION_HANDLER_ID = "compensationHandlerId";
    private static final long COMPENSATION_HANDLER_INSTANCE_KEY = 6L;
    private MutableCompensationSubscriptionState state;
    private MutableProcessingState processingState;

    @BeforeEach
    public void setUp() {
        this.state = this.processingState.getCompensationSubscriptionState();
    }

    @Test
    public void shouldPutCompensationSubscriptionRecord() {
        CompensationSubscriptionRecord compensation = this.createCompensation(1L);
        this.state.put(1L, compensation);
        CompensationSubscriptionRecord storedCompensation = this.state.get(compensation.getTenantId(), compensation.getProcessInstanceKey(), 1L).getRecord();
        Assertions.assertThat((String)storedCompensation.getTenantId()).isEqualTo(TENANT_ID);
        Assertions.assertThat((long)storedCompensation.getProcessInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)storedCompensation.getProcessDefinitionKey()).isEqualTo(2L);
        Assertions.assertThat((String)storedCompensation.getCompensableActivityId()).isEqualTo(COMPENSABLE_ACTIVITY_ID);
        Assertions.assertThat((long)storedCompensation.getCompensableActivityInstanceKey()).isEqualTo(3L);
        Assertions.assertThat((long)storedCompensation.getCompensableActivityScopeKey()).isEqualTo(4L);
        Assertions.assertThat((String)storedCompensation.getThrowEventId()).isEqualTo(THROW_EVENT_ID);
        Assertions.assertThat((long)storedCompensation.getThrowEventInstanceKey()).isEqualTo(5L);
        Assertions.assertThat((String)storedCompensation.getCompensationHandlerId()).isEqualTo(COMPENSATION_HANDLER_ID);
        Assertions.assertThat((long)storedCompensation.getCompensationHandlerInstanceKey()).isEqualTo(6L);
    }

    @Test
    public void shouldUpdateAllTheCompensationSubscriptionWithSameTenantIdAndProcessInstanceKey() {
        CompensationSubscriptionRecord compensationToUpdate = this.createCompensation(1L);
        CompensationSubscriptionRecord compensationToNOTUpdate = this.createCompensation(2L);
        this.state.put(1L, compensationToUpdate);
        this.state.put(2L, compensationToNOTUpdate);
        CompensationSubscriptionRecord updatedCompensationInfo = new CompensationSubscriptionRecord().setTenantId(TENANT_ID).setProcessInstanceKey(1L).setProcessDefinitionKey(2L).setCompensableActivityId(COMPENSABLE_ACTIVITY_ID).setCompensableActivityInstanceKey(10L).setCompensableActivityScopeKey(11L).setThrowEventId("updateThrowEventId").setThrowEventInstanceKey(2L).setCompensationHandlerInstanceKey(12L);
        this.state.update(1L, updatedCompensationInfo);
        CompensationSubscriptionRecord updatedCompensation = this.state.get(compensationToUpdate.getTenantId(), compensationToUpdate.getProcessInstanceKey(), 1L).getRecord();
        CompensationSubscriptionRecord notUpdatedCompensation = this.state.get(compensationToNOTUpdate.getTenantId(), compensationToNOTUpdate.getProcessInstanceKey(), 2L).getRecord();
        Assertions.assertThat((String)updatedCompensation.getCompensableActivityId()).isEqualTo(COMPENSABLE_ACTIVITY_ID);
        Assertions.assertThat((long)updatedCompensation.getCompensableActivityInstanceKey()).isEqualTo(10L);
        Assertions.assertThat((long)updatedCompensation.getCompensableActivityScopeKey()).isEqualTo(11L);
        Assertions.assertThat((String)updatedCompensation.getThrowEventId()).isEqualTo("updateThrowEventId");
        Assertions.assertThat((long)updatedCompensation.getThrowEventInstanceKey()).isEqualTo(2L);
        Assertions.assertThat((long)updatedCompensation.getCompensationHandlerInstanceKey()).isEqualTo(12L);
        Assertions.assertThat((String)notUpdatedCompensation.getCompensableActivityId()).isEqualTo(COMPENSABLE_ACTIVITY_ID);
        Assertions.assertThat((long)notUpdatedCompensation.getCompensableActivityInstanceKey()).isEqualTo(3L);
        Assertions.assertThat((long)notUpdatedCompensation.getCompensableActivityScopeKey()).isEqualTo(4L);
        Assertions.assertThat((String)notUpdatedCompensation.getThrowEventId()).isEqualTo(THROW_EVENT_ID);
        Assertions.assertThat((long)notUpdatedCompensation.getThrowEventInstanceKey()).isEqualTo(5L);
        Assertions.assertThat((long)notUpdatedCompensation.getCompensationHandlerInstanceKey()).isEqualTo(6L);
    }

    @Test
    public void shouldFindCompensationSubscriptionByProcessInstanceKey() {
        CompensationSubscriptionRecord compensationToRetrieve = this.createCompensation(1L);
        CompensationSubscriptionRecord compensationToRetrieve2 = this.createCompensation(1L);
        compensationToRetrieve2.setCompensableActivityId("anotherCompensableActivityId");
        CompensationSubscriptionRecord compensationToNOTRetrieve = this.createCompensation(2L);
        this.state.put(1L, compensationToRetrieve);
        this.state.put(2L, compensationToRetrieve2);
        this.state.put(3L, compensationToNOTRetrieve);
        List subscriptions = this.state.findSubscriptionsByProcessInstanceKey(TENANT_ID, 1L);
        Assertions.assertThat((int)subscriptions.size()).isEqualTo(2);
        Assertions.assertThat((List)subscriptions).extracting(c -> c.getRecord().getCompensableActivityId()).contains((Object[])new String[]{COMPENSABLE_ACTIVITY_ID, "anotherCompensableActivityId"});
    }

    @Test
    public void shouldRemoveCompensationSubscription() {
        CompensationSubscriptionRecord compensation = this.createCompensation(1L);
        this.state.put(1L, compensation);
        this.state.delete(TENANT_ID, 1L, 1L);
        List compensations = this.state.findSubscriptionsByProcessInstanceKey(TENANT_ID, 1L);
        Assertions.assertThat((List)compensations).isEmpty();
    }

    @Test
    public void shouldRemoveOneCompensationSubscription() {
        CompensationSubscriptionRecord compensation = this.createCompensation(1L);
        CompensationSubscriptionRecord compensationToRemove = this.createCompensation(1L);
        compensationToRemove.setCompensableActivityId("anotherCompensableActivityId");
        this.state.put(1L, compensation);
        this.state.put(2L, compensationToRemove);
        this.state.delete(TENANT_ID, 1L, 2L);
        List compensations = this.state.findSubscriptionsByProcessInstanceKey(TENANT_ID, 1L);
        Assertions.assertThat((int)compensations.size()).isEqualTo(1);
        Assertions.assertThat((String)((CompensationSubscription)compensations.getFirst()).getRecord().getCompensableActivityId()).isEqualTo(COMPENSABLE_ACTIVITY_ID);
    }

    @Test
    public void shouldFindCompensationByHandlerId() {
        CompensationSubscriptionRecord compensation = this.createCompensation(1L);
        CompensationSubscriptionRecord notValidCompensation = this.createCompensation(1L);
        notValidCompensation.setCompensableActivityId("anotherCompensableActivityId");
        notValidCompensation.setCompensationHandlerId("anotherCompensationActivityElementId");
        this.state.put(1L, compensation);
        this.state.put(2L, notValidCompensation);
        Optional retrievedCompensation = this.state.findSubscriptionByCompensationHandlerId(TENANT_ID, 1L, COMPENSATION_HANDLER_ID);
        Assertions.assertThat((boolean)retrievedCompensation.isPresent()).isTrue();
        Assertions.assertThat((String)((CompensationSubscription)retrievedCompensation.get()).getRecord().getCompensationHandlerId()).isEqualTo(COMPENSATION_HANDLER_ID);
    }

    @Test
    public void shouldFindCompensationByThrowEventInstanceKey() {
        CompensationSubscriptionRecord compensation = this.createCompensation(1L);
        CompensationSubscriptionRecord notValidCompensation = this.createCompensation(1L);
        notValidCompensation.setCompensableActivityId("anotherCompensableActivityId");
        notValidCompensation.setThrowEventInstanceKey(123456789L);
        this.state.put(1L, compensation);
        this.state.put(2L, notValidCompensation);
        List compensations = this.state.findSubscriptionsByThrowEventInstanceKey(TENANT_ID, 1L, 5L);
        Assertions.assertThat((int)compensations.size()).isEqualTo(1);
        Assertions.assertThat((long)((CompensationSubscription)compensations.getFirst()).getRecord().getThrowEventInstanceKey()).isEqualTo(5L);
    }

    private CompensationSubscriptionRecord createCompensation(long key) {
        return new CompensationSubscriptionRecord().setTenantId(TENANT_ID).setProcessInstanceKey(key).setProcessDefinitionKey(2L).setCompensableActivityId(COMPENSABLE_ACTIVITY_ID).setCompensableActivityInstanceKey(3L).setCompensableActivityScopeKey(4L).setThrowEventId(THROW_EVENT_ID).setThrowEventInstanceKey(5L).setCompensationHandlerId(COMPENSATION_HANDLER_ID).setCompensationHandlerInstanceKey(6L);
    }
}

