/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class DecisionStateMultiTenantTest {
    private MutableProcessingState processingState;
    private MutableDecisionState decisionState;

    @BeforeEach
    public void setup() {
        this.decisionState = this.processingState.getDecisionState();
    }

    @Test
    void shouldPutDrgForDifferentTenants() {
        long drgKey = 123L;
        String drgId = "drgId";
        boolean version = true;
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord("tenant1", 123L, "drgId", 1);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord("tenant2", 123L, "drgId", 1);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        Optional actualDrg1 = this.decisionState.findDecisionRequirementsByTenantAndKey("tenant1", 123L);
        Optional actualDrg2 = this.decisionState.findDecisionRequirementsByTenantAndKey("tenant2", 123L);
        this.assertDeployedDrg((DeployedDrg)actualDrg1.get(), "tenant1", 123L, "drgId", 1);
        this.assertDeployedDrg((DeployedDrg)actualDrg2.get(), "tenant2", 123L, "drgId", 1);
        actualDrg1 = this.decisionState.findLatestDecisionRequirementsByTenantAndId("tenant1", BufferUtil.wrapString((String)"drgId"));
        actualDrg2 = this.decisionState.findLatestDecisionRequirementsByTenantAndId("tenant2", BufferUtil.wrapString((String)"drgId"));
        this.assertDeployedDrg((DeployedDrg)actualDrg1.get(), "tenant1", 123L, "drgId", 1);
        this.assertDeployedDrg((DeployedDrg)actualDrg2.get(), "tenant2", 123L, "drgId", 1);
    }

    @Test
    void shouldPutDecisionForDifferentTenants() {
        long drgKey = 123L;
        String drgId = "drgId";
        long decisionKey = 456L;
        String decisionId = "decisionId";
        boolean version = true;
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord("tenant1", 123L, "drgId", 1);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord("tenant2", 123L, "drgId", 1);
        DecisionRecord decision1 = this.sampleDecisionRecord("tenant1", 456L, "decisionId", 1, 123L);
        DecisionRecord decision2 = this.sampleDecisionRecord("tenant2", 456L, "decisionId", 1, 123L);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        this.decisionState.storeDecisionRecord(decision1);
        this.decisionState.storeDecisionRecord(decision2);
        Optional actualDecision1 = this.decisionState.findDecisionByTenantAndKey("tenant1", 456L);
        Optional actualDecision2 = this.decisionState.findDecisionByTenantAndKey("tenant2", 456L);
        this.assertDecision((PersistedDecision)actualDecision1.get(), "tenant1", 456L, "decisionId", 1, 123L);
        this.assertDecision((PersistedDecision)actualDecision2.get(), "tenant2", 456L, "decisionId", 1, 123L);
        actualDecision1 = this.decisionState.findLatestDecisionByIdAndTenant(BufferUtil.wrapString((String)"decisionId"), "tenant1");
        actualDecision2 = this.decisionState.findLatestDecisionByIdAndTenant(BufferUtil.wrapString((String)"decisionId"), "tenant2");
        this.assertDecision((PersistedDecision)actualDecision1.get(), "tenant1", 456L, "decisionId", 1, 123L);
        this.assertDecision((PersistedDecision)actualDecision2.get(), "tenant2", 456L, "decisionId", 1, 123L);
        List latestDecisions1 = this.decisionState.findDecisionsByTenantAndDecisionRequirementsKey("tenant1", 123L);
        List latestDecisions2 = this.decisionState.findDecisionsByTenantAndDecisionRequirementsKey("tenant2", 123L);
        Assertions.assertThat((List)latestDecisions1).hasSize(1);
        this.assertDecision((PersistedDecision)latestDecisions1.get(0), "tenant1", 456L, "decisionId", 1, 123L);
        Assertions.assertThat((List)latestDecisions2).hasSize(1);
        this.assertDecision((PersistedDecision)latestDecisions2.get(0), "tenant2", 456L, "decisionId", 1, 123L);
    }

    @Test
    void shouldNotPutDecisionForDrgBelongingToDifferentTenant() {
        long drgKey = 123L;
        String drgId = "drgId";
        String decisionId = "decisionId";
        boolean version = true;
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        DecisionRequirementsRecord drg = this.sampleDecisionRequirementsRecord("tenant1", 123L, "drgId", 1);
        DecisionRecord decision = this.sampleDecisionRecord("tenant2", 123L, "decisionId", 1, 123L);
        this.decisionState.storeDecisionRequirements(drg);
        ZeebeDbInconsistentException exception = (ZeebeDbInconsistentException)org.junit.jupiter.api.Assertions.assertThrows(ZeebeDbInconsistentException.class, () -> this.decisionState.storeDecisionRecord(decision));
        Assertions.assertThat((Throwable)exception).hasMessage("Foreign key DbTenantAwareKey[tenantKey=%s, wrappedKey=DbLong{%d}, placementType=PREFIX] does not exist in DMN_DECISION_REQUIREMENTS".formatted("tenant2", 123L));
    }

    @Test
    void shouldDeleteDrgForTenant() {
        long drgKey = 123L;
        String drgId = "drgId";
        boolean version = true;
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord("tenant1", 123L, "drgId", 1);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord("tenant2", 123L, "drgId", 1);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        this.decisionState.deleteDecisionRequirements(drg1);
        Optional actualDrg1 = this.decisionState.findDecisionRequirementsByTenantAndKey("tenant1", 123L);
        Optional actualDrg2 = this.decisionState.findDecisionRequirementsByTenantAndKey("tenant2", 123L);
        ((OptionalAssert)Assertions.assertThat((Optional)actualDrg1).describedAs("Tenant 1 is deleted from the state", new Object[0])).isEmpty();
        ((OptionalAssert)Assertions.assertThat((Optional)actualDrg2).describedAs("Tenant 2 is not removed from the state", new Object[0])).isNotEmpty();
    }

    @Test
    void shouldDeleteDecisionForTenant() {
        long drgKey = 123L;
        String drgId = "drgId";
        long decisionKey = 456L;
        String decisionId = "decisionId";
        boolean version = true;
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord("tenant1", 123L, "drgId", 1);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord("tenant2", 123L, "drgId", 1);
        DecisionRecord decision1 = this.sampleDecisionRecord("tenant1", 456L, "decisionId", 1, 123L);
        DecisionRecord decision2 = this.sampleDecisionRecord("tenant2", 456L, "decisionId", 1, 123L);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        this.decisionState.storeDecisionRecord(decision1);
        this.decisionState.storeDecisionRecord(decision2);
        this.decisionState.deleteDecision(decision1);
        Optional actualDecision1 = this.decisionState.findDecisionByTenantAndKey("tenant1", 456L);
        Optional actualDecision2 = this.decisionState.findDecisionByTenantAndKey("tenant2", 456L);
        ((OptionalAssert)Assertions.assertThat((Optional)actualDecision1).describedAs("Tenant 1 is deleted from the state", new Object[0])).isEmpty();
        ((OptionalAssert)Assertions.assertThat((Optional)actualDecision2).describedAs("Tenant 2 is not removed from the state", new Object[0])).isNotEmpty();
    }

    private DecisionRequirementsRecord sampleDecisionRequirementsRecord(String tenantId, long key, String id, int version) {
        return new DecisionRequirementsRecord().setDecisionRequirementsId(id).setDecisionRequirementsName("drg-name").setDecisionRequirementsVersion(version).setDecisionRequirementsKey(key).setNamespace("namespace").setResourceName("resource-name").setChecksum(BufferUtil.wrapString((String)"checksum")).setResource(BufferUtil.wrapString((String)"dmn-resource")).setTenantId(tenantId);
    }

    private void assertDeployedDrg(DeployedDrg drg, String expectedTenant, long expectedKey, String expectedId, int expectedVersion) {
        Assertions.assertThat((Object)drg).extracting(new Function[]{DeployedDrg::getTenantId, DeployedDrg::getDecisionRequirementsKey, deployedDrg -> BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionRequirementsId()), DeployedDrg::getDecisionRequirementsVersion}).describedAs("Gets correct DRG for tenant", new Object[0]).containsExactly(new Object[]{expectedTenant, expectedKey, expectedId, expectedVersion});
    }

    private DecisionRecord sampleDecisionRecord(String tenantId, long key, String id, int version, long drgKey) {
        return new DecisionRecord().setDecisionId(id).setDecisionName("decision-name").setVersion(version).setDecisionKey(key).setDecisionRequirementsId("drg-id").setDecisionRequirementsKey(drgKey).setTenantId(tenantId);
    }

    private void assertDecision(PersistedDecision decision, String expectedTenant, long expectedKey, String expectedId, int expectedVersion, long expectedDrgKey) {
        Assertions.assertThat((Object)decision).extracting(new Function[]{PersistedDecision::getTenantId, PersistedDecision::getDecisionKey, deployedDrg -> BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionId()), PersistedDecision::getVersion, PersistedDecision::getDecisionRequirementsKey}).describedAs("Gets correct decision for tenant", new Object[0]).containsExactly(new Object[]{expectedTenant, expectedKey, expectedId, expectedVersion, expectedDrgKey});
    }
}

