/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.instance.EventScopeInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public final class EventScopeInstanceStateTest {
    private static final int SCOPE_KEY = 123;
    private static final Collection<DirectBuffer> NO_INTERRUPTING_ELEMENT_IDS = Collections.emptySet();
    private static final Collection<DirectBuffer> NO_BOUNDARY_ELEMENT_IDS = Collections.emptySet();
    private MutableProcessingState processingState;
    private MutableEventScopeInstanceState state;

    @BeforeEach
    void setUp() {
        this.state = this.processingState.getEventScopeInstanceState();
    }

    @Test
    void shouldCreateInterruptingEventScopeInstance() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        Set<DirectBuffer> interruptingElementIds = Collections.singleton(interruptingElementId);
        this.state.createInstance(123L, interruptingElementIds, NO_BOUNDARY_ELEMENT_IDS);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(interruptingElementId)).isTrue();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(interruptingElementId)).isFalse();
    }

    @Test
    void shouldCreateNonInterruptingEventScopeInstance() {
        DirectBuffer nonInterruptingElementId = BufferUtil.wrapString((String)"non-interrupting");
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(nonInterruptingElementId)).isFalse();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(nonInterruptingElementId)).isFalse();
    }

    @Test
    void shouldCreateEventScopeInstanceWithBoundaryEvents() {
        DirectBuffer nonInterruptingBoundaryElementId = BufferUtil.wrapString((String)"non-interrupting-boundary");
        DirectBuffer interruptingBoundaryElementId = BufferUtil.wrapString((String)"interrupting-boundary");
        Set<DirectBuffer> boundaryElementIds = Set.of(nonInterruptingBoundaryElementId, interruptingBoundaryElementId);
        Set<DirectBuffer> interruptingElementIds = Set.of(interruptingBoundaryElementId);
        this.state.createInstance(123L, interruptingElementIds, boundaryElementIds);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(nonInterruptingBoundaryElementId)).isFalse();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(nonInterruptingBoundaryElementId)).isTrue();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(interruptingBoundaryElementId)).isTrue();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(interruptingBoundaryElementId)).isTrue();
    }

    @Test
    void shouldCreateInterruptingEventScopeInstanceWithBoundaryEvents() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        Set<DirectBuffer> interruptingElementIds = Set.of(interruptingElementId);
        DirectBuffer boundaryElementId = BufferUtil.wrapString((String)"non-interrupting-boundary");
        Set<DirectBuffer> boundaryElementIds = Set.of(boundaryElementId);
        this.state.createInstance(123L, interruptingElementIds, boundaryElementIds);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(interruptingElementId)).isTrue();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(interruptingElementId)).isFalse();
        Assertions.assertThat((boolean)instance.isInterruptingElementId(boundaryElementId)).isFalse();
        Assertions.assertThat((boolean)instance.isBoundaryElementId(boundaryElementId)).isTrue();
    }

    @Test
    void shouldAllowTriggeringEventForNonInterruptingScope() {
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        boolean canTriggerEvent = this.state.canTriggerEvent(123L, BufferUtil.wrapString((String)"non-interrupting"));
        Assertions.assertThat((boolean)canTriggerEvent).isTrue();
    }

    @Test
    void shouldNotAllowTriggeringEventForInterruptedScope() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        this.state.createInstance(123L, Set.of(interruptingElementId), NO_BOUNDARY_ELEMENT_IDS);
        boolean canInterruptScope = this.state.canTriggerEvent(123L, interruptingElementId);
        Assertions.assertThat((boolean)canInterruptScope).isTrue();
        EventTrigger eventTrigger = this.createEventTrigger(BufferUtil.bufferAsString((DirectBuffer)interruptingElementId), "");
        this.triggerEvent(123L, 123L, eventTrigger, -1L);
        boolean canTriggerEventAgain = this.state.canTriggerEvent(123L, interruptingElementId);
        boolean canTriggerNonInterruptingEvent = this.state.canTriggerEvent(123L, BufferUtil.wrapString((String)"non-interrupting"));
        Assertions.assertThat((boolean)canTriggerEventAgain).isFalse();
        Assertions.assertThat((boolean)canTriggerNonInterruptingEvent).isFalse();
    }

    @Test
    void shouldAllowTriggeringBoundaryEventForInterruptedScope() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        DirectBuffer interruptingBoundaryElementId = BufferUtil.wrapString((String)"interrupting-boundary");
        DirectBuffer nonInterruptingBoundaryElementId = BufferUtil.wrapString((String)"non-interrupting-boundary");
        this.state.createInstance(123L, Set.of(interruptingElementId, interruptingBoundaryElementId), Set.of(interruptingBoundaryElementId, nonInterruptingBoundaryElementId));
        boolean canInterruptScope = this.state.canTriggerEvent(123L, interruptingElementId);
        Assertions.assertThat((boolean)canInterruptScope).isTrue();
        EventTrigger eventTrigger = this.createEventTrigger(BufferUtil.bufferAsString((DirectBuffer)interruptingElementId), "");
        this.triggerEvent(123L, 123L, eventTrigger, -1L);
        boolean canTriggerInterruptingBoundaryEvent = this.state.canTriggerEvent(123L, interruptingBoundaryElementId);
        boolean canTriggerNonInterruptingBoundaryEvent = this.state.canTriggerEvent(123L, nonInterruptingBoundaryElementId);
        Assertions.assertThat((boolean)canTriggerInterruptingBoundaryEvent).isTrue();
        Assertions.assertThat((boolean)canTriggerNonInterruptingBoundaryEvent).isTrue();
    }

    @Test
    void shouldAllowTriggeringAfterNonInterruptingBoundaryEvents() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        DirectBuffer interruptingBoundaryElementId = BufferUtil.wrapString((String)"interrupting-boundary");
        DirectBuffer nonInterruptingBoundaryElementId = BufferUtil.wrapString((String)"non-interrupting-boundary");
        this.state.createInstance(123L, Set.of(interruptingElementId), Set.of(interruptingBoundaryElementId, nonInterruptingBoundaryElementId));
        boolean canTriggerBoundaryEvent = this.state.canTriggerEvent(123L, nonInterruptingBoundaryElementId);
        Assertions.assertThat((boolean)canTriggerBoundaryEvent).isTrue();
        EventTrigger eventTrigger = this.createEventTrigger(BufferUtil.bufferAsString((DirectBuffer)nonInterruptingBoundaryElementId), "");
        this.triggerEvent(123L, 123L, eventTrigger, -1L);
        boolean canTriggerInterruptingBoundaryEvent = this.state.canTriggerEvent(123L, interruptingBoundaryElementId);
        boolean canTriggerNonInterruptingBoundaryEvent = this.state.canTriggerEvent(123L, nonInterruptingBoundaryElementId);
        boolean canTriggerInterruptingEvent = this.state.canTriggerEvent(123L, interruptingElementId);
        boolean canTriggerNonInterruptingEvent = this.state.canTriggerEvent(123L, BufferUtil.wrapString((String)"non-interrupting"));
        Assertions.assertThat((boolean)canTriggerInterruptingBoundaryEvent).isTrue();
        Assertions.assertThat((boolean)canTriggerNonInterruptingBoundaryEvent).isTrue();
        Assertions.assertThat((boolean)canTriggerInterruptingEvent).isTrue();
        Assertions.assertThat((boolean)canTriggerNonInterruptingEvent).isTrue();
    }

    @Test
    void shouldNotAllowTriggeringEventAfterInterruptingBoundaryEvent() {
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupting");
        DirectBuffer interruptingBoundaryElementId = BufferUtil.wrapString((String)"interrupting-boundary");
        DirectBuffer nonInterruptingBoundaryElementId = BufferUtil.wrapString((String)"non-interrupting-boundary");
        this.state.createInstance(123L, Set.of(interruptingElementId, interruptingBoundaryElementId), Set.of(interruptingBoundaryElementId, nonInterruptingBoundaryElementId));
        boolean canTriggerBoundaryEvent = this.state.canTriggerEvent(123L, interruptingBoundaryElementId);
        Assertions.assertThat((boolean)canTriggerBoundaryEvent).isTrue();
        EventTrigger eventTrigger = this.createEventTrigger(BufferUtil.bufferAsString((DirectBuffer)interruptingBoundaryElementId), "");
        this.triggerEvent(123L, 123L, eventTrigger, -1L);
        boolean canTriggerInterruptingBoundaryEventAgain = this.state.canTriggerEvent(123L, interruptingBoundaryElementId);
        boolean canTriggerNonInterruptingBoundaryEvent = this.state.canTriggerEvent(123L, nonInterruptingBoundaryElementId);
        boolean canTriggerInterruptingEvent = this.state.canTriggerEvent(123L, interruptingElementId);
        boolean canTriggerNonInterruptingEvent = this.state.canTriggerEvent(123L, BufferUtil.wrapString((String)"non-interrupting"));
        Assertions.assertThat((boolean)canTriggerInterruptingBoundaryEventAgain).isFalse();
        Assertions.assertThat((boolean)canTriggerNonInterruptingBoundaryEvent).isFalse();
        Assertions.assertThat((boolean)canTriggerInterruptingEvent).isFalse();
        Assertions.assertThat((boolean)canTriggerNonInterruptingEvent).isFalse();
    }

    @Test
    void shouldTriggerInterruptingEventScopeInstance() {
        long eventKey = 456L;
        EventTrigger eventTrigger = this.createEventTrigger();
        Set<DirectBuffer> interruptingElementIds = Collections.singleton(eventTrigger.getElementId());
        this.state.createInstance(123L, interruptingElementIds, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 456L, eventTrigger, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterrupted()).isTrue();
    }

    @Test
    void shouldTriggerInterruptingEventScopeInstanceOnlyOnce() {
        long eventKey1 = 456L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 789L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        Set<DirectBuffer> interruptingElementIds = Collections.singleton(eventTrigger1.getElementId());
        this.state.createInstance(123L, interruptingElementIds, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 456L, eventTrigger1, -1L);
        this.triggerEvent(123L, 789L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterrupted()).isTrue();
    }

    @Test
    void shouldTriggerNonInterruptingEventScopeInstanceMultipleTimes() {
        long eventKey1 = 456L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 789L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 456L, eventTrigger1, -1L);
        this.triggerEvent(123L, 789L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterrupted()).isFalse();
    }

    @Test
    void shouldTriggerInterruptingEventScopeAndNonInterruptingBoundaryEvent() {
        long eventKey1 = 1L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 2L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        Set<DirectBuffer> interruptingIds = Set.of(eventTrigger1.getElementId());
        Set<DirectBuffer> boundaryElementIds = Set.of(eventTrigger2.getElementId());
        this.state.createInstance(123L, interruptingIds, boundaryElementIds);
        this.triggerEvent(123L, 1L, eventTrigger1, -1L);
        this.triggerEvent(123L, 2L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isInterrupted()).isTrue();
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
    }

    @Test
    void shouldTriggerInterruptingEventScopeAndInterruptingBoundaryEvent() {
        long eventKey1 = 1L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 2L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        Set<DirectBuffer> interruptingIds = Set.of(eventTrigger1.getElementId(), eventTrigger2.getElementId());
        Set<DirectBuffer> boundaryElementIds = Set.of(eventTrigger2.getElementId());
        this.state.createInstance(123L, interruptingIds, boundaryElementIds);
        this.triggerEvent(123L, 1L, eventTrigger1, -1L);
        this.triggerEvent(123L, 2L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isInterrupted()).isTrue();
        Assertions.assertThat((boolean)instance.isAccepting()).isFalse();
    }

    @Test
    void shouldTriggerInterruptingBoundaryEventOnlyOnce() {
        long eventKey1 = 1L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 2L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        long eventKey3 = 3L;
        EventTrigger eventTrigger3 = this.createEventTrigger();
        Set<DirectBuffer> interruptingIds = Set.of(eventTrigger1.getElementId(), eventTrigger3.getElementId());
        Set<DirectBuffer> boundaryElementIds = Set.of(eventTrigger1.getElementId(), eventTrigger2.getElementId());
        this.state.createInstance(123L, interruptingIds, boundaryElementIds);
        this.triggerEvent(123L, 1L, eventTrigger1, -1L);
        this.triggerEvent(123L, 2L, eventTrigger2, -1L);
        this.triggerEvent(123L, 3L, eventTrigger3, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isInterrupted()).isTrue();
        Assertions.assertThat((boolean)instance.isAccepting()).isFalse();
    }

    @Test
    void shouldTriggerStartEventForNonExistingEventScope() {
        EventTrigger eventTrigger = this.createEventTrigger();
        this.triggerStartEvent(123L, 456L, eventTrigger, -1L);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
    }

    @Test
    void shouldPeekEventTrigger() {
        EventTrigger eventTrigger = this.createEventTrigger();
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 1L, eventTrigger, -1L);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
    }

    @Test
    void shouldPollEventTrigger() {
        EventTrigger eventTrigger1 = this.createEventTrigger();
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_INTERRUPTING_ELEMENT_IDS);
        this.triggerEvent(123L, 1L, eventTrigger1, -1L);
        this.triggerEvent(123L, 2L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    void shouldPollStartEventTrigger() {
        EventTrigger eventTrigger1 = this.createEventTrigger();
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1, -1L);
        this.triggerStartEvent(123L, 2L, eventTrigger2, -1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    void shouldStoreProcessInstanceKeyInEventTrigger() {
        EventTrigger eventTrigger = this.createEventTrigger();
        long processInstanceKey = 12345L;
        this.triggerStartEvent(123L, 1L, eventTrigger, 12345L);
        EventTrigger stateEventTrigger = this.state.peekEventTrigger(123L);
        Assertions.assertThat((long)stateEventTrigger.getProcessInstanceKey()).isEqualTo(12345L);
    }

    @Test
    void shouldDeleteTrigger() {
        long eventKey = 456L;
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 456L, this.createEventTrigger(), -1L);
        this.state.deleteTrigger(123L, 456L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    void shouldDeleteStartEventTrigger() {
        EventTrigger eventTrigger1 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1, -1L);
        this.state.deleteTrigger(123L, 1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    void shouldDeleteEventScopeAndTriggers() {
        this.state.createInstance(123L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        this.triggerEvent(123L, 1L, this.createEventTrigger(), -1L);
        this.triggerEvent(123L, 2L, this.createEventTrigger(), -1L);
        this.triggerEvent(123L, 3L, this.createEventTrigger(), -1L);
        this.state.deleteInstance(123L);
        Assertions.assertThat((Object)this.state.getInstance(123L)).isNull();
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isNull();
    }

    @Test
    void shouldDeleteStartEventTriggerOnDeletionOfInstance() {
        EventTrigger eventTrigger1 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1, -1L);
        this.state.deleteInstance(123L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    void shouldNotFailOnDeletionOfNonExistingInstance() {
        Assertions.assertThatNoException().isThrownBy(() -> this.state.deleteInstance(123L));
    }

    @Test
    void shouldResetEventScopeAfterCreation() {
        long firstKey = 123L;
        long secondKey = 345L;
        DirectBuffer interruptingElementId = BufferUtil.wrapString((String)"interrupt");
        Set<DirectBuffer> interruptingElementIds = Set.of(interruptingElementId);
        DirectBuffer boundaryElementId = BufferUtil.wrapString((String)"boundary");
        Set<DirectBuffer> boundaryElementIds = Set.of(boundaryElementId);
        this.state.createInstance(123L, interruptingElementIds, boundaryElementIds);
        this.state.createInstance(345L, NO_INTERRUPTING_ELEMENT_IDS, NO_BOUNDARY_ELEMENT_IDS);
        EventScopeInstance firstEventScopeInstance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)firstEventScopeInstance.isInterruptingElementId(interruptingElementId)).isTrue();
        Assertions.assertThat((boolean)firstEventScopeInstance.isBoundaryElementId(boundaryElementId)).isTrue();
        EventScopeInstance secondEventScopeInstance = this.state.getInstance(345L);
        Assertions.assertThat((boolean)secondEventScopeInstance.isInterruptingElementId(interruptingElementId)).isFalse();
        Assertions.assertThat((boolean)secondEventScopeInstance.isBoundaryElementId(boundaryElementId)).isFalse();
    }

    private void triggerEvent(long eventScopeKey, long eventKey, EventTrigger eventTrigger, long processInstanceKey) {
        this.state.triggerEvent(eventScopeKey, eventKey, eventTrigger.getElementId(), eventTrigger.getVariables(), processInstanceKey);
    }

    private void triggerStartEvent(long eventScopeKey, long eventKey, EventTrigger eventTrigger, long processInstanceKey) {
        this.state.triggerStartEvent(eventScopeKey, eventKey, eventTrigger.getElementId(), eventTrigger.getVariables(), processInstanceKey);
    }

    private EventTrigger createEventTrigger() {
        return this.createEventTrigger(this.randomString(), this.randomString());
    }

    private EventTrigger createEventTrigger(String elementId, String variables) {
        return new EventTrigger().setElementId(BufferUtil.wrapString((String)elementId)).setVariables(BufferUtil.wrapString((String)variables));
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }
}

