/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class NumberOfTakenSequenceFlowsStateTest {
    private static final long FLOW_SCOPE_KEY = 1L;
    private static final long OTHER_FLOW_SCOPE_KEY = 2L;
    private static final DirectBuffer GATEWAY_ELEMENT_ID = BufferUtil.wrapString((String)"gateway-1");
    private static final DirectBuffer OTHER_GATEWAY_ELEMENT_ID = BufferUtil.wrapString((String)"gateway-2");
    private static final DirectBuffer SEQUENCE_FLOW_ELEMENT_ID = BufferUtil.wrapString((String)"flow-1");
    private static final DirectBuffer OTHER_SEQUENCE_FLOW_ELEMENT_ID = BufferUtil.wrapString((String)"flow-2");
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableElementInstanceState elementInstanceState;
    private MutableProcessingState processingState;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.elementInstanceState = this.processingState.getElementInstanceState();
    }

    @Test
    public void shouldReturnZeroIfNoSequenceFlowIsTaken() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, OTHER_GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(2L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isZero();
    }

    @Test
    public void shouldIncrementNumber() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, OTHER_SEQUENCE_FLOW_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isEqualTo(2);
        int numberOfOtherScope = this.elementInstanceState.getNumberOfTakenSequenceFlows(2L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)numberOfOtherScope).isZero();
        int numberOfOtherGateway = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, OTHER_GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)numberOfOtherGateway).isZero();
    }

    @Test
    public void shouldReturnNumberPerTakenSequenceFlows() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, OTHER_SEQUENCE_FLOW_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isEqualTo(2);
    }

    @Test
    public void shouldDecrementNumbers() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, OTHER_SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(2L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, OTHER_GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.decrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isZero();
        int numberOfOtherScope = this.elementInstanceState.getNumberOfTakenSequenceFlows(2L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)numberOfOtherScope).isEqualTo(1);
        int numberOfOtherGateway = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, OTHER_GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)numberOfOtherGateway).isEqualTo(1);
    }

    @Test
    public void shouldDecrementNumbersButKeepRemaining() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, OTHER_SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.decrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isEqualTo(1);
    }

    @Test
    public void shouldRemoveNumbersWhenDecrementing() {
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, OTHER_SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.decrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isZero();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.processingState.isEmpty(ZbColumnFamilies.NUMBER_OF_TAKEN_SEQUENCE_FLOWS)).describedAs("Expected the entries to be removed", new Object[0])).isTrue();
    }

    @Test
    public void shouldRemoveNumbersWhenRemovingTheScope() {
        this.elementInstanceState.newInstance(1L, new ProcessInstanceRecord(), ProcessInstanceIntent.ELEMENT_ACTIVATED);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.incrementNumberOfTakenSequenceFlows(1L, OTHER_GATEWAY_ELEMENT_ID, SEQUENCE_FLOW_ELEMENT_ID);
        this.elementInstanceState.removeInstance(1L);
        int number = this.elementInstanceState.getNumberOfTakenSequenceFlows(1L, GATEWAY_ELEMENT_ID);
        Assertions.assertThat((int)number).isZero();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.processingState.isEmpty(ZbColumnFamilies.NUMBER_OF_TAKEN_SEQUENCE_FLOWS)).describedAs("Expected the entries to be removed", new Object[0])).isTrue();
    }
}

