/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class MessageStateTest {
    private static final String DEFAULT_TENANT = "<default>";
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableMessageState messageState;
    private MutableProcessingState processingState;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.messageState = this.processingState.getMessageState();
    }

    @Test
    public void shouldNotExistIfNameDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"otherName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotExistIfCorrelationKeyDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), BufferUtil.wrapString((String)"id"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotExistIfMessageIdDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), BufferUtil.wrapString((String)"otherId"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldExist() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isTrue();
    }

    @Test
    public void shouldVisitMessages() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList messages = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), messages::add);
        Assertions.assertThat(messages).hasSize(1);
        Assertions.assertThat((long)((StoredMessage)messages.get(0)).getMessageKey()).isEqualTo(1L);
        Assertions.assertThat((String)((StoredMessage)messages.get(0)).getMessage().getName()).isEqualTo(message.getName());
        Assertions.assertThat((String)((StoredMessage)messages.get(0)).getMessage().getCorrelationKey()).isEqualTo(message.getCorrelationKey());
    }

    @Test
    public void shouldVisitMessagesInOrder() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        MessageRecord message2 = this.createMessage("name", "correlationKey");
        this.messageState.put(2L, message2);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldVisitMessagesUntilStop() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        MessageRecord message2 = this.createMessage("name", "correlationKey");
        this.messageState.put(2L, message2);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> {
            keys.add(m.getMessageKey());
            return false;
        });
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldNotVisitMessagesIfNameDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"otherName"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldNotVisitMessageIfCorrelationKeyDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldVisitMessagesUntilVisitorReturnsFalse() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("otherName", "correlationKey", "{}", "nr2", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        boolean isStoppedByVisitor = this.messageState.visitMessagesWithDeadlineBeforeTimestamp(3456L, null, (deadline, e) -> {
            readMessage.add(e);
            return false;
        });
        ((ListAssert)Assertions.assertThat(readMessage).hasSize(1)).containsExactly((Object[])new Long[]{1L});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isStoppedByVisitor).describedAs("Expect that the visiting stopped because of the visitor", new Object[0])).isTrue();
    }

    @Test
    public void shouldVisitMessagesWhileVisitorReturnsTrue() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("otherName", "correlationKey", "{}", "nr2", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        boolean isStoppedByVisitor = this.messageState.visitMessagesWithDeadlineBeforeTimestamp(1900L, null, (deadline, e) -> {
            readMessage.add(e);
            return true;
        });
        ((ListAssert)Assertions.assertThat(readMessage).hasSize(1)).containsExactly((Object[])new Long[]{1L});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isStoppedByVisitor).describedAs("Expect that the visiting is stopped because there are no more entries before the timestamp", new Object[0])).isFalse();
    }

    @Test
    public void shouldNotVisitMessagesBeforeTime() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "nr2", 4567L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(1000L, null, (deadline, e) -> readMessage.add(e));
        Assertions.assertThat(readMessage).isEmpty();
    }

    @Test
    public void shouldVisitMessagesBeforeTime() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("otherName", "correlationKey", "{}", "nr2", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(1999L, null, (deadline, e) -> readMessage.add(e));
        Assertions.assertThat((int)readMessage.size()).isEqualTo(1);
        Assertions.assertThat((Long)((Long)readMessage.get(0))).isEqualTo(1L);
    }

    @Test
    public void shouldVisitMessagesBeforeTimeInOrder() {
        long now = ActorClock.currentTimeMillis();
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "nr1", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        long deadline = now + 3000L;
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(deadline, null, (d, m) -> readMessage.add(m));
        Assertions.assertThat((int)readMessage.size()).isEqualTo(2);
        Assertions.assertThat(readMessage).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldVisitMessagesBeforeTimeStartingAtIndex() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("otherName", "correlationKey", "{}", "nr2", 2000L);
        MessageRecord message3 = this.createMessage("anotherName", "correlationKey", "{}", "nr3", 2500L);
        MessageRecord message4 = this.createMessage("yetAnotherName", "correlationKey", "{}", "nr4", 3456L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        this.messageState.put(3L, message3);
        this.messageState.put(4L, message4);
        MutableObject lastIndex = new MutableObject();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(2999L, null, (deadline, key) -> {
            boolean shouldContinue = lastIndex.getValue() == null;
            lastIndex.setValue((Object)new MessageState.Index(key, deadline));
            return shouldContinue;
        });
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(2999L, (MessageState.Index)lastIndex.getValue(), (deadline, e) -> readMessage.add(e));
        ((ListAssert)((ListAssert)Assertions.assertThat(readMessage).hasSize(2)).containsExactly((Object[])new Long[]{2L, 3L})).doesNotContain((Object[])new Long[]{1L, 4L});
    }

    @Test
    public void shouldRemoveMessage() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id", 1234L);
        this.messageState.put(1L, message);
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"b"));
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(2000L, null, (deadline, e) -> readMessages.add(e));
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"b"))).isFalse();
    }

    @Test
    public void shouldRemoveMessageWithoutId() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(2000L, null, (deadline, e) -> readMessages.add(e));
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldNotFailOnRemoveMessageTwice() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id", 1234L);
        this.messageState.put(1L, message);
        this.messageState.remove(1L);
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(2000L, null, (deadline, e) -> readMessages.add(e));
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotRemoveDifferentMessage() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "id2", 4567L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        this.messageState.putMessageCorrelation(2L, BufferUtil.wrapString((String)"b"));
        this.messageState.remove(2L);
        long deadline = ActorClock.currentTimeMillis() + 2000L;
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBeforeTimestamp(deadline, null, (d, e) -> readMessages.add(e));
        Assertions.assertThat((int)readMessages.size()).isEqualTo(1);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(DEFAULT_TENANT, BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id1"), DEFAULT_TENANT);
        Assertions.assertThat((boolean)exist).isTrue();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isTrue();
    }

    @Test
    public void shouldExistCorrelatedMessage() {
        long messageKey = 1L;
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id1", 1234L);
        this.messageState.put(1L, message);
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(2L, BufferUtil.wrapString((String)"a"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"b"))).isFalse();
    }

    @Test
    public void shouldRemoveMessageCorrelation() {
        long messageKey = 6L;
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id1", 1234L);
        this.messageState.put(6L, message);
        this.messageState.putMessageCorrelation(6L, BufferUtil.wrapString((String)"a"));
        this.messageState.removeMessageCorrelation(6L, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(6L, BufferUtil.wrapString((String)"a"))).isFalse();
    }

    @Test
    public void shouldExistActiveProcessInstance() {
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"))).isFalse();
    }

    @Test
    public void shouldRemoveActiveProcessInstance() {
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"));
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"));
        this.messageState.removeActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(DEFAULT_TENANT, BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"))).isTrue();
    }

    @Test
    public void shouldGetProcessInstanceCorrelationKey() {
        this.messageState.putProcessInstanceCorrelationKey(1L, BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(1L)).isEqualTo((Object)BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(2L)).isNull();
    }

    @Test
    public void shouldRemoveProcessInstanceCorrelationKey() {
        this.messageState.putProcessInstanceCorrelationKey(1L, BufferUtil.wrapString((String)"key-1"));
        this.messageState.putProcessInstanceCorrelationKey(2L, BufferUtil.wrapString((String)"key-2"));
        this.messageState.removeProcessInstanceCorrelationKey(1L);
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(1L)).isNull();
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(2L)).isEqualTo((Object)BufferUtil.wrapString((String)"key-2"));
    }

    private MessageRecord createMessage(String name, String correlationKey) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setTimeToLive(10000L).setDeadline(0L);
    }

    private MessageRecord createMessage(String name, String correlationKey, String variables, String id) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setTimeToLive(10000L).setVariables(MsgPackUtil.asMsgPack((String)variables)).setMessageId(id);
    }

    private MessageRecord createMessage(String name, String correlationKey, String variables, String id, long deadline) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setVariables(MsgPackUtil.asMsgPack((String)variables)).setMessageId(id).setDeadline(deadline).setTimeToLive(10000L);
    }
}

