/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TransientPendingSubscriptionStateTest {
    private TransientPendingSubscriptionState sut;

    @BeforeEach
    public void setUp() {
        this.sut = new TransientPendingSubscriptionState();
    }

    @Test
    public void shouldReturnNoEntriesByDefault() {
        Iterable actual = this.sut.entriesBefore(Long.MAX_VALUE);
        Assertions.assertThat((Iterable)actual).isEmpty();
    }

    @Test
    public void shouldReturnEntriesBeforeDeadline() {
        TransientPendingSubscriptionState.PendingSubscription expected = new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>");
        this.sut.add(expected, 500L);
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(2L, "message", "<default>"), 2000L);
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientPendingSubscriptionState.PendingSubscription[]{expected});
    }

    @Test
    public void shouldReturnEntriesOrderedBySentTime() {
        TransientPendingSubscriptionState.PendingSubscription first = new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>");
        TransientPendingSubscriptionState.PendingSubscription second = new TransientPendingSubscriptionState.PendingSubscription(2L, "message", "<default>");
        TransientPendingSubscriptionState.PendingSubscription third = new TransientPendingSubscriptionState.PendingSubscription(3L, "message", "<default>");
        this.sut.add(second, 600L);
        this.sut.add(first, 500L);
        this.sut.add(third, 700L);
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientPendingSubscriptionState.PendingSubscription[]{first, second, third});
    }

    @Test
    public void shouldOverwriteExistingEntries() {
        TransientPendingSubscriptionState.PendingSubscription subscription = new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>");
        this.sut.add(subscription, 500L);
        this.sut.add(subscription, 600L);
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientPendingSubscriptionState.PendingSubscription[]{subscription});
    }

    @Test
    public void shouldAcceptEntriesWithTheSameSentTime() {
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>"), 500L);
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(2L, "message", "<default>"), 500L);
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).hasSize(2);
    }

    @Test
    public void shouldReturnEntriesBasedOnUpdatedSentTime() {
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>"), 2000L);
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(2L, "message", "<default>"), 3000L);
        TransientPendingSubscriptionState.PendingSubscription expected = new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>");
        this.sut.update(expected, 500L);
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientPendingSubscriptionState.PendingSubscription[]{expected});
    }

    @Test
    public void shouldNotReturnEntriesThatHaveBeenRemoved() {
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>"), 500L);
        this.sut.add(new TransientPendingSubscriptionState.PendingSubscription(2L, "message", "<default>"), 2000L);
        this.sut.remove(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>"));
        Iterable actual = this.sut.entriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).isEmpty();
    }

    @Test
    public void shouldBeTolerantWhenRemovingEntriesThatDoNotExist() {
        Assertions.assertThatNoException().isThrownBy(() -> this.sut.remove(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>")));
    }

    @Test
    public void shouldBeTolerantWhenUpdatingEntriesThatDoNotExist() {
        Assertions.assertThatNoException().isThrownBy(() -> this.sut.update(new TransientPendingSubscriptionState.PendingSubscription(1L, "message", "<default>"), 500L));
    }
}

