/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.util.VersionUtil;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DbMigratorImplTest {
    @Test
    void shouldRunMigrationThatNeedsToBeRun() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration)).runMigration(mockProcessingState);
    }

    @Test
    void shouldNotRunMigrationThatDoesNotNeedToBeRun() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)false);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration(mockProcessingState);
    }

    @Test
    void shouldRunMigrationsInOrder() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, List.of(mockMigration1, mockMigration2));
        sut.runMigrations();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockMigration1, mockMigration2});
        ((MigrationTask)inOrder.verify((Object)mockMigration1)).runMigration(mockProcessingState);
        ((MigrationTask)inOrder.verify((Object)mockMigration2)).runMigration(mockProcessingState);
    }

    @Test
    void shouldNotSetVersionIfFirstMigrationFails() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, List.of(mockMigration1, mockMigration2));
        ((MigrationTask)Mockito.doThrow(RuntimeException.class).when((Object)mockMigration1)).runMigration(mockProcessingState);
        Assertions.assertThatThrownBy(() -> ((DbMigratorImpl)sut).runMigrations()).isInstanceOf(RuntimeException.class);
        ((MigrationTask)Mockito.verify((Object)mockMigration2, (VerificationMode)Mockito.never())).runMigration((MutableProcessingState)ArgumentMatchers.any());
        ((MutableMigrationState)Mockito.verify((Object)mockMigrationState, (VerificationMode)Mockito.never())).setMigratedByVersion((String)ArgumentMatchers.any());
    }

    @Test
    void shouldNotSetVersionIfSecondMigrationFails() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, List.of(mockMigration1, mockMigration2));
        ((MigrationTask)Mockito.doThrow(RuntimeException.class).when((Object)mockMigration2)).runMigration(mockProcessingState);
        Assertions.assertThatThrownBy(() -> ((DbMigratorImpl)sut).runMigrations()).isInstanceOf(RuntimeException.class);
        ((MutableMigrationState)Mockito.verify((Object)mockMigrationState, (VerificationMode)Mockito.never())).setMigratedByVersion((String)ArgumentMatchers.any());
    }

    @Test
    void shouldSetVersionAfterRunningMigrations() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, List.of(mockMigration1, mockMigration2));
        sut.runMigrations();
        ((MutableMigrationState)Mockito.verify((Object)mockMigrationState)).setMigratedByVersion(VersionUtil.getVersion());
    }

    @Test
    void shouldThrowOnInvalidUpgrade() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        Mockito.when((Object)mockMigrationState.getMigratedByVersion()).thenReturn((Object)"1.0.0");
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        try (MockedStatic util = Mockito.mockStatic(VersionUtil.class);){
            util.when(VersionUtil::getVersion).thenReturn((Object)"2.0.0");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DbMigratorImpl)sut).runMigrations()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Snapshot is not compatible with current version");
        }
        util = Mockito.mockStatic(VersionUtil.class);
        try {
            util.when(VersionUtil::getVersion).thenReturn((Object)"2.0.0-alpha1");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DbMigratorImpl)sut).runMigrations()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Cannot upgrade to or from a pre-release version");
        }
        finally {
            if (util != null) {
                util.close();
            }
        }
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration(mockProcessingState);
    }

    @Test
    void shouldNotRunMigrationsIfTheSameVersion() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        String currentVersion = VersionUtil.getVersion();
        Mockito.when((Object)mockMigrationState.getMigratedByVersion()).thenReturn((Object)currentVersion);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration(mockProcessingState);
    }
}

