/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.VersionCompatibilityCheck;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class VersionCompatibilityCheckTest {
    VersionCompatibilityCheckTest() {
    }

    @Nested
    final class CompatibleResults {
        CompatibleResults(VersionCompatibilityCheckTest this$0) {
        }

        @Test
        void shouldAcceptPatchUpgrades() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"8.0.1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.PatchUpgrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.4", (String)"8.1.5")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.PatchUpgrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.4", (String)"8.1.8")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.PatchUpgrade.class);
        }

        @Test
        void shouldAcceptMinorUpgrades() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"8.1.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.MinorUpgrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.3", (String)"8.2.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.MinorUpgrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.3", (String)"8.2.5")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.MinorUpgrade.class);
        }

        @Test
        void shouldAcceptSameVersions() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"8.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.SameVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.0.0-alpha1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.SameVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.0-alpha1+build123", (String)"8.1.0-alpha1+build234")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Compatible.SameVersion.class);
        }
    }

    @Nested
    final class IndeterminateResults {
        IndeterminateResults(VersionCompatibilityCheckTest this$0) {
        }

        @Test
        void shouldDetectUnknownVersions() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check(null, (String)"8.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Indeterminate.PreviousVersionUnknown.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", null)).isInstanceOf(VersionCompatibilityCheck.CheckResult.Indeterminate.CurrentVersionUnknown.class);
        }

        @Test
        void shouldDetectInvalidVersions() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"dev", (String)"1.2.3")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Indeterminate.PreviousVersionInvalid.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"1.2.3", (String)"dev")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Indeterminate.CurrentVersionInvalid.class);
        }
    }

    @Nested
    final class IncompatibleResults {
        IncompatibleResults(VersionCompatibilityCheckTest this$0) {
        }

        @Test
        public void shouldRejectUpgradeToPreRelease() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"8.0.0-alpha1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.1", (String)"8.1.0-alpha1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
        }

        @Test
        public void shouldRejectChangeOfPreRelease() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.0.0-alpha2")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.0.0-beta1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-beta1", (String)"8.0.0-rc1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-rc1", (String)"8.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.1.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha2", (String)"8.0.1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
        }

        @Test
        public void shouldRejectUpgradeFromPreRelease() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-alpha1", (String)"8.0.1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-beta1", (String)"8.0.1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0-rc1", (String)"8.1.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.5.3", (String)"8.5.3-alpha1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.0", (String)"8.1.0-alpha1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class);
        }

        @Test
        public void shouldRejectDowngrades() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"9.0.0", (String)"8.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MajorDowngrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"9.0.0", (String)"8.1.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MajorDowngrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.5.0", (String)"8.4.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MinorDowngrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.5.0", (String)"8.4.1")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MinorDowngrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.5.3", (String)"8.5.2")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.PatchDowngrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.5.3", (String)"8.5.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.PatchDowngrade.class);
        }

        @Test
        public void shouldRejectMajorUpgrades() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"9.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MajorUpgrade.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.1.0", (String)"9.0.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.MajorUpgrade.class);
        }

        @Test
        public void shouldRejectSkippedMinorVersions() {
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.0", (String)"8.2.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.SkippedMinorVersion.class);
            Assertions.assertThat((Object)VersionCompatibilityCheck.check((String)"8.0.2", (String)"8.3.0")).isInstanceOf(VersionCompatibilityCheck.CheckResult.Incompatible.SkippedMinorVersion.class);
        }
    }
}

