/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.ProcessMessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyDbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.TestUtilities;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ProcessMessageSubscriptionSentTimeMigrationTest {
    final ProcessMessageSubscriptionSentTimeMigration sutMigration = new ProcessMessageSubscriptionSentTimeMigration();

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    public class BlackboxTest {
        private static final long TEST_SENT_TIME = 1000L;
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;

        @BeforeEach
        public void setUp() {
            LegacyDbProcessMessageSubscriptionState legacySubscriptionState = new LegacyDbProcessMessageSubscriptionState(this.zeebeDb, this.transactionContext);
            LegacyProcessMessageSubscription openingProcessMessageSubscription = TestUtilities.createLegacyProcessMessageSubscription(100L, 1L);
            legacySubscriptionState.put(openingProcessMessageSubscription.getKey(), openingProcessMessageSubscription.getRecord(), 1000L);
        }

        @Test
        public void migrationNeedsToRun() {
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isTrue();
        }

        @Test
        public void afterMigrationRunNoFurtherMigrationIsNeeded() {
            ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.runMigration(this.processingState);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isFalse();
        }
    }

    @Nested
    public class MockBasedTests {
        @Test
        public void noMigrationNeededWhenColumnIsEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME)).thenReturn((Object)true);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void migrationNeededWhenColumnIsNotEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME)).thenReturn((Object)false);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        public void migrationCallsMethodInMigrationState() {
            MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.runMigration(mockProcessingState);
            ((MutableMigrationState)Mockito.verify((Object)mockProcessingState.getMigrationState())).migrateProcessMessageSubscriptionSentTime(mockProcessingState.getProcessMessageSubscriptionState(), mockProcessingState.getPendingProcessMessageSubscriptionState());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProcessingState.getMigrationState()});
        }
    }
}

