/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_5;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.migration.MigrationTaskState;
import io.camunda.zeebe.engine.state.migration.to_8_5.ColumnFamilyPrefixCorrectionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamily48Corrector;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamily49Corrector;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamily50Corrector;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

public class ColumnFamilyPrefixCorrectionMigrationTest {
    public static final String EXAMPLE_IDENTIFIER = new ColumnFamilyPrefixCorrectionMigration().getIdentifier();

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class ColumnFamily50CorrectorTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private ColumnFamily50Corrector sut;
        private DbString migrationIdentifier;
        private MigrationTaskState migrationTaskState;
        private ColumnFamily<DbString, MigrationTaskState> wrongMigrationStateColumnFamily;
        private ColumnFamily<DbString, MigrationTaskState> correctMigrationStateColumnFamily;
        private DbLong subscriptionKey;
        private DbString signalName;
        private DbCompositeKey<DbString, DbLong> signalNameAndSubscriptionKey;
        private SignalSubscription signalSubscription;
        private ColumnFamily<DbCompositeKey<DbString, DbLong>, SignalSubscription> correctSignalSubscriptionColumnFamily;

        ColumnFamily50CorrectorTest(ColumnFamilyPrefixCorrectionMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.sut = new ColumnFamily50Corrector(this.zeebeDb, this.transactionContext);
            this.migrationIdentifier = new DbString();
            this.migrationTaskState = new MigrationTaskState();
            this.wrongMigrationStateColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, this.transactionContext, (DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.correctMigrationStateColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MIGRATIONS_STATE, this.transactionContext, (DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.subscriptionKey = new DbLong();
            this.signalName = new DbString();
            this.signalNameAndSubscriptionKey = new DbCompositeKey((DbKey)this.signalName, (DbKey)this.subscriptionKey);
            this.signalSubscription = new SignalSubscription();
            this.correctSignalSubscriptionColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, this.transactionContext, this.signalNameAndSubscriptionKey, (DbValue)this.signalSubscription);
        }

        @Test
        void shouldMoveMigrationStateToCorrectColumnFamily() {
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.FINISHED);
            this.wrongMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMigrationStateColumnFamily.isEmpty()).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.FINISHED);
        }

        @Test
        void shouldMergeWithCorrectMigrationStateOverwritingWhenFinished() {
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.FINISHED);
            this.wrongMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.NOT_STARTED);
            this.correctMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMigrationStateColumnFamily.isEmpty()).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.FINISHED);
        }

        @Test
        void shouldMergeWithCorrectMigrationStateNotOverwritingAlreadyFinishedState() {
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.NOT_STARTED);
            this.wrongMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.FINISHED);
            this.correctMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMigrationStateColumnFamily.isEmpty()).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.FINISHED);
        }

        @Test
        void shouldMergeWithCorrectMigrationStateNotOverwritingDifferentIdentifiers() {
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.NOT_STARTED);
            this.wrongMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER + "2");
            this.migrationTaskState.setState(MigrationTaskState.State.FINISHED);
            this.correctMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMigrationStateColumnFamily.isEmpty()).isTrue();
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.NOT_STARTED);
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER + "2");
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.FINISHED);
        }

        @Test
        void shouldIgnoreSignalSubscriptionEntries() {
            this.signalName.wrapString("signal");
            this.subscriptionKey.wrapLong(123L);
            this.signalSubscription.setKey(123L).setRecord(new SignalSubscriptionRecord().setSignalName(BufferUtil.wrapString((String)"signal")));
            this.correctSignalSubscriptionColumnFamily.insert(this.signalNameAndSubscriptionKey, (DbValue)this.signalSubscription);
            this.migrationIdentifier.wrapString(EXAMPLE_IDENTIFIER);
            this.migrationTaskState.setState(MigrationTaskState.State.FINISHED);
            this.wrongMigrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
            this.signalName.wrapString("signal2");
            this.subscriptionKey.wrapLong(234L);
            this.signalSubscription.setKey(234L).setRecord(new SignalSubscriptionRecord().setSignalName(BufferUtil.wrapString((String)"signal2")));
            this.correctSignalSubscriptionColumnFamily.insert(this.signalNameAndSubscriptionKey, (DbValue)this.signalSubscription);
            Assertions.assertThat((long)this.correctSignalSubscriptionColumnFamily.count()).isEqualTo(3L);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((long)this.correctSignalSubscriptionColumnFamily.count()).isEqualTo(2L);
            this.signalName.wrapString("signal");
            this.subscriptionKey.wrapLong(123L);
            ((ObjectAssert)Assertions.assertThat((Object)((SignalSubscription)this.correctSignalSubscriptionColumnFamily.get(this.signalNameAndSubscriptionKey))).isNotNull()).extracting(new Function[]{SignalSubscription::getKey, s -> s.getRecord().getSignalName()}).isEqualTo(List.of(Long.valueOf(123L), "signal"));
            this.signalName.wrapString("signal2");
            this.subscriptionKey.wrapLong(234L);
            ((ObjectAssert)Assertions.assertThat((Object)((SignalSubscription)this.correctSignalSubscriptionColumnFamily.get(this.signalNameAndSubscriptionKey))).isNotNull()).extracting(new Function[]{SignalSubscription::getKey, s -> s.getRecord().getSignalName()}).isEqualTo(List.of(Long.valueOf(234L), "signal2"));
            ((ObjectAssert)Assertions.assertThat((Object)((MigrationTaskState)this.correctMigrationStateColumnFamily.get((DbKey)this.migrationIdentifier))).isNotNull()).extracting(MigrationTaskState::getState).isEqualTo((Object)MigrationTaskState.State.FINISHED);
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class ColumnFamily49CorrectorTestTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private ColumnFamily49Corrector sut;
        private DbLong elementInstanceKey;
        private DbLong processDefinitionKey;
        private DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey;
        private ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> wrongPiKeyByProcDefKeyColumnFamily;
        private ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> correctPiKeyByProcDefKeyColumnFamily;
        private DbString decisionRequirementsId;
        private DbInt decisionRequirementsVersion;
        private DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
        private DbLong decisionRequirementsKey;
        private ColumnFamily<DbCompositeKey<DbString, DbInt>, DbLong> correctDecisionRequirementsKeyColumnFamily;

        ColumnFamily49CorrectorTestTest(ColumnFamilyPrefixCorrectionMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.sut = new ColumnFamily49Corrector(this.zeebeDb, this.transactionContext);
            this.elementInstanceKey = new DbLong();
            this.processDefinitionKey = new DbLong();
            this.processInstanceKeyByProcessDefinitionKey = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.elementInstanceKey);
            this.wrongPiKeyByProcDefKeyColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, this.transactionContext, this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.correctPiKeyByProcDefKeyColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY, this.transactionContext, this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.decisionRequirementsId = new DbString();
            this.decisionRequirementsVersion = new DbInt();
            this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.decisionRequirementsId, (DbKey)this.decisionRequirementsVersion);
            this.decisionRequirementsKey = new DbLong();
            this.correctDecisionRequirementsKeyColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, this.transactionContext, this.decisionRequirementsIdAndVersion, (DbValue)this.decisionRequirementsKey);
        }

        @Test
        void shouldMovePiKeyByProcDefKeyToCorrectColumnFamily() {
            this.elementInstanceKey.wrapLong(123L);
            this.processDefinitionKey.wrapLong(456L);
            this.wrongPiKeyByProcDefKeyColumnFamily.insert(this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongPiKeyByProcDefKeyColumnFamily.isEmpty()).isTrue();
            Assertions.assertThat((boolean)this.correctPiKeyByProcDefKeyColumnFamily.exists(this.processInstanceKeyByProcessDefinitionKey)).isTrue();
        }

        @Test
        void shouldIgnoreProcessInstanceKeyByDefinitionKeyEntries() {
            this.decisionRequirementsId.wrapString("drg");
            this.decisionRequirementsVersion.wrapInt(1);
            this.decisionRequirementsKey.wrapLong(543L);
            this.correctDecisionRequirementsKeyColumnFamily.insert(this.decisionRequirementsIdAndVersion, (DbValue)this.decisionRequirementsKey);
            this.elementInstanceKey.wrapLong(123L);
            this.processDefinitionKey.wrapLong(456L);
            this.wrongPiKeyByProcDefKeyColumnFamily.insert(this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.decisionRequirementsId.wrapString("drg2");
            this.decisionRequirementsVersion.wrapInt(2);
            this.decisionRequirementsKey.wrapLong(987L);
            this.correctDecisionRequirementsKeyColumnFamily.insert(this.decisionRequirementsIdAndVersion, (DbValue)this.decisionRequirementsKey);
            Assertions.assertThat((long)this.correctDecisionRequirementsKeyColumnFamily.count()).isEqualTo(3L);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((long)this.correctDecisionRequirementsKeyColumnFamily.count()).isEqualTo(2L);
            this.elementInstanceKey.wrapLong(123L);
            this.processDefinitionKey.wrapLong(456L);
            Assertions.assertThat((boolean)this.correctPiKeyByProcDefKeyColumnFamily.exists(this.processInstanceKeyByProcessDefinitionKey)).isTrue();
            this.decisionRequirementsId.wrapString("drg");
            this.decisionRequirementsVersion.wrapInt(1);
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctDecisionRequirementsKeyColumnFamily.get(this.decisionRequirementsIdAndVersion))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)543L);
            this.decisionRequirementsId.wrapString("drg2");
            this.decisionRequirementsVersion.wrapInt(2);
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctDecisionRequirementsKeyColumnFamily.get(this.decisionRequirementsIdAndVersion))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)987L);
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class ColumnFamily48CorrectorTestTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private ColumnFamily48Corrector sut;
        private ColumnFamily<DbString, DbLong> wrongMessageStatsColumnFamily;
        private DbString messagesDeadlineCountKey;
        private DbLong messagesDeadlineCount;
        private ColumnFamily<DbString, DbLong> correctMessageStatsColumnFamily;
        private ColumnFamily<DbCompositeKey<DbString, DbInt>, DbLong> correctDecisionColumnFamily;
        private DbString decisionId;
        private DbInt decisionVersion;
        private DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
        private DbLong decisionKey;

        ColumnFamily48CorrectorTestTest(ColumnFamilyPrefixCorrectionMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.sut = new ColumnFamily48Corrector(this.zeebeDb, this.transactionContext);
            this.messagesDeadlineCountKey = new DbString();
            this.messagesDeadlineCountKey.wrapString("deadline_message_count");
            this.messagesDeadlineCount = new DbLong();
            this.wrongMessageStatsColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, this.transactionContext, (DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
            this.correctMessageStatsColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_STATS, this.transactionContext, (DbKey)new DbString(), (DbValue)new DbLong());
            this.decisionId = new DbString();
            this.decisionVersion = new DbInt();
            this.decisionIdAndVersion = new DbCompositeKey((DbKey)this.decisionId, (DbKey)this.decisionVersion);
            this.decisionKey = new DbLong();
            this.correctDecisionColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, this.transactionContext, this.decisionIdAndVersion, (DbValue)this.decisionKey);
        }

        @Test
        void shouldMoveMessageStatsToCorrectColumnFamily() {
            this.messagesDeadlineCount.wrapLong(123L);
            this.wrongMessageStatsColumnFamily.insert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMessageStatsColumnFamily.isEmpty()).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctMessageStatsColumnFamily.get((DbKey)this.messagesDeadlineCountKey))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)123L);
        }

        @Test
        void shouldMergeWithCorrectMessageStats() {
            this.messagesDeadlineCount.wrapLong(123L);
            this.wrongMessageStatsColumnFamily.insert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
            this.messagesDeadlineCount.wrapLong(456L);
            this.correctMessageStatsColumnFamily.insert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((boolean)this.wrongMessageStatsColumnFamily.isEmpty()).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctMessageStatsColumnFamily.get((DbKey)this.messagesDeadlineCountKey))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)579L);
        }

        @Test
        void shouldIgnoreDecisionKeyEntries() {
            this.decisionId.wrapString("decision");
            this.decisionVersion.wrapInt(1);
            this.decisionKey.wrapLong(123L);
            this.correctDecisionColumnFamily.insert(this.decisionIdAndVersion, (DbValue)this.decisionKey);
            this.messagesDeadlineCount.wrapLong(123L);
            this.wrongMessageStatsColumnFamily.insert((DbKey)this.messagesDeadlineCountKey, (DbValue)this.messagesDeadlineCount);
            this.decisionId.wrapString("decision2");
            this.decisionVersion.wrapInt(2);
            this.decisionKey.wrapLong(234L);
            this.correctDecisionColumnFamily.insert(this.decisionIdAndVersion, (DbValue)this.decisionKey);
            Assertions.assertThat((long)this.correctDecisionColumnFamily.count()).isEqualTo(3L);
            this.sut.correctColumnFamilyPrefix();
            Assertions.assertThat((long)this.correctDecisionColumnFamily.count()).isEqualTo(2L);
            this.decisionId.wrapString("decision");
            this.decisionVersion.wrapInt(1);
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctDecisionColumnFamily.get(this.decisionIdAndVersion))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)123L);
            this.decisionId.wrapString("decision2");
            this.decisionVersion.wrapInt(2);
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctDecisionColumnFamily.get(this.decisionIdAndVersion))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)234L);
            ((ObjectAssert)Assertions.assertThat((Object)((DbLong)this.correctMessageStatsColumnFamily.get((DbKey)this.messagesDeadlineCountKey))).isNotNull()).extracting(DbLong::getValue).isEqualTo((Object)123L);
        }
    }
}

