/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.variable;

import io.camunda.zeebe.engine.state.variable.DocumentEntry;
import io.camunda.zeebe.engine.state.variable.DocumentEntryIterator;
import io.camunda.zeebe.engine.state.variable.IndexedDocument;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

final class IndexedDocumentTest {
    private final IndexedDocument indexedDocument = new IndexedDocument();

    IndexedDocumentTest() {
    }

    @Test
    void shouldIndexDocument() {
        Map<String, String> document = Map.of("foo", "bar", "baz", "buz");
        this.indexedDocument.index(MsgPackUtil.asMsgPack(document));
        List<DocumentEntry> entries = this.collectEntries();
        ((ListAssert)Assertions.assertThat(entries).hasSize(document.size())).containsExactlyInAnyOrder((Object[])new DocumentEntry[]{new DocumentEntry(this.packStringWithoutLength("foo"), this.packString("bar")), new DocumentEntry(this.packStringWithoutLength("baz"), this.packString("buz"))});
    }

    @Test
    void shouldRemoveEntriesViaIterator() {
        Map<String, String> document = Map.of("foo", "bar", "baz", "buz");
        this.indexedDocument.index(MsgPackUtil.asMsgPack(document));
        DocumentEntryIterator iterator = this.indexedDocument.iterator();
        DocumentEntry remainingEntry = this.cloneEntry(iterator.next());
        DocumentEntry removedEntry = this.cloneEntry(iterator.next());
        iterator.remove();
        List<DocumentEntry> entries = this.collectEntries();
        ((ListAssert)((ListAssert)Assertions.assertThat(entries).hasSize(1)).containsOnly((Object[])new DocumentEntry[]{remainingEntry})).doesNotContain((Object[])new DocumentEntry[]{removedEntry});
    }

    @Test
    void shouldWrapNewDocument() {
        Map<String, String> initialDocument = Map.of("foo", "bar", "baz", "buz");
        Map<String, String> finalDocument = Map.of("bar", "foo", "buz", "baz");
        this.indexedDocument.index(MsgPackUtil.asMsgPack(initialDocument));
        List<DocumentEntry> initialEntries = this.collectEntries();
        this.indexedDocument.index(MsgPackUtil.asMsgPack(finalDocument));
        List<DocumentEntry> finalEntries = this.collectEntries();
        ((ListAssert)((ListAssert)Assertions.assertThat(finalEntries).hasSize(finalDocument.size())).doesNotContainAnyElementsOf(initialEntries)).containsExactlyInAnyOrder((Object[])new DocumentEntry[]{new DocumentEntry(this.packStringWithoutLength("bar"), this.packString("foo")), new DocumentEntry(this.packStringWithoutLength("buz"), this.packString("baz"))});
    }

    private List<DocumentEntry> collectEntries() {
        ArrayList<DocumentEntry> entries = new ArrayList<DocumentEntry>();
        for (DocumentEntry entry : this.indexedDocument) {
            entries.add(this.cloneEntry(entry));
        }
        return entries;
    }

    private DocumentEntry cloneEntry(DocumentEntry entry) {
        return new DocumentEntry(BufferUtil.cloneBuffer((DirectBuffer)entry.getName()), BufferUtil.cloneBuffer((DirectBuffer)entry.getValue()));
    }

    private DirectBuffer packString(String value) {
        return MsgPackUtil.encodeMsgPack(b -> b.packString(value));
    }

    private DirectBuffer packStringWithoutLength(String key) {
        MsgPackReader reader = new MsgPackReader();
        DirectBuffer buffer = this.packString(key);
        reader.wrap(buffer, 0, buffer.capacity());
        reader.readStringLength();
        int offset = reader.getOffset();
        return new UnsafeBuffer(buffer, offset, buffer.capacity() - offset);
    }
}

