/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.UserTaskRecordStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class UserTaskClient {
    private static final long DEFAULT_KEY = -1L;
    private static final Function<Long, Record<UserTaskRecordValue>> SUCCESS_SUPPLIER = position -> (Record)((UserTaskRecordStream)RecordingExporter.userTaskRecords().withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<UserTaskRecordValue>> REJECTION_SUPPLIER = position -> (Record)((UserTaskRecordStream)((UserTaskRecordStream)RecordingExporter.userTaskRecords().onlyCommandRejections()).withSourceRecordPosition(position.longValue())).getFirst();
    private final UserTaskRecord userTaskRecord;
    private final CommandWriter writer;
    private long processInstanceKey;
    private long userTaskKey = -1L;
    private List<String> authorizedTenantIds = List.of("<default>");
    private Function<Long, Record<UserTaskRecordValue>> expectation = SUCCESS_SUPPLIER;

    public UserTaskClient(CommandWriter writer) {
        this.writer = writer;
        this.userTaskRecord = new UserTaskRecord();
    }

    public UserTaskClient ofInstance(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public UserTaskClient withKey(long userTaskKey) {
        this.userTaskKey = userTaskKey;
        return this;
    }

    public UserTaskClient withAuthorizedTenantIds(String ... tenantIds) {
        this.authorizedTenantIds = List.of(tenantIds);
        return this;
    }

    public UserTaskClient withAssignee(String assignee) {
        this.userTaskRecord.setAssignee(assignee);
        return this;
    }

    public UserTaskClient withoutAssignee() {
        this.userTaskRecord.setAssignee("");
        return this;
    }

    public UserTaskClient withAction(String action) {
        this.userTaskRecord.setAction(action);
        return this;
    }

    public UserTaskClient withVariables(String variables) {
        this.userTaskRecord.setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
        return this;
    }

    public UserTaskClient withVariables(DirectBuffer variables) {
        this.userTaskRecord.setVariables(variables);
        return this;
    }

    public UserTaskClient withVariable(String key, Object value) {
        this.userTaskRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
        return this;
    }

    public UserTaskClient withVariables(Map<String, Object> variables) {
        this.userTaskRecord.setVariables(MsgPackUtil.asMsgPack(variables));
        return this;
    }

    public UserTaskClient expectRejection() {
        this.expectation = REJECTION_SUPPLIER;
        return this;
    }

    private long findUserTaskKey() {
        if (this.userTaskKey == -1L) {
            Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).getFirst();
            return userTask.getKey();
        }
        return this.userTaskKey;
    }

    public Record<UserTaskRecordValue> assign() {
        long userTaskKey = this.findUserTaskKey();
        long position = this.writer.writeCommand(userTaskKey, (Intent)UserTaskIntent.ASSIGN, (UnifiedRecordValue)this.userTaskRecord.setUserTaskKey(userTaskKey), this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<UserTaskRecordValue> claim() {
        long userTaskKey = this.findUserTaskKey();
        long position = this.writer.writeCommand(userTaskKey, (Intent)UserTaskIntent.CLAIM, (UnifiedRecordValue)this.userTaskRecord.setUserTaskKey(userTaskKey), this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<UserTaskRecordValue> complete() {
        long userTaskKey = this.findUserTaskKey();
        long position = this.writer.writeCommand(userTaskKey, (Intent)UserTaskIntent.COMPLETE, (UnifiedRecordValue)this.userTaskRecord.setUserTaskKey(userTaskKey), this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<UserTaskRecordValue> update(List<String> candidateGroups, List<String> candidateUsers, String dueDate, String followUpDate) {
        if (candidateGroups != null) {
            this.userTaskRecord.setCandidateGroupsList(candidateGroups).setCandidateGroupsChanged();
        }
        if (candidateUsers != null) {
            this.userTaskRecord.setCandidateUsersList(candidateUsers).setCandidateUsersChanged();
        }
        if (dueDate != null) {
            this.userTaskRecord.setDueDate(dueDate).setDueDateChanged();
        }
        if (followUpDate != null) {
            this.userTaskRecord.setFollowUpDate(followUpDate).setFollowUpDateChanged();
        }
        long userTaskKey = this.findUserTaskKey();
        long position = this.writer.writeCommand(userTaskKey, (Intent)UserTaskIntent.UPDATE, (UnifiedRecordValue)this.userTaskRecord.setUserTaskKey(userTaskKey), this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<UserTaskRecordValue> update(UserTaskRecord changes) {
        changes.setCandidateGroupsChanged().setCandidateUsersChanged().setDueDateChanged().setFollowUpDateChanged();
        this.userTaskRecord.wrapChangedAttributes(changes, true);
        long userTaskKey = this.findUserTaskKey();
        long position = this.writer.writeCommand(userTaskKey, (Intent)UserTaskIntent.UPDATE, (UnifiedRecordValue)this.userTaskRecord.setUserTaskKey(userTaskKey), this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }
}

