package io.castled.dtomappers;

import io.castled.ObjectRegistry;
import io.castled.apps.ExternalApp;
import io.castled.apps.ExternalAppService;
import io.castled.apps.ExternalAppType;
import io.castled.dtos.AppDetails;
import io.castled.dtos.PipelineDTO;
import io.castled.dtos.PipelineRunDetails;
import io.castled.dtos.WarehouseDetails;
import io.castled.models.Pipeline;
import io.castled.models.Warehouse;
import io.castled.services.PipelineService;
import io.castled.services.QueryModelService;
import io.castled.warehouses.WarehouseService;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper
public interface PipelineDTOMapper {
    PipelineDTOMapper INSTANCE = Mappers.getMapper(PipelineDTOMapper.class);

    @Mapping(target = "app", source = "appId", qualifiedByName = "getAppDetails")
    @Mapping(target = "warehouse", source = "warehouseId", qualifiedByName = "getWarehouseDetails")
    @Mapping(target = "lastRunDetails", source = "pipeline", qualifiedByName = "getLastRunDetails")
    @Mapping(target = "sourceQuery", source = "modelId", qualifiedByName = "getSourceQuery")
    PipelineDTO toDetailedDTO(Pipeline pipeline);

    @Mapping(target = "app", source = "appId", qualifiedByName = "getAppDetails")
    @Mapping(target = "warehouse", source = "warehouseId", qualifiedByName = "getWarehouseDetails")
    PipelineDTO toDTO(Pipeline pipeline);

    default AppDetails getAppDetails(Long appId) {
        ExternalApp externalApp = ObjectRegistry.getInstance(ExternalAppService.class).getExternalApp(appId, true);
        ExternalAppType externalAppType = ExternalAppType.valueOf(externalApp.getType().name());
        return AppDetails.builder().name(externalApp.getName())
                .id(externalApp.getId()).type(externalApp.getType()).logoUrl(externalApp.getType().logoUrl()).build();
    }

    default WarehouseDetails getWarehouseDetails(Long warehouseId) {
        Warehouse warehouse = ObjectRegistry.getInstance(WarehouseService.class).getWarehouse(warehouseId, true);
        return WarehouseDetails.builder().id(warehouse.getId()).name(warehouse.getName())
                .type(warehouse.getType()).logoUrl(warehouse.getType().getLogoUrl()).build();
    }

    default PipelineRunDetails getLastRunDetails(Pipeline pipeline) {
        return new PipelineRunDetails(ObjectRegistry.getInstance(PipelineService.class).getPipelineRuns(pipeline.getId(), 10));

    }

    default String getSourceQuery(Long modelId) {
        return ObjectRegistry.getInstance(QueryModelService.class).getSourceQuery(modelId);
    }
}
