/*
 * Decompiled with CFR 0.152.
 */
package io.causallabs.runtime;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.causallabs.runtime.ApiException;
import io.causallabs.runtime.Requestable;
import io.causallabs.runtime.SessionRequestable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CausalClient {
    private static ExecutorService m_threadPool = Executors.newFixedThreadPool(4, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static CausalClient m_instance;
    private String m_impressionServerUrl;
    private final CloseableHttpAsyncClient m_asyncClient;
    public static final Logger logger;
    public static final ObjectMapper m_mapper;

    public static synchronized CausalClient getInstance() {
        if (m_instance == null) {
            m_instance = new CausalClient();
        }
        return m_instance;
    }

    protected CausalClient() {
        if (System.getenv("CAUSAL_ISERVER") != null) {
            this.m_impressionServerUrl = System.getenv("CAUSAL_ISERVER");
        } else {
            logger.warn("CAUSAL_ISERVER not set. Using http://localhost:3004/iserver");
            this.m_impressionServerUrl = "http://localhost:3004/iserver";
        }
        this.m_asyncClient = HttpAsyncClients.createDefault();
        this.m_asyncClient.start();
    }

    public JsonGenerator createGenerator() {
        StringWriter sw = new StringWriter();
        try {
            return m_mapper.getFactory().createGenerator((Writer)sw);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating in memory generator.", e);
        }
    }

    private String getResult(JsonGenerator gen) {
        try {
            StringWriter sw = (StringWriter)gen.getOutputTarget();
            gen.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting generation result.", e);
        }
    }

    public CompletableFuture<Void> requestAsync(SessionRequestable session, Requestable ... requests) throws InterruptedException {
        return this.requestAsync(session, UUID.randomUUID().toString(), requests);
    }

    public CompletableFuture<Void> requestAsync(SessionRequestable session, String impressionId, Requestable ... requests) {
        try {
            JsonGenerator _gen = this.createGenerator();
            _gen.writeStartObject();
            _gen.writeFieldName("args");
            session.serializeArgs(_gen);
            _gen.writeStringField("impressionId", impressionId);
            return this.requestAsync(session, _gen, requests);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing to RAM");
        }
    }

    public void request(SessionRequestable session, Requestable ... requests) throws InterruptedException, IOException {
        this.request(session, UUID.randomUUID().toString(), requests);
    }

    public void request(SessionRequestable session, String impressionId, Requestable ... requests) throws InterruptedException, IOException {
        JsonGenerator _gen = this.createGenerator();
        try {
            _gen.writeStartObject();
            _gen.writeFieldName("args");
            session.serializeArgs(_gen);
            _gen.writeStringField("impressionId", impressionId);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing to RAM");
        }
        this.request(session, _gen, requests);
    }

    private void setupRequest(SessionRequestable session, JsonGenerator gen, Requestable[] requests) {
        for (Requestable req : requests) {
            req.setSession(session);
        }
        try {
            gen.writeFieldName("reqs");
            gen.writeStartArray();
            for (Requestable request : requests) {
                gen.writeStartObject();
                gen.writeStringField("name", request.featureName());
                gen.writeFieldName("args");
                request.serializeArgs(gen);
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
        catch (IOException e) {
            logger.error("IO Error creating request, using control", (Throwable)e);
            throw new RuntimeException("IO Error creating request, using control", e);
        }
    }

    private void handleResponse(SimpleHttpResponse resp, SessionRequestable session, JsonGenerator gen, Requestable[] requests) throws IOException {
        if (resp.getCode() != 200) {
            try {
                IOException exception = new IOException("Error code " + resp.getCode() + " from server: " + resp.getBodyText());
                this.errorOutRequests(exception, requests);
                throw exception;
            }
            catch (IOException e) {
                this.errorOutRequests(new ApiException("Error code " + resp.getCode() + " from server"), requests);
                throw e;
            }
        }
        try {
            JsonParser parser = m_mapper.getFactory().createParser(resp.getBodyText());
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                IOException exception = new IOException("Malformed response, using control.");
                this.errorOutRequests(exception, requests);
                throw exception;
            }
            parser.nextToken();
            if (parser.getCurrentName().equals("session")) {
                try {
                    parser.nextToken();
                    session.deserializeResponse(parser);
                }
                catch (ApiException e) {
                    IOException exception = new IOException("Error while parsing result", e);
                    this.errorOutRequests(e, requests);
                    throw exception;
                }
            }
            if (!parser.getCurrentName().equals("impressions")) {
                IOException exception = new IOException("Malformed response, expecting 'impressions', using control.");
                this.errorOutRequests(exception, requests);
                throw exception;
            }
            if (!JsonToken.START_ARRAY.equals((Object)parser.nextToken())) {
                IOException exception = new IOException("Malformed response, expecting array, using control.");
                this.errorOutRequests(exception, requests);
                throw exception;
            }
            parser.nextToken();
            IOException delayedException = null;
            for (Requestable request : requests) {
                if (parser.currentToken().equals((Object)JsonToken.END_ARRAY)) {
                    IOException exception = new IOException("Response too short, using control values.");
                    this.errorOutRequests(exception, requests);
                    throw exception;
                }
                if (parser.currentToken().equals((Object)JsonToken.VALUE_STRING)) {
                    if (parser.getText().equals("OFF")) {
                        request.setActive(false);
                        parser.nextToken();
                        continue;
                    }
                    if (parser.getText().equals("UNKNOWN")) {
                        request.setError(new ApiException("Server doesn't know feature " + request.featureName() + ", using control."));
                        logger.info(request.getError().getMessage());
                        parser.nextToken();
                        continue;
                    }
                }
                if (!parser.currentToken().equals((Object)JsonToken.START_OBJECT)) {
                    delayedException = new IOException("Malformed response for " + request.featureName() + ", using control values.");
                    request.setError(delayedException);
                    logger.warn(request.getError().getMessage());
                    CausalClient.consumeValue(parser);
                }
                try {
                    request.deserializeResponse(parser);
                }
                catch (ApiException e) {
                    delayedException = new IOException("Error parsing response from server for " + request.featureName() + ", reverting to control.", e);
                    request.setError(delayedException);
                    logger.warn(request.getError().getMessage());
                }
            }
            if (delayedException != null) {
                throw delayedException;
            }
        }
        catch (JsonParseException e1) {
            IOException exception = new IOException("Malformed response, using control.", e1);
            this.errorOutRequests(exception, requests);
            throw exception;
        }
        catch (IOException e1) {
            this.errorOutRequests(e1, requests);
            throw e1;
        }
    }

    protected void request(SessionRequestable session, JsonGenerator gen, Requestable ... requests) throws InterruptedException, IOException {
        CompletableFuture<Void> result = this.requestAsync(session, gen, requests);
        try {
            result.get();
        }
        catch (ExecutionException e) {
            throw (IOException)e.getCause();
        }
    }

    protected CompletableFuture<Void> requestAsync(final SessionRequestable session, final JsonGenerator gen, final Requestable ... requests) {
        this.setupRequest(session, gen, requests);
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.asyncSendJson(URI.create(this.m_impressionServerUrl + "/features"), this.getResult(gen), new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse resp) {
                try {
                    CausalClient.this.handleResponse(resp, session, gen, requests);
                    result.complete(null);
                }
                catch (IOException e2) {
                    result.completeExceptionally(e2);
                }
            }

            public void failed(Exception exception) {
                CausalClient.this.errorOutRequests(exception, requests);
                result.completeExceptionally(exception);
            }

            public void cancelled() {
                result.completeExceptionally(new InterruptedException());
            }
        });
        return result;
    }

    private void errorOutRequests(Throwable exception, Requestable[] requests) {
        logger.warn(exception.getMessage());
        for (Requestable r : requests) {
            r.setError(exception);
        }
    }

    public static void consumeValue(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case START_ARRAY: 
            case START_OBJECT: {
                parser.skipChildren();
                parser.nextToken();
                break;
            }
            default: {
                parser.nextToken();
            }
        }
    }

    public void signal(JsonGenerator gen) {
        this.asyncSendJson("signalling event", URI.create(this.m_impressionServerUrl + "/signal"), this.getResult(gen));
    }

    public JsonGenerator externalGenerator(SessionRequestable session, List<String> impressionIds, String featureName, String fieldName) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = m_mapper.getFactory().createGenerator((Writer)sw);
            gen.writeStartObject();
            gen.writeFieldName("id");
            session.serializeIds(gen);
            gen.writeObjectField("feature", (Object)featureName);
            if (impressionIds.size() > 0) {
                gen.writeObjectField("impressionId", (Object)impressionIds.get(0));
            }
            gen.writeFieldName(fieldName);
            return gen;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating in memory generator.", e);
        }
    }

    public void signalExternal(JsonGenerator gen) {
        try {
            gen.writeEndObject();
        }
        catch (IOException e) {
            logger.error("Error serializing to ram, dropping request", (Throwable)e);
        }
        this.asyncSendJson("writing external", URI.create(this.m_impressionServerUrl + "/external"), this.getResult(gen));
    }

    private void asyncSendJson(final String what, URI uri, String body) {
        this.asyncSendJson(uri, body, new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse result) {
                if (result.getCode() != 200) {
                    logger.error("Error " + result.getCode() + " " + what + ": " + result.getBodyText());
                }
            }

            public void failed(Exception ex) {
                logger.error("Error " + what + ": " + ex.getMessage(), (Throwable)ex);
            }

            public void cancelled() {
                logger.error("Request cancelled " + what);
            }
        });
    }

    private void asyncSendJson(URI uri, String body, FutureCallback<SimpleHttpResponse> handler) {
        SimpleHttpRequest reqest = SimpleRequestBuilder.post((URI)uri).setBody(body, ContentType.APPLICATION_JSON).setHeader("user-agent", "Causal java client").addHeader("Accept", "text/plain").build();
        Future future = this.m_asyncClient.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)reqest), (AsyncResponseConsumer)SimpleResponseConsumer.create(), handler);
        m_threadPool.submit(() -> {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    m_threadPool.shutdown();
                    m_threadPool.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        m_instance = null;
        logger = LoggerFactory.getLogger(CausalClient.class);
        m_mapper = new ObjectMapper();
    }
}

