/*
 * Decompiled with CFR 0.152.
 */
package io.causallabs.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;

public class Mutable<T> {
    ArrayList<Record<T>> values = new ArrayList();

    public Mutable() {
    }

    public Mutable(T initialValue) {
        this.setInitialValue(initialValue);
    }

    public void setInitialValue(T x) {
        this.values.clear();
        this.values.add(new Record<T>(System.currentTimeMillis(), x));
    }

    public void setValue(T x) {
        long now = System.currentTimeMillis();
        if (!this.values.isEmpty()) {
            this.values.get((int)(this.values.size() - 1)).endTime = now - 1L;
        }
        this.values.add(new Record<T>(now, x));
    }

    public T getValue() {
        return this.values.get((int)(this.values.size() - 1)).value;
    }

    public List<Record<T>> getHistory() {
        if (!this.values.isEmpty()) {
            this.values.get((int)(this.values.size() - 1)).endTime = System.currentTimeMillis() - 1L;
        }
        return this.values;
    }

    public static class Record<T>
    implements IndexedRecord {
        long startTime;
        long endTime;
        T value;

        public Record(long now, T x) {
            this.startTime = now;
            this.value = x;
        }

        public Schema getSchema() {
            return null;
        }

        public void put(int i, Object v) {
        }

        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.startTime;
                }
                case 1: {
                    return this.endTime;
                }
                case 2: {
                    return this.value;
                }
            }
            return null;
        }
    }
}

