/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.db.CommonSchemaReader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CommonSchemaReaderTest {
    CommonSchemaReader reader;
    @Mock
    ResultSetMetaData metadata;

    @Before
    public void before() {
        this.reader = new CommonSchemaReader();
    }

    @Test
    public void testGetSchemaHandlesNull() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)0);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.NULL), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesRowID() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)-8);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.STRING), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesBoolean() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)16);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BOOLEAN), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)2))).thenReturn((Object)-7);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BOOLEAN), (Object)this.reader.getSchema(this.metadata, 2));
    }

    @Test
    public void testGetSchemaHandlesInt() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)-6);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.INT), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)2))).thenReturn((Object)5);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.INT), (Object)this.reader.getSchema(this.metadata, 2));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)3))).thenReturn((Object)4);
        Mockito.when((Object)this.metadata.isSigned(ArgumentMatchers.eq((int)3))).thenReturn((Object)true);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.INT), (Object)this.reader.getSchema(this.metadata, 3));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)3))).thenReturn((Object)4);
        Mockito.when((Object)this.metadata.isSigned(ArgumentMatchers.eq((int)3))).thenReturn((Object)false);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.LONG), (Object)this.reader.getSchema(this.metadata, 3));
    }

    @Test
    public void testGetSchemaHandlesLong() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)-5);
        Mockito.when((Object)this.metadata.isSigned(ArgumentMatchers.eq((int)1))).thenReturn((Object)true);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.LONG), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)-5);
        Mockito.when((Object)this.metadata.isSigned(ArgumentMatchers.eq((int)1))).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.getPrecision(ArgumentMatchers.eq((int)1))).thenReturn((Object)19);
        Assert.assertEquals((Object)Schema.decimalOf((int)19), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesFloat() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)7);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.FLOAT), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)2))).thenReturn((Object)6);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.FLOAT), (Object)this.reader.getSchema(this.metadata, 2));
    }

    @Test
    public void testGetSchemaHandlesNumeric() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2);
        Mockito.when((Object)this.metadata.getPrecision(ArgumentMatchers.eq((int)1))).thenReturn((Object)10);
        Mockito.when((Object)this.metadata.getScale(ArgumentMatchers.eq((int)1))).thenReturn((Object)0);
        Assert.assertEquals((Object)Schema.decimalOf((int)10, (int)0), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)2))).thenReturn((Object)3);
        Mockito.when((Object)this.metadata.getPrecision(ArgumentMatchers.eq((int)2))).thenReturn((Object)10);
        Mockito.when((Object)this.metadata.getScale(ArgumentMatchers.eq((int)2))).thenReturn((Object)1);
        Assert.assertEquals((Object)Schema.decimalOf((int)10, (int)1), (Object)this.reader.getSchema(this.metadata, 2));
    }

    @Test
    public void testGetSchemaHandlesDouble() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)8);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.DOUBLE), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesDate() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)91);
        Assert.assertEquals((Object)Schema.of((Schema.LogicalType)Schema.LogicalType.DATE), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesTime() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)92);
        Assert.assertEquals((Object)Schema.of((Schema.LogicalType)Schema.LogicalType.TIME_MICROS), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesTimestamp() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)93);
        Assert.assertEquals((Object)Schema.of((Schema.LogicalType)Schema.LogicalType.TIMESTAMP_MICROS), (Object)this.reader.getSchema(this.metadata, 1));
    }

    @Test
    public void testGetSchemaHandlesBytes() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)-2);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BYTES), (Object)this.reader.getSchema(this.metadata, 1));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)2))).thenReturn((Object)-3);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BYTES), (Object)this.reader.getSchema(this.metadata, 2));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)3))).thenReturn((Object)-4);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BYTES), (Object)this.reader.getSchema(this.metadata, 3));
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)4))).thenReturn((Object)2004);
        Assert.assertEquals((Object)Schema.of((Schema.Type)Schema.Type.BYTES), (Object)this.reader.getSchema(this.metadata, 4));
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnNumericWithZeroPrecision() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2);
        Mockito.when((Object)this.metadata.getPrecision(ArgumentMatchers.eq((int)1))).thenReturn((Object)0);
        Mockito.when((Object)this.metadata.getScale(ArgumentMatchers.eq((int)1))).thenReturn((Object)10);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnArray() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2003);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnDatalink() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)70);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnDistinct() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2001);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnJavaObject() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2000);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnOther() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)1111);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnRef() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2006);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnSQLXML() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2009);
        this.reader.getSchema(this.metadata, 1);
    }

    @Test(expected=SQLException.class)
    public void testGetSchemaThrowsExceptionOnStruct() throws SQLException {
        Mockito.when((Object)this.metadata.getColumnType(ArgumentMatchers.eq((int)1))).thenReturn((Object)2002);
        this.reader.getSchema(this.metadata, 1);
    }
}

