/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch;

import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.artifact.ArtifactSummary;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.mock.batch.MockSource;
import io.cdap.cdap.etl.mock.test.HydratorTestBase;
import io.cdap.cdap.etl.proto.v2.ETLBatchConfig;
import io.cdap.cdap.etl.proto.v2.ETLPlugin;
import io.cdap.cdap.etl.proto.v2.ETLStage;
import io.cdap.cdap.proto.ProgramRunStatus;
import io.cdap.cdap.proto.artifact.AppRequest;
import io.cdap.cdap.proto.id.ApplicationId;
import io.cdap.cdap.proto.id.NamespaceId;
import io.cdap.cdap.test.ApplicationManager;
import io.cdap.cdap.test.DataSetManager;
import io.cdap.cdap.test.WorkflowManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Assume;
import org.slf4j.Logger;

public abstract class DatabasePluginTestBase
extends HydratorTestBase {
    public static Schema getSchemaWithInvalidTypeMapping(String columnName, Schema.Type type) {
        return Schema.recordOf((String)"wrongDBRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)columnName, (Schema)Schema.of((Schema.Type)type))});
    }

    protected static void assertRuntimeFailure(ApplicationId appId, ETLBatchConfig etlConfig, ArtifactSummary datapipelineArtifact, String failureMessage, int runCount) throws Exception {
        AppRequest appRequest = new AppRequest(datapipelineArtifact, (Object)etlConfig);
        ApplicationManager appManager = DatabasePluginTestBase.deployApplication((ApplicationId)appId, (AppRequest)appRequest);
        WorkflowManager workflowManager = appManager.getWorkflowManager("DataPipelineWorkflow");
        workflowManager.start();
        workflowManager.waitForRuns(ProgramRunStatus.FAILED, runCount, 3L, TimeUnit.MINUTES);
    }

    protected static void assertDeploymentFailure(ApplicationId appId, ETLBatchConfig etlConfig, ArtifactSummary datapipelineArtifact, String failureMessage) throws Exception {
        AppRequest appRequest = new AppRequest(datapipelineArtifact, (Object)etlConfig);
        try {
            DatabasePluginTestBase.deployApplication((ApplicationId)appId, (AppRequest)appRequest);
            Assert.fail((String)failureMessage);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected static void assertDeployAppFailure(ApplicationId appId, ETLBatchConfig etlConfig, ArtifactSummary datapipelineArtifact) {
        AppRequest appRequest = new AppRequest(datapipelineArtifact, (Object)etlConfig);
        try {
            DatabasePluginTestBase.deployApplication((ApplicationId)appId, (AppRequest)appRequest);
            Assert.fail((String)"Deploy app should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ApplicationManager deployETL(ETLPlugin sourcePlugin, ETLPlugin sinkPlugin, ArtifactSummary datapipelineArtifact, String appName) throws Exception {
        ETLBatchConfig etlConfig = this.getETLBatchConfig(sourcePlugin, sinkPlugin);
        AppRequest appRequest = new AppRequest(datapipelineArtifact, (Object)etlConfig);
        ApplicationId appId = NamespaceId.DEFAULT.app(appName);
        return DatabasePluginTestBase.deployApplication((ApplicationId)appId, (AppRequest)appRequest);
    }

    protected ETLBatchConfig getETLBatchConfig(ETLPlugin sourcePlugin, ETLPlugin sinkPlugin) {
        ETLStage source = new ETLStage("source", sourcePlugin);
        ETLStage sink = new ETLStage("sink", sinkPlugin);
        return ((ETLBatchConfig.Builder)((ETLBatchConfig.Builder)((ETLBatchConfig.Builder)ETLBatchConfig.builder().addStage(source)).addStage(sink)).addConnection(source.getName(), sink.getName())).build();
    }

    protected void runETLOnce(ApplicationManager appManager) throws TimeoutException, InterruptedException, ExecutionException {
        this.runETLOnce(appManager, (Map<String, String>)ImmutableMap.of());
    }

    protected void runETLOnce(ApplicationManager appManager, Map<String, String> arguments) throws TimeoutException, InterruptedException, ExecutionException {
        WorkflowManager workflowManager = appManager.getWorkflowManager("DataPipelineWorkflow");
        workflowManager.start(arguments);
        workflowManager.waitForRun(ProgramRunStatus.COMPLETED, 5L, TimeUnit.MINUTES);
    }

    protected void testDBInvalidFieldType(String columnName, Schema.Type type, ETLPlugin sinkConfig, ArtifactSummary datapipelineArtifact) throws Exception {
        String inputDatasetName = "input-dbsinktest-invalid-field-type";
        Schema schema = DatabasePluginTestBase.getSchemaWithInvalidTypeMapping(columnName, type);
        this.testDBSinkValidation(inputDatasetName, "testDBSinkWithInvalidFieldType", schema, datapipelineArtifact, sinkConfig);
    }

    protected void testDBInvalidFieldLogicalType(String columnName, Schema.Type type, ETLPlugin sinkConfig, ArtifactSummary datapipelineArtifact) throws Exception {
        String inputDatasetName = "input-dbsinktest-invalid-field-logical-type";
        Schema schema = DatabasePluginTestBase.getSchemaWithInvalidTypeMapping(columnName, type);
        this.testDBSinkValidation(inputDatasetName, "testDBSinkWithInvalidFieldLogicalType", schema, datapipelineArtifact, sinkConfig);
    }

    protected void testDBSinkValidation(String inputDatasetName, String appName, Schema schema, ArtifactSummary datapipelineArtifact, ETLPlugin sinkConfig) throws Exception {
        ETLPlugin sourceConfig = MockSource.getPlugin((String)inputDatasetName, (Schema)schema);
        ETLBatchConfig etlConfig = this.getETLBatchConfig(sourceConfig, sinkConfig);
        ApplicationId appId = NamespaceId.DEFAULT.app(appName);
        DatabasePluginTestBase.assertDeploymentFailure(appId, etlConfig, datapipelineArtifact, "No fail message on schema validation");
    }

    protected void writeDataForInvalidDataWriteTest(String inputDatasetName, String stringColumnName) throws Exception {
        Schema validSchema = Schema.recordOf((String)"validDBRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ID", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)stringColumnName, (Schema)Schema.of((Schema.Type)Schema.Type.STRING))});
        Schema invalidSchema = Schema.recordOf((String)"wrongDBRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ID", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)stringColumnName, (Schema)Schema.of((Schema.Type)Schema.Type.INT))});
        DataSetManager inputManager = this.getDataset(inputDatasetName);
        ArrayList<StructuredRecord> inputRecords = new ArrayList<StructuredRecord>();
        inputRecords.add(StructuredRecord.builder((Schema)validSchema).set("ID", (Object)1).set(stringColumnName, (Object)"user1").build());
        inputRecords.add(StructuredRecord.builder((Schema)invalidSchema).set("ID", (Object)2).set(stringColumnName, (Object)1).build());
        inputRecords.add(StructuredRecord.builder((Schema)validSchema).set("ID", (Object)3).set(stringColumnName, (Object)"user3").build());
        MockSource.writeInput((DataSetManager)inputManager, inputRecords);
    }

    protected void startPipelineAndWriteInvalidData(String stringColumnName, ETLPlugin sinkConfig, ArtifactSummary datapipelineArtifact) throws Exception {
        String inputDatasetName = "input-dbsinktest-db-schema-invalid-schema-mapping";
        ETLPlugin sourceConfig = MockSource.getPlugin((String)inputDatasetName);
        ApplicationManager applicationManager = this.deployETL(sourceConfig, sinkConfig, datapipelineArtifact, "testDBSinkWithDBSchemaAndInvalidSchemaMapping");
        this.writeDataForInvalidDataWriteTest(inputDatasetName, stringColumnName);
        WorkflowManager workflowManager = applicationManager.getWorkflowManager("DataPipelineWorkflow");
        workflowManager.startAndWaitForRun(ProgramRunStatus.FAILED, 5L, TimeUnit.MINUTES);
    }

    protected void testInvalidDataWrite(ResultSet resultSet, String columnName) throws SQLException {
        ArrayList<String> users = new ArrayList<String>();
        while (resultSet.next()) {
            users.add(resultSet.getString(columnName).trim());
        }
        Assert.assertFalse((boolean)users.contains("1"));
    }

    protected static String getPropertyOrSkip(String propertyName) {
        String value = System.getProperty(propertyName);
        Assume.assumeFalse((String)("There is no value for property " + propertyName), (value == null ? 1 : 0) != 0);
        return value;
    }

    protected static void executeCleanup(List<Cleanup> cleanups, Logger logger) {
        for (Cleanup cleanup : cleanups) {
            try {
                cleanup.run();
            }
            catch (Exception e) {
                logger.warn("Fail to cleanup.", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    protected static interface Cleanup {
        public void run() throws Exception;
    }
}

