/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.sink;

import com.google.common.collect.ImmutableList;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import io.cdap.plugin.db.ColumnType;
import io.cdap.plugin.db.batch.sink.AbstractDBSink;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDBSinkTest {
    @Test
    public void testGetMatchedColumnTypeList() throws SQLException {
        ImmutableList columns = ImmutableList.of((Object)"ID", (Object)"NAME", (Object)"AGE");
        ArrayList<ColumnType> expectedColumns = new ArrayList<ColumnType>();
        MockResultSetMetaData resultSetMetaData = new MockResultSetMetaData();
        resultSetMetaData.setColumnCount(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            resultSetMetaData.setColumnName(i + 1, (String)columns.get(i));
            resultSetMetaData.setColumnTypeName(i + 1, "STRING");
            resultSetMetaData.setColumnType(i + 1, i);
            expectedColumns.add(new ColumnType(name, "STRING", i));
        }
        List result = AbstractDBSink.getMatchedColumnTypeList((ResultSetMetaData)resultSetMetaData, (List)columns);
        Assert.assertEquals(expectedColumns, (Object)result);
    }

    @Test
    public void testGetMismatchColumnTypeList() throws SQLException {
        ImmutableList wrongColumns = ImmutableList.of((Object)"MY_ID", (Object)"NAME", (Object)"SCORE");
        ImmutableList columns = ImmutableList.of((Object)"ID", (Object)"NAME", (Object)"SCORE");
        MockResultSetMetaData resultSetMetaData = new MockResultSetMetaData();
        resultSetMetaData.setColumnCount(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            resultSetMetaData.setColumnName(i + 1, (String)columns.get(i));
            resultSetMetaData.setColumnTypeName(i + 1, "STRING");
            resultSetMetaData.setColumnType(i + 1, i);
        }
        try {
            AbstractDBSink.getMatchedColumnTypeList((ResultSetMetaData)resultSetMetaData, (List)wrongColumns);
            Assert.fail((String)String.format("Expected to throw %s", IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException e) {
            String errorMessage = "Missing column 'MY_ID' in SQL table";
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }
}

