/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.sink;

import com.google.common.collect.ImmutableSet;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.validation.ValidationFailure;
import io.cdap.cdap.etl.mock.validation.MockFailureCollector;
import io.cdap.plugin.db.batch.sink.CommonFieldsValidator;
import io.cdap.plugin.db.batch.sink.FieldsValidator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CommonFieldsValidatorTest {
    private static final FieldsValidator VALIDATOR = new CommonFieldsValidator();

    @Test
    public void testIsFieldCompatible() {
        this.validateFieldCompatible(Schema.Type.INT, Schema.LogicalType.DATE, 91, true);
        this.validateFieldCompatible(Schema.Type.INT, Schema.LogicalType.TIME_MILLIS, 92, true);
        this.validateFieldCompatible(Schema.Type.LONG, Schema.LogicalType.TIME_MICROS, 92, true);
        this.validateFieldCompatible(Schema.Type.LONG, Schema.LogicalType.TIMESTAMP_MILLIS, 93, true);
        this.validateFieldCompatible(Schema.Type.LONG, Schema.LogicalType.TIMESTAMP_MICROS, 93, true);
        this.validateFieldCompatible(Schema.Type.BYTES, Schema.LogicalType.DECIMAL, 2, true);
        this.validateFieldCompatible(Schema.Type.BYTES, Schema.LogicalType.DECIMAL, 3, true);
        this.validateFieldCompatible(Schema.Type.NULL, null, 0, true);
        this.validateFieldCompatible(Schema.Type.BOOLEAN, null, 16, true);
        this.validateFieldCompatible(Schema.Type.BOOLEAN, null, -7, true);
        this.validateFieldCompatible(Schema.Type.INT, null, 4, true);
        this.validateFieldCompatible(Schema.Type.INT, null, 5, true);
        this.validateFieldCompatible(Schema.Type.INT, null, -6, true);
        this.validateFieldCompatible(Schema.Type.FLOAT, null, 7, true);
        this.validateFieldCompatible(Schema.Type.FLOAT, null, 6, true);
        this.validateFieldCompatible(Schema.Type.DOUBLE, null, 8, true);
        this.validateFieldCompatible(Schema.Type.BYTES, null, -2, true);
        this.validateFieldCompatible(Schema.Type.BYTES, null, -3, true);
        this.validateFieldCompatible(Schema.Type.BYTES, null, -4, true);
        this.validateFieldCompatible(Schema.Type.BYTES, null, 2004, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, 12, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, 1, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, 2005, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, -16, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, -1, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, -15, true);
        this.validateFieldCompatible(Schema.Type.STRING, null, 2011, true);
        this.validateFieldCompatible(Schema.Type.LONG, null, 93, false);
    }

    @Test
    public void testValidateFields() throws Exception {
        Schema schema = Schema.recordOf((String)"dbRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ID", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"NAME", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"SCORE", (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE))});
        ImmutableSet columns = ImmutableSet.of((Object)"ID", (Object)"NAME", (Object)"SCORE");
        MockResultSetMetaData resultSetMetaData = new MockResultSetMetaData();
        resultSetMetaData.setColumnCount(columns.size());
        resultSetMetaData.setColumnName(1, "ID");
        resultSetMetaData.setColumnTypeName(1, "INTEGER");
        resultSetMetaData.setColumnType(1, 4);
        resultSetMetaData.setColumnName(2, "NAME");
        resultSetMetaData.setColumnTypeName(2, "STRING");
        resultSetMetaData.setColumnType(2, 12);
        resultSetMetaData.setColumnName(3, "SCORE");
        resultSetMetaData.setColumnTypeName(3, "DOUBLE");
        resultSetMetaData.setColumnType(3, 8);
        MockResultSet resultSet = new MockResultSet("data");
        resultSet.addColumns((Set)columns);
        resultSet.setResultSetMetaData((ResultSetMetaData)resultSetMetaData);
        MockFailureCollector collector = new MockFailureCollector();
        VALIDATOR.validateFields(schema, (ResultSet)resultSet, (FailureCollector)collector);
        Assert.assertEquals((long)0L, (long)collector.getValidationFailures().size());
    }

    @Test
    public void testValidateFieldsWithInvalidMapping() throws Exception {
        Schema schema = Schema.recordOf((String)"dbRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ID", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"NAME", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"SCORE", (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE))});
        ImmutableSet columns = ImmutableSet.of((Object)"ID", (Object)"NAME", (Object)"SCORE");
        MockResultSetMetaData resultSetMetaData = new MockResultSetMetaData();
        resultSetMetaData.setColumnCount(columns.size());
        resultSetMetaData.setColumnName(1, "ID");
        resultSetMetaData.setColumnTypeName(1, "INTEGER");
        resultSetMetaData.setColumnType(1, 4);
        resultSetMetaData.setColumnName(2, "NAME");
        resultSetMetaData.setColumnTypeName(2, "STRING");
        resultSetMetaData.setColumnType(2, 12);
        resultSetMetaData.setColumnName(3, "SCORE");
        resultSetMetaData.setColumnTypeName(3, "STRING");
        resultSetMetaData.setColumnType(3, 12);
        MockResultSet resultSet = new MockResultSet("data");
        resultSet.addColumns((Set)columns);
        resultSet.setResultSetMetaData((ResultSetMetaData)resultSetMetaData);
        MockFailureCollector collector = new MockFailureCollector();
        VALIDATOR.validateFields(schema, (ResultSet)resultSet, (FailureCollector)collector);
        Assert.assertEquals((long)1L, (long)collector.getValidationFailures().size());
        String attribute = ((ValidationFailure.Cause)((ValidationFailure)collector.getValidationFailures().iterator().next()).getCauses().get(0)).getAttribute("inputField");
        Assert.assertEquals((Object)"SCORE", (Object)attribute);
    }

    @Test
    public void testValidateFieldsWithNullable() throws Exception {
        Schema schema = Schema.recordOf((String)"dbRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"ID", (Schema)Schema.of((Schema.Type)Schema.Type.INT)), Schema.Field.of((String)"NAME", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"SCORE", (Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE))});
        ImmutableSet columns = ImmutableSet.of((Object)"ID", (Object)"NAME", (Object)"SCORE");
        MockResultSetMetaData resultSetMetaData = new MockResultSetMetaData();
        resultSetMetaData.setColumnCount(columns.size());
        resultSetMetaData.setColumnName(1, "ID");
        resultSetMetaData.setColumnTypeName(1, "INTEGER");
        resultSetMetaData.setColumnType(1, 4);
        resultSetMetaData.setColumnName(2, "NAME");
        resultSetMetaData.setColumnTypeName(2, "STRING");
        resultSetMetaData.setColumnType(2, 12);
        MockResultSet resultSet = new MockResultSet("data");
        resultSet.addColumns((Set)columns);
        resultSet.setResultSetMetaData((ResultSetMetaData)resultSetMetaData);
        MockFailureCollector collector = new MockFailureCollector();
        VALIDATOR.validateFields(schema, (ResultSet)resultSet, (FailureCollector)collector);
        Assert.assertEquals((long)1L, (long)collector.getValidationFailures().size());
        String attribute = ((ValidationFailure.Cause)((ValidationFailure)collector.getValidationFailures().iterator().next()).getCauses().get(0)).getAttribute("inputField");
        Assert.assertEquals((Object)"SCORE", (Object)attribute);
    }

    public void validateFieldCompatible(Schema.Type fieldType, Schema.LogicalType fieldLogicalType, int sqlType, boolean isCompatible) {
        String errorMessage = String.format("Expected type '%s' is %s with sql type '%d'", fieldType, isCompatible ? "compatible" : "not compatible", sqlType);
        Assert.assertEquals((String)errorMessage, (Object)isCompatible, (Object)VALIDATOR.isFieldCompatible(fieldType, fieldLogicalType, sqlType));
    }
}

