/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.source;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.validation.ValidationFailure;
import io.cdap.cdap.etl.mock.validation.MockFailureCollector;
import io.cdap.plugin.db.batch.source.AbstractDBSource;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDBSourceTest {
    private static final String MOCK_STAGE = "mockStage";
    private static final Schema SCHEMA = Schema.recordOf((String)"schema", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"id", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"string_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"bytes_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.BYTES))), Schema.Field.of((String)"int_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"long_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.LONG))), Schema.Field.of((String)"float_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.FLOAT))), Schema.Field.of((String)"double_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE))), Schema.Field.of((String)"boolean_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.BOOLEAN)))});

    @Test
    public void testValidateSourceSchemaCorrectSchema() {
        MockFailureCollector collector = new MockFailureCollector(MOCK_STAGE);
        AbstractDBSource.DBSourceConfig.validateSchema((Schema)SCHEMA, (Schema)SCHEMA, (FailureCollector)collector);
        Assert.assertEquals((long)0L, (long)collector.getValidationFailures().size());
    }

    @Test
    public void testValidateSourceSchemaMismatchFields() {
        Schema actualSchema = Schema.recordOf((String)"schema", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"id", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"string_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"bytes_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.BYTES))), Schema.Field.of((String)"int_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"long_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.LONG))), Schema.Field.of((String)"float_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.FLOAT))), Schema.Field.of((String)"double_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE)))});
        MockFailureCollector collector = new MockFailureCollector(MOCK_STAGE);
        AbstractDBSource.DBSourceConfig.validateSchema((Schema)actualSchema, (Schema)SCHEMA, (FailureCollector)collector);
        AbstractDBSourceTest.assertPropertyValidationFailed(collector, "boolean_column");
    }

    @Test
    public void testValidateSourceSchemaInvalidFieldType() {
        Schema actualSchema = Schema.recordOf((String)"schema", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"id", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"string_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))), Schema.Field.of((String)"bytes_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.BYTES))), Schema.Field.of((String)"int_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT))), Schema.Field.of((String)"long_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.LONG))), Schema.Field.of((String)"float_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.FLOAT))), Schema.Field.of((String)"double_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.DOUBLE))), Schema.Field.of((String)"boolean_column", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.INT)))});
        MockFailureCollector collector = new MockFailureCollector(MOCK_STAGE);
        AbstractDBSource.DBSourceConfig.validateSchema((Schema)actualSchema, (Schema)SCHEMA, (FailureCollector)collector);
        AbstractDBSourceTest.assertPropertyValidationFailed(collector, "boolean_column");
    }

    private static void assertPropertyValidationFailed(MockFailureCollector failureCollector, String paramName) {
        List failureList = failureCollector.getValidationFailures();
        Assert.assertEquals((long)1L, (long)failureList.size());
        ValidationFailure failure = (ValidationFailure)failureList.get(0);
        List<ValidationFailure.Cause> causeList = AbstractDBSourceTest.getCauses(failure, "outputField");
        Assert.assertEquals((long)1L, (long)causeList.size());
        ValidationFailure.Cause cause = causeList.get(0);
        Assert.assertEquals((Object)paramName, (Object)cause.getAttribute("outputField"));
    }

    @Nonnull
    private static List<ValidationFailure.Cause> getCauses(ValidationFailure failure, String stacktrace) {
        return failure.getCauses().stream().filter(cause -> cause.getAttribute(stacktrace) != null).collect(Collectors.toList());
    }
}

