/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.connector;

import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.etl.api.batch.BatchConnector;
import io.cdap.cdap.etl.api.connector.BrowseDetail;
import io.cdap.cdap.etl.api.connector.BrowseEntity;
import io.cdap.cdap.etl.api.connector.BrowseRequest;
import io.cdap.cdap.etl.api.connector.ConnectorConfigurer;
import io.cdap.cdap.etl.api.connector.ConnectorContext;
import io.cdap.cdap.etl.api.connector.ConnectorSpec;
import io.cdap.cdap.etl.api.connector.ConnectorSpecRequest;
import io.cdap.cdap.etl.api.connector.PluginSpec;
import io.cdap.cdap.etl.api.connector.SampleRequest;
import io.cdap.cdap.etl.api.validation.ValidationException;
import io.cdap.cdap.etl.mock.common.MockConnectorConfigurer;
import io.cdap.cdap.etl.mock.common.MockConnectorContext;
import io.cdap.plugin.db.connector.AbstractDBSpecificConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.mockito.Mockito;

public abstract class DBSpecificConnectorBaseTest {
    protected static final String JDBC_PLUGIN_NAME = "jdbc_plugin";
    protected static String host;
    protected static int port;
    protected static String username;
    protected static String password;
    protected static String connectionArguments;
    protected static String table;
    protected static String schema;
    protected static String database;
    private static final String NAME_USE_CONNECTION = "useConnection";
    private static final String NAME_CONNECTION = "connection";
    private static final String IMPORT_QUERY = "importQuery";
    private static final String NUM_SPLITS = "numSplits";

    @BeforeClass
    public static void setupTestClass() throws Exception {
        String messageTemplate = "%s is not configured, please refer to javadoc of this class for details.";
        host = System.getProperty("host");
        Assume.assumeFalse((String)String.format(messageTemplate, "host"), (host == null ? 1 : 0) != 0);
        String portStr = System.getProperty("port");
        port = Integer.parseInt(portStr);
        username = System.getProperty("username");
        Assume.assumeFalse((String)String.format(messageTemplate, "username"), (username == null ? 1 : 0) != 0);
        password = System.getProperty("password");
        Assume.assumeFalse((String)String.format(messageTemplate, "password"), (password == null ? 1 : 0) != 0);
        database = System.getProperty("database.name");
        Assume.assumeFalse((String)String.format(messageTemplate, "database name"), (database == null ? 1 : 0) != 0);
        schema = System.getProperty("schema.name");
        table = System.getProperty("table.name");
        Assume.assumeFalse((String)String.format(messageTemplate, "table name"), (table == null ? 1 : 0) != 0);
        connectionArguments = System.getProperty("connection.arguments");
    }

    protected void testSample(AbstractDBSpecificConnector connector) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        List<StructuredRecord> sample = this.sample((BatchConnector)connector, (ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), SampleRequest.builder((int)1).setPath(schema == null ? database + "/" + table : database + "/" + schema + "/" + table).build());
        Assert.assertTrue((sample.size() > 0 ? 1 : 0) != 0);
        StructuredRecord record = sample.get(0);
        Schema tableSchema = record.getSchema();
        Assert.assertNotNull((Object)tableSchema);
        for (Schema.Field field : tableSchema.getFields()) {
            Assert.assertNotNull((Object)field.getSchema());
            Assert.assertTrue((record.get(field.getName()) != null || field.getSchema().isNullable() ? 1 : 0) != 0);
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> this.sample((BatchConnector)connector, (ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), SampleRequest.builder((int)1).setPath(schema == null ? "a/b/c" : "a/b/c/d").build()));
        if (schema != null) {
            Assert.assertThrows(IllegalArgumentException.class, () -> this.sample((BatchConnector)connector, (ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), SampleRequest.builder((int)1).setPath(schema).build()));
        }
    }

    protected void testBrowse(AbstractDBSpecificConnector connector) throws IOException {
        BrowseDetail detail = connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)"/").build());
        Assert.assertTrue((detail.getTotalCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((detail.getEntities().size() > 0 ? 1 : 0) != 0);
        for (BrowseEntity entity : detail.getEntities()) {
            System.out.println(entity.getType() + " : " + entity.getName());
            Assert.assertEquals((Object)"DATABASE", (Object)entity.getType());
            Assert.assertTrue((boolean)entity.canBrowse());
            Assert.assertFalse((boolean)entity.canSample());
        }
        if (schema != null) {
            detail = connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)("/" + database)).build());
            Assert.assertTrue((detail.getTotalCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((detail.getEntities().size() > 0 ? 1 : 0) != 0);
            for (BrowseEntity entity : detail.getEntities()) {
                System.out.println(entity.getType() + " : " + entity.getName());
                Assert.assertEquals((Object)"SCHEMA", (Object)entity.getType());
                Assert.assertTrue((boolean)entity.canBrowse());
                Assert.assertFalse((boolean)entity.canSample());
            }
            detail = connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)("/" + database + "/" + schema)).build());
            Assert.assertTrue((detail.getTotalCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((detail.getEntities().size() > 0 ? 1 : 0) != 0);
            for (BrowseEntity entity : detail.getEntities()) {
                System.out.println(entity.getType() + " : " + entity.getName());
                Assert.assertFalse((boolean)entity.canBrowse());
                Assert.assertTrue((boolean)entity.canSample());
            }
        } else {
            detail = connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)("/" + database)).build());
            Assert.assertTrue((detail.getTotalCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((detail.getEntities().size() > 0 ? 1 : 0) != 0);
            for (BrowseEntity entity : detail.getEntities()) {
                System.out.println(entity.getType() + " : " + entity.getName());
                Assert.assertFalse((boolean)entity.canBrowse());
                Assert.assertTrue((boolean)entity.canSample());
            }
        }
        detail = connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)(schema == null ? database + "/" + table : database + "/" + schema + "/" + table)).build());
        Assert.assertEquals((long)1L, (long)detail.getTotalCount());
        Assert.assertEquals((long)1L, (long)detail.getEntities().size());
        for (BrowseEntity entity : detail.getEntities()) {
            System.out.println(entity.getType() + " : " + entity.getName());
            Assert.assertFalse((boolean)entity.canBrowse());
            Assert.assertTrue((boolean)entity.canSample());
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)(schema == null ? "a/b/c" : "a/b/c/d")).build()));
        Assert.assertThrows(IllegalArgumentException.class, () -> connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)"/notexisting").build()));
        if (schema != null) {
            Assert.assertThrows(IllegalArgumentException.class, () -> connector.browse((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), BrowseRequest.builder((String)(schema + "/notexisting")).build()));
        }
    }

    protected void testTest(AbstractDBSpecificConnector connector) {
        MockConnectorContext context = new MockConnectorContext(new MockConnectorConfigurer());
        connector.test((ConnectorContext)context);
        ValidationException validationException = context.getFailureCollector().getOrThrowException();
        Assert.assertTrue((boolean)validationException.getFailures().isEmpty());
    }

    protected void testGenerateSpec(AbstractDBSpecificConnector connector, String sourceName) throws IOException {
        ConnectorSpec connectorSpec = connector.generateSpec((ConnectorContext)new MockConnectorContext(new MockConnectorConfigurer()), ConnectorSpecRequest.builder().setPath(schema == null ? database + "/" + table : database + "/" + schema + "/" + table).setConnection("${conn(connection-id)}").build());
        Schema tableSchema = connectorSpec.getSchema();
        for (Schema.Field field : tableSchema.getFields()) {
            Assert.assertNotNull((Object)field.getSchema());
        }
        Set relatedPlugins = connectorSpec.getRelatedPlugins();
        Assert.assertEquals((long)1L, (long)relatedPlugins.size());
        PluginSpec pluginSpec = (PluginSpec)relatedPlugins.iterator().next();
        Assert.assertEquals((Object)sourceName, (Object)pluginSpec.getName());
        Assert.assertEquals((Object)"batchsource", (Object)pluginSpec.getType());
        Map properties = pluginSpec.getProperties();
        Assert.assertEquals((Object)"true", properties.get(NAME_USE_CONNECTION));
        Assert.assertEquals((Object)"${conn(connection-id)}", properties.get(NAME_CONNECTION));
        Assert.assertEquals((Object)(schema == null ? String.format("SELECT * FROM %s.%s", database, table) : String.format("SELECT * FROM %s.%s.%s", database, schema, table)), properties.get(IMPORT_QUERY));
        properties.put("1", properties.get(NUM_SPLITS));
    }

    protected List<StructuredRecord> sample(BatchConnector batchConnector, ConnectorContext context, SampleRequest request) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        List splits;
        InputFormatProvider inputFormatProvider = batchConnector.getInputFormatProvider(context, request);
        Configuration hConf = new Configuration();
        hConf.setClassLoader(DBSpecificConnectorBaseTest.class.getClassLoader());
        inputFormatProvider.getInputFormatConfiguration().forEach((arg_0, arg_1) -> ((Configuration)hConf).set(arg_0, arg_1));
        Job job = Job.getInstance((Configuration)hConf);
        job.setJobID(new JobID("sample", 0));
        InputFormat inputFormat = (InputFormat)DBSpecificConnectorBaseTest.class.getClassLoader().loadClass(inputFormatProvider.getInputFormatClassName()).newInstance();
        if (inputFormat instanceof Configurable) {
            ((Configurable)inputFormat).setConf(hConf);
        }
        try {
            splits = inputFormat.getSplits((JobContext)job);
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Unable to get the splits from the input format %s", inputFormatProvider.getInputFormatClassName()));
        }
        ArrayList<StructuredRecord> sample = new ArrayList<StructuredRecord>();
        InputSplit split = (InputSplit)splits.get(0);
        TaskID taskId = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(hConf, new TaskAttemptID(taskId, 0));
        try (RecordReader reader = inputFormat.createRecordReader(split, (TaskAttemptContext)taskContext);){
            reader.initialize(split, (TaskAttemptContext)taskContext);
            while (reader.nextKeyValue()) {
                sample.add(batchConnector.transform(reader.getCurrentKey(), reader.getCurrentValue()));
            }
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Unable to read the values from the input format %s", inputFormatProvider.getInputFormatClassName()));
        }
        return sample;
    }

    protected void test(AbstractDBSpecificConnector connector, String driverClassName, String sourcePluginName) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConnectorConfigurer configurer = (ConnectorConfigurer)Mockito.mock(ConnectorConfigurer.class);
        Mockito.when((Object)configurer.usePluginClass(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (PluginProperties)Mockito.any(PluginProperties.class))).thenReturn(DBSpecificConnectorBaseTest.class.getClassLoader().loadClass(driverClassName));
        connector.configure(configurer);
        this.testTest(connector);
        this.testBrowse(connector);
        this.testSample(connector);
        this.testGenerateSpec(connector, sourcePluginName);
    }
}

