/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.connector;

import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.etl.api.connector.ConnectorConfigurer;
import io.cdap.cdap.etl.api.connector.ConnectorContext;
import io.cdap.cdap.etl.api.validation.ValidationFailure;
import io.cdap.cdap.etl.mock.common.MockConnectorConfigurer;
import io.cdap.cdap.etl.mock.common.MockConnectorContext;
import io.cdap.plugin.db.connector.AbstractDBSpecificConnector;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.mockito.Mockito;

public class DBSpecificFailedConnectionTest {
    private static final String JDBC_DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";

    protected void test(String jdbcClassName, AbstractDBSpecificConnector connector, String expectedErrorMsg) throws ClassNotFoundException, IOException {
        ConnectorConfigurer configurer = (ConnectorConfigurer)Mockito.mock(ConnectorConfigurer.class);
        Mockito.when((Object)configurer.usePluginClass(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (PluginProperties)Mockito.any(PluginProperties.class))).thenReturn(DBSpecificFailedConnectionTest.class.getClassLoader().loadClass(jdbcClassName));
        connector.configure(configurer);
        MockConnectorContext context = new MockConnectorContext(new MockConnectorConfigurer());
        connector.test((ConnectorContext)context);
        List validationFailures = context.getFailureCollector().getValidationFailures();
        Assert.assertEquals((long)1L, (long)validationFailures.size());
        Assert.assertEquals((Object)expectedErrorMsg, (Object)((ValidationFailure)validationFailures.get(0)).getMessage());
    }
}

