/*
 * Decompiled with CFR 0.152.
 */
package io.cequence.wsclient;

import io.cequence.wsclient.JsonUtil;
import java.io.Serializable;
import java.util.Date;
import play.api.libs.json.Format;
import play.api.libs.json.Format$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonNaming;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class JsonUtil$ {
    public static final JsonUtil$ MODULE$ = new JsonUtil$();

    public JsonUtil.JsonOps JsonOps(JsValue json) {
        return new JsonUtil.JsonOps(json);
    }

    public JsValue toJson(Object value2) {
        if (value2 == null) {
            return JsNull$.MODULE$;
        }
        Object object = value2;
        if (object instanceof JsValue) {
            JsValue jsValue = (JsValue)object;
            return jsValue;
        }
        if (object instanceof String) {
            String string = (String)object;
            return new JsString(string);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return new JsNumber(bigDecimal);
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return new JsNumber(package$.MODULE$.BigDecimal().valueOf((long)Predef$.MODULE$.Integer2int(n)));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return new JsNumber(package$.MODULE$.BigDecimal().valueOf(l));
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return new JsNumber(package$.MODULE$.BigDecimal().valueOf(d));
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return new JsNumber(package$.MODULE$.BigDecimal().valueOf((double)f));
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return JsBoolean$.MODULE$.apply(bl);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return Json$.MODULE$.toJson((Object)date, Writes$.MODULE$.defaultDateWrites());
        }
        if (object instanceof Option) {
            Option option = (Option)object;
            return (JsValue)option.map((Function1 & Serializable)value -> MODULE$.toJson(value)).getOrElse((Function0 & Serializable)() -> JsNull$.MODULE$);
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new JsArray((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object2), (Function1 & Serializable)value -> MODULE$.toJson(value), ClassTag$.MODULE$.apply(JsValue.class))));
        }
        if (object instanceof scala.collection.immutable.Seq) {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
            return JsArray$.MODULE$.apply((Seq)seq.map((Function1 & Serializable)value -> MODULE$.toJson(value)));
        }
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            scala.collection.immutable.Map jsonValues = (scala.collection.immutable.Map)map.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String fieldName = (String)tuple2._1();
                    Object value = tuple2._2();
                    return new Tuple2((Object)fieldName, (Object)MODULE$.toJson(value));
                }
                throw new MatchError((Object)tuple2);
            });
            return new JsObject((Map)jsonValues);
        }
        throw new IllegalArgumentException(new StringBuilder(39).append("No JSON formatter found for the class ").append(value2.getClass().getName()).append(".").toString());
    }

    public <L, R> Format<Either<L, R>> eitherFormat(Format<L> evidence$1, Format<R> evidence$2) {
        Format leftFormat = (Format)Predef$.MODULE$.implicitly(evidence$1);
        Format rightFormat = (Format)Predef$.MODULE$.implicitly(evidence$2);
        return new JsonUtil.EitherFormat(leftFormat, rightFormat);
    }

    private <T> Format<T> enumFormatAux(scala.collection.immutable.Seq<T> values, Function1<T, String> mapper) {
        scala.collection.immutable.Map valueMap = ((IterableOnceOps)values.map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(mapper.apply(v)), v))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Reads reads = Reads$.MODULE$.apply((Function1 & Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsString) {
                JsString jsString = (JsString)jsValue;
                String value = jsString.value();
                Option option = valueMap.get((Object)value);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object v = some.value();
                    return new JsSuccess(v, JsSuccess$.MODULE$.apply$default$2());
                }
                if (None$.MODULE$.equals(option)) {
                    return JsError$.MODULE$.apply(new StringBuilder(27).append(value).append(" is not a valid enum value.").toString());
                }
                throw new MatchError((Object)option);
            }
            return JsError$.MODULE$.apply("String value expected");
        });
        Writes writes = Writes$.MODULE$.apply((Function1 & Serializable)v -> new JsString((String)mapper.apply(v)));
        return Format$.MODULE$.apply(reads, writes);
    }

    public <T> Format<T> enumFormat(scala.collection.immutable.Seq<T> values) {
        return this.enumFormatAux(values, (Function1 & Serializable)x$5 -> x$5.toString());
    }

    public <T> Format<T> snakeEnumFormat(scala.collection.immutable.Seq<T> values) {
        return this.enumFormatAux(values, (Function1 & Serializable)v -> JsonNaming.SnakeCase$.MODULE$.apply(v.toString()));
    }

    private JsonUtil$() {
    }
}

