/*
 * Decompiled with CFR 0.152.
 */
package io.ceresdb.sql;

import io.ceresdb.common.parser.SqlParser;
import io.ceresdb.common.util.internal.ThrowUtil;
import io.ceresdb.sql.SqlParserUtil;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;

public class JSqlParser
implements SqlParser {
    private final String sql;
    private boolean parsed;
    private SqlParser.StatementType statementType = SqlParser.StatementType.Unknown;
    private Statement stmt;

    public JSqlParser(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlParser.StatementType statementType() {
        this.parse();
        return this.statementType;
    }

    public List<String> tableNames() {
        this.parse();
        switch (this.statementType) {
            case Create: 
            case Select: 
            case Describe: {
                return SqlParserUtil.extractTableNames(this.stmt);
            }
            case Alter: {
                return Collections.singletonList(((Alter)this.stmt).getTable().getName());
            }
            case Show: {
                return Collections.singletonList(((ShowStatement)this.stmt).getName());
            }
            case Drop: {
                return Collections.singletonList(((Drop)this.stmt).getName().getName());
            }
            case Insert: {
                return Collections.singletonList(((Insert)this.stmt).getTable().getName());
            }
        }
        return (List)JSqlParser.reject("Invalid.statement: " + this.statementType);
    }

    public List<SqlParser.Column> createColumns() {
        this.parse();
        if (this.statementType == SqlParser.StatementType.Create) {
            return SqlParserUtil.extractCreateColumns((CreateTable)this.stmt);
        }
        return (List)JSqlParser.reject("Must be " + SqlParser.StatementType.Create);
    }

    private void parse() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)SqlParserUtil.amendSql(this.sql));
            this.statementType = stmt instanceof Select ? SqlParser.StatementType.Select : (stmt instanceof CreateTable ? SqlParser.StatementType.Create : (stmt instanceof Alter ? SqlParser.StatementType.Alter : (stmt instanceof DescribeStatement ? SqlParser.StatementType.Describe : (stmt instanceof ShowStatement ? SqlParser.StatementType.Show : (stmt instanceof Drop ? SqlParser.StatementType.Drop : (stmt instanceof Insert ? SqlParser.StatementType.Insert : SqlParser.StatementType.Unknown))))));
            this.stmt = stmt;
        }
        catch (JSQLParserException e) {
            ThrowUtil.throwException((Throwable)e);
        }
    }

    private static <T> T reject(String msg) {
        throw new IllegalArgumentException(msg);
    }
}

