/*
 * Decompiled with CFR 0.152.
 */
package io.ceresdb.sql;

import io.ceresdb.common.parser.SqlParser;
import io.ceresdb.common.util.Requires;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class SqlParserUtil {
    private static final String _TIMESTAMP_KEY_UC = "TIMESTAMP KEY";
    private static final String _TIMESTAMP_KEY_LC = "TIMESTAMP KEY".toLowerCase();
    private static final String _UNIQUE_KEY = "UNIQUE KEY";
    private static final String _TAG = "TAG";
    private static final String _CREATE_TABLE = "CREATE TABLE";

    public static List<String> extractTableNames(Statement stmt) {
        TablesNamesFinder tablesFinder = new TablesNamesFinder();
        return tablesFinder.getTableList(stmt);
    }

    public static String amendSql(String sql) {
        String ucSql = sql.trim().toUpperCase();
        if (ucSql.startsWith(_CREATE_TABLE)) {
            Requires.requireTrue((!ucSql.contains(_UNIQUE_KEY) ? 1 : 0) != 0, (Object)"`unique key` not supported");
            return sql.replace(_TIMESTAMP_KEY_UC, _UNIQUE_KEY).replace(_TIMESTAMP_KEY_LC, _UNIQUE_KEY);
        }
        return sql;
    }

    public static List<SqlParser.Column> extractCreateColumns(CreateTable createTable) {
        final String metricName = createTable.getTable().getName();
        String tsColName = (String)createTable.getIndexes().stream().filter(SqlParserUtil::isTimestampColumn).flatMap(idx -> idx.getColumnsNames().stream()).findFirst().orElseThrow(() -> new IllegalArgumentException("There must be a `timestamp` column"));
        Set tags = createTable.getColumnDefinitions().stream().filter(SqlParserUtil::isTagColumn).map(ColumnDefinition::getColumnName).collect(Collectors.toSet());
        return createTable.getColumnDefinitions().stream().map(col -> new SqlParser.Column((ColumnDefinition)col, tsColName, tags){
            final /* synthetic */ ColumnDefinition val$col;
            final /* synthetic */ String val$tsColName;
            final /* synthetic */ Set val$tags;
            {
                this.val$col = columnDefinition;
                this.val$tsColName = string2;
                this.val$tags = set;
            }

            public String metricName() {
                return metricName;
            }

            public String columnName() {
                return this.val$col.getColumnName();
            }

            public SqlParser.Column.ColumnType columnType() {
                if (this.val$tsColName.equals(this.columnName())) {
                    return SqlParser.Column.ColumnType.Timestamp;
                }
                if (this.val$tags.contains(this.columnName())) {
                    return SqlParser.Column.ColumnType.Tag;
                }
                return SqlParser.Column.ColumnType.Field;
            }

            public String valueType() {
                return this.val$col.getColDataType().getDataType();
            }
        }).collect(Collectors.toList());
    }

    private static boolean isTagColumn(ColumnDefinition col) {
        List specs = col.getColumnSpecs();
        if (specs == null || specs.isEmpty()) {
            return false;
        }
        for (String spec : specs) {
            if (!_TAG.equalsIgnoreCase(spec)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTimestampColumn(Index idx) {
        return _UNIQUE_KEY.equalsIgnoreCase(idx.getType());
    }
}

