/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.convertor;

import io.choerodon.core.convertor.ApplicationContextHelper;
import io.choerodon.core.convertor.ConvertorI;
import io.choerodon.core.exception.CommonException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertHelper.class);
    private static final Map<String, DestinClassData> CONVERT_MAP = new HashMap<String, DestinClassData>();
    static final String SPRING_PROXY_CLASS = "EnhancerBySpringCGLIB";

    private ConvertHelper() {
    }

    public static <T> List<T> convertList(List listSource, Class<T> destin) {
        if (listSource == null) {
            return Collections.emptyList();
        }
        if (listSource.isEmpty()) {
            return new ArrayList(0);
        }
        Class<?> source = listSource.get(0).getClass();
        if (source.getTypeName().contains(SPRING_PROXY_CLASS)) {
            source = source.getSuperclass();
        }
        DestinClassData destinClassData = ConvertHelper.getDestinClassData(source, destin);
        ArrayList<T> list = new ArrayList<T>(listSource.size());
        for (Object object : listSource) {
            T t = ConvertHelper.invokeConvert(destinClassData, object);
            list.add(t);
        }
        return list;
    }

    public static <T> T convert(Object obj, Class<T> destin) {
        if (obj == null) {
            return null;
        }
        Class<?> source = obj.getClass();
        if (source.getTypeName().contains(SPRING_PROXY_CLASS)) {
            source = source.getSuperclass();
        }
        DestinClassData destinClassData = ConvertHelper.getDestinClassData(source, destin);
        return ConvertHelper.invokeConvert(destinClassData, obj);
    }

    static <T> T invokeConvert(DestinClassData destinClassData, Object obj) {
        Object t = null;
        try {
            destinClassData.method.setAccessible(true);
            Object result = destinClassData.method.invoke((Object)destinClassData.convertorI, obj);
            if (result != null) {
                t = result;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("error.ConvertHelper.invokeConvert {}", (Object)e.toString());
        }
        return (T)t;
    }

    static DestinClassData getDestinClassData(Class source, Class destin) {
        Method method;
        String key = source.getTypeName() + destin.getTypeName();
        DestinClassData destinClassData = CONVERT_MAP.get(key);
        if (destinClassData == null) {
            destinClassData = new DestinClassData();
            CONVERT_MAP.put(key, destinClassData);
        }
        if (destinClassData.convertorClass == null) {
            destinClassData.convertorClass = ConvertHelper.getConvertClass(source, destin);
        }
        if (destinClassData.convertorI == null) {
            destinClassData.convertorI = (ConvertorI)ApplicationContextHelper.getSpringFactory().getBean(destinClassData.convertorClass);
        }
        if ((method = destinClassData.method) == null) {
            destinClassData.method = ConvertHelper.getMethod(source, destin, destinClassData.convertorClass);
        }
        return destinClassData;
    }

    private static Method getMethod(Class source, Class destin, Class<? extends ConvertorI> convertorClass) {
        Method[] methods;
        for (Method method : methods = convertorClass.getDeclaredMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!method.getReturnType().equals(destin) || paramTypes.length != 1 || !paramTypes[0].equals(source)) continue;
            return method;
        }
        throw new CommonException("error.convertHelper.getMethod, sourceClass: " + source.getName() + " destinClass: " + destin.getName(), new Object[0]);
    }

    private static Class<? extends ConvertorI> getConvertClass(Class source, Class destin) {
        Map convertorIMap = ApplicationContextHelper.getSpringFactory().getBeansOfType(ConvertorI.class);
        for (ConvertorI i : convertorIMap.values()) {
            Type[] interfacesTypes;
            for (Type t : interfacesTypes = i.getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType) || !ConvertHelper.isConvertorI(t, source, destin)) continue;
                return i.getClass();
            }
        }
        throw new CommonException("error.convertHelper.getConvertClass, sourceClass: " + source.getName() + " destinClass: " + destin.getName(), new Object[0]);
    }

    private static boolean isConvertorI(Type t, Class source, Class destin) {
        Type rawType = ((ParameterizedType)t).getRawType();
        if (rawType == null || !ConvertorI.class.getTypeName().equals(rawType.getTypeName())) {
            return false;
        }
        Type[] genericType2 = ((ParameterizedType)t).getActualTypeArguments();
        int num = 0;
        for (Type t2 : genericType2) {
            if (!source.getTypeName().equals(t2.getTypeName()) && !destin.getTypeName().equals(t2.getTypeName())) continue;
            ++num;
        }
        return num > 1;
    }

    static class DestinClassData {
        private Class<? extends ConvertorI> convertorClass;
        private Method method;
        private ConvertorI convertorI;

        DestinClassData() {
        }
    }
}

