/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.convertor;

import io.choerodon.core.convertor.ConvertHelper;
import io.choerodon.core.domain.Page;
import java.util.ArrayList;

public class ConvertPageHelper {
    private ConvertPageHelper() {
    }

    public static <T> Page<T> convertPage(Page pageSource, Class<T> destin) {
        Page pageBack = new Page();
        pageBack.setNumber(pageSource.getNumber());
        pageBack.setNumberOfElements(pageSource.getNumberOfElements());
        pageBack.setSize(pageSource.getSize());
        pageBack.setTotalElements(pageSource.getTotalElements());
        pageBack.setTotalPages(pageSource.getTotalPages());
        if (pageSource.getContent().isEmpty()) {
            return pageBack;
        }
        Class<?> source = pageSource.getContent().get(0).getClass();
        if (source.getTypeName().contains("EnhancerBySpringCGLIB")) {
            source = source.getSuperclass();
        }
        ConvertHelper.DestinClassData destinClassData = ConvertHelper.getDestinClassData(source, destin);
        ArrayList list = new ArrayList(pageSource.getContent().size());
        for (Object object : pageSource.getContent()) {
            Object t = ConvertHelper.invokeConvert(destinClassData, object);
            list.add(t);
        }
        pageBack.setContent(list);
        return pageBack;
    }
}

