/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.excel;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static Date string2Date(String value, String format) {
        if (value == null || "".equals(value)) {
            return null;
        }
        SimpleDateFormat sdf = DateUtil.getFormat(format);
        Date date = null;
        value = DateUtil.formatDate(value, format);
        try {
            date = sdf.parse(value);
        }
        catch (ParseException e) {
            logger.info("SimpleDateFormat parse exception: {}", (Object)e.getMessage());
        }
        return date;
    }

    protected static SimpleDateFormat getFormat(String format) {
        if (format == null || "".equals(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return new SimpleDateFormat(format);
    }

    public static String formatDate(String date, String format) {
        if (date == null || "".equals(date)) {
            return "";
        }
        ParsePosition pos = new ParsePosition(0);
        if ((date = date.replace("-", "").replace(":", "")) == null || "".equals(date.trim())) {
            return "";
        }
        try {
            if (Long.parseLong(date) == 0L) {
                return "";
            }
        }
        catch (Exception nume) {
            return date;
        }
        try {
            SimpleDateFormat inFmt;
            switch (date.trim().length()) {
                case 14: {
                    inFmt = new SimpleDateFormat("yyyyMMddHHmmss");
                    break;
                }
                case 12: {
                    inFmt = new SimpleDateFormat("yyyyMMddHHmm");
                    break;
                }
                case 10: {
                    inFmt = new SimpleDateFormat("yyyyMMddHH");
                    break;
                }
                case 8: {
                    inFmt = new SimpleDateFormat("yyyyMMdd");
                    break;
                }
                case 6: {
                    inFmt = new SimpleDateFormat("yyyyMM");
                    break;
                }
                default: {
                    return date;
                }
            }
            Date dt = inFmt.parse(date, pos);
            if (dt == null) {
                return date;
            }
            SimpleDateFormat outFmt = format == null || "".equals(format.trim()) ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5") : new SimpleDateFormat(format);
            return outFmt.format(dt);
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
            return date;
        }
    }
}

