/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.excel;

import io.choerodon.core.excel.ExcelUtil;
import io.choerodon.core.exception.CommonException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelReadHelper {
    private ExcelReadHelper() {
    }

    public static <T> List<T> read(File file, Class<T> clazz, Map<String, String> propertyMap) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        HSSFWorkbook workbook;
        String name = file.getName();
        if (ExcelUtil.isExcel2003(name)) {
            workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
        } else if (ExcelUtil.isExcel2007(name)) {
            workbook = new XSSFWorkbook((InputStream)new FileInputStream(file));
        } else {
            throw new CommonException("The file is not end with xls or xlsx", new Object[0]);
        }
        return ExcelUtil.processExcel((Workbook)workbook, clazz, propertyMap);
    }

    public static <T> List<T> read(MultipartFile multipartFile, Class<T> clazz, Map<String, String> propertyMap) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        HSSFWorkbook workbook;
        String name = multipartFile.getOriginalFilename();
        if (ExcelUtil.isExcel2003(name)) {
            workbook = new HSSFWorkbook(multipartFile.getInputStream());
        } else if (ExcelUtil.isExcel2007(name)) {
            workbook = new XSSFWorkbook(multipartFile.getInputStream());
        } else {
            throw new CommonException("The file is not end with xls or xlsx", new Object[0]);
        }
        return ExcelUtil.processExcel((Workbook)workbook, clazz, propertyMap);
    }
}

