/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.excel;

import io.choerodon.core.excel.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    private ExcelUtil() {
    }

    public static boolean isExcel2003(String name) {
        return name.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String name) {
        return name.matches("^.+\\.(?i)(xlsx)$");
    }

    public static <T> List<T> processExcel(Workbook workbook, Class<T> clazz, Map<String, String> propertyMap) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<T> list = new ArrayList<T>();
        Map<String, Field> fieldMap = ExcelUtil.getObjectField(clazz);
        Map<String, Method> setterMethodMap = ExcelUtil.getObjectSetterMethod(clazz);
        int sheetNum = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNum; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet == null) continue;
            int lastRowNum = sheet.getLastRowNum();
            boolean processTitleRow = false;
            HashMap<Integer, String> titleRow = new HashMap();
            for (int rowNum = 0; rowNum < lastRowNum + 1; ++rowNum) {
                Row row = sheet.getRow(rowNum);
                if (row == null) continue;
                if (!processTitleRow) {
                    titleRow = ExcelUtil.getTitleRow(row, propertyMap);
                    processTitleRow = true;
                    continue;
                }
                list.add(ExcelUtil.getObject(row, clazz, titleRow, fieldMap, setterMethodMap));
            }
        }
        return list;
    }

    private static Map<Integer, String> getTitleRow(Row row, Map<String, String> propertyMap) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int lastCellNum = row.getLastCellNum();
        for (int cellNum = 0; cellNum < lastCellNum; ++cellNum) {
            Cell cell = row.getCell(cellNum);
            if (cell == null) continue;
            int column = cell.getAddress().getColumn();
            String cellValue = cell.getStringCellValue();
            if (propertyMap == null || propertyMap.isEmpty()) {
                map.put(column, cellValue);
                continue;
            }
            if (!propertyMap.keySet().contains(cellValue)) {
                throw new IllegalArgumentException("propertyMap does not contain the cell value : " + cellValue);
            }
            propertyMap.forEach((k, v) -> {
                if (k.equals(cellValue)) {
                    map.put(column, (String)v);
                }
            });
        }
        return map;
    }

    public static <T> T getObject(Row row, Class<T> clazz, Map<Integer, String> titleRow, Map<String, Field> fieldMap, Map<String, Method> setterMethodMap) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        T t = clazz.newInstance();
        int lastCellNum = row.getLastCellNum();
        for (int cellNum = 0; cellNum < lastCellNum; ++cellNum) {
            Cell cell = row.getCell(cellNum);
            if (cell == null) continue;
            int column = cell.getAddress().getColumn();
            String cellValue = ExcelUtil.getValue(cell);
            String property = titleRow.get(column);
            if (property == null) continue;
            Field field = fieldMap.get(property);
            if (field == null) {
                throw new IllegalArgumentException("excel column name can not match the fields of object, column : " + column);
            }
            Method method = setterMethodMap.get(property);
            if (method == null) {
                throw new IllegalArgumentException("excel column name can not match the setter methods of object, column : " + column);
            }
            ExcelUtil.setObjectPropertyValue(t, field, method, cellValue);
        }
        return t;
    }

    public static Map<String, Field> getObjectField(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            String fieldName = field.getName();
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static Map<String, Method> getObjectSetterMethod(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getDeclaredMethods();
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        block0: for (Field field : fields) {
            String fieldName = field.getName();
            for (Method method : methods) {
                String methodName = method.getName();
                if (methodName == null || !"set".equals(methodName.substring(0, 3)) || !Modifier.isPublic(method.getModifiers()) || !("set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1)).equals(methodName)) continue;
                methodMap.put(fieldName, method);
                continue block0;
            }
        }
        return methodMap;
    }

    public static String getValue(Cell cell) {
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 0) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue());
        }
        return String.valueOf(cell.getStringCellValue());
    }

    public static void setObjectPropertyValue(Object obj, Field field, Method method, String value) throws InvocationTargetException, IllegalAccessException {
        Object object = new Object();
        String type = field.getType().getName();
        if ("java.lang.String".equals(type) || "String".equals(type)) {
            object = value;
        } else if ("java.lang.Integer".equals(type) || "java.lang.int".equals(type) || "Integer".equals(type) || "int".equals(type)) {
            if (value.length() > 0) {
                object = Integer.valueOf(value);
            }
        } else if ("java.lang.Float".equals(type) || "java.lang.float".equals(type) || "Float".equals(type) || "float".equals(type)) {
            if (value.length() > 0) {
                object = Float.valueOf(value);
            }
        } else if ("java.lang.Double".equals(type) || "java.lang.double".equals(type) || "Double".equals(type) || "double".equals(type)) {
            if (value.length() > 0) {
                object = Double.valueOf(value);
            }
        } else if ("java.math.BigDecimal".equals(type) || "BigDecimal".equals(type)) {
            if (value.length() > 0) {
                object = new BigDecimal(value);
            }
        } else if ("java.util.Date".equals(type) || "Date".equals(type)) {
            if (value.length() > 0) {
                object = value.length() == 19 || value.length() == 14 ? DateUtil.string2Date(value, "yyyyMMddHH24mmss") : DateUtil.string2Date(value, "yyyyMMdd");
            }
        } else if ("java.sql.Timestamp".equals(type)) {
            if (value.length() > 0) {
                object = DateUtil.formatDate(value, "yyyyMMddHH24mmss");
            }
        } else if ("java.lang.Boolean".equals(type) || "Boolean".equals(type)) {
            if (value.length() > 0) {
                object = Boolean.valueOf(value);
            }
        } else if (("java.lang.Long".equals(type) || "java.lang.long".equals(type) || "Long".equals(type) || "long".equals(type)) && value.length() > 0) {
            object = Long.valueOf(value);
        }
        method.invoke(obj, object);
    }
}

