/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.core.oauth.CustomClientDetails;
import io.choerodon.core.oauth.CustomUserDetails;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;

public class CustomTokenConverter
extends DefaultAccessTokenConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomTokenConverter.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String USER_ID = "userId";
    private static final String ORGANIZATION_ID = "organizationId";
    private static final String ADDITION_INFO = "additionInfo";
    private UserDetailsService userDetailsService;
    private ClientDetailsService clientDetailsService;

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public Map<String, ?> convertAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        Map map = super.convertAccessToken(token, authentication);
        Object details = authentication.getPrincipal();
        if (details instanceof CustomUserDetails) {
            CustomUserDetails user = (CustomUserDetails)this.userDetailsService.loadUserByUsername(((CustomUserDetails)((Object)details)).getUsername());
            map.put(USER_ID, user.getUserId().toString());
            map.put("language", user.getLanguage());
            map.put("timeZone", user.getTimeZone());
            map.put("email", user.getEmail());
            map.put(ORGANIZATION_ID, user.getOrganizationId().toString());
            map.put("admin", user.getAdmin());
            if (user.getAdditionInfo() != null) {
                map.put(ADDITION_INFO, user.getAdditionInfo());
            }
        } else if (details instanceof String) {
            CustomClientDetails client = (CustomClientDetails)this.clientDetailsService.loadClientByClientId((String)details);
            map.put(ORGANIZATION_ID, client.getOrganizationId());
            if (client.getAdditionalInformation() != null) {
                map.put(ADDITION_INFO, client.getAdditionalInformation());
            }
        }
        return map;
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        if (map.get("principal") != null) {
            map = (Map)map.get("principal");
        }
        if (!map.containsKey("user_name")) {
            map.put("user_name", map.get("username"));
        }
        OAuth2Authentication authentication = super.extractAuthentication(map);
        if (map.containsKey(USER_ID)) {
            CustomUserDetails user = new CustomUserDetails(authentication.getName(), "unknown password", authentication.getAuthorities());
            user.setUserId((long)((Integer)map.get(USER_ID)));
            user.setLanguage((String)map.get("language"));
            user.setTimeZone((String)map.get("timeZone"));
            user.setEmail((String)map.get("email"));
            user.setAdmin((Boolean)map.get("admin"));
            user.setOrganizationId((long)((Integer)map.get(ORGANIZATION_ID)));
            try {
                if (map.get(ADDITION_INFO) != null) {
                    user.setAdditionInfo((Map)map.get(ADDITION_INFO));
                }
            }
            catch (Exception e) {
                LOGGER.warn("parser addition info error:{}", (Throwable)e);
            }
            authentication.setDetails((Object)user);
        } else {
            CustomClientDetails client = new CustomClientDetails();
            client.setClientId(authentication.getName());
            client.setAuthorities(authentication.getAuthorities());
            client.setOrganizationId((long)((Integer)map.get(ORGANIZATION_ID)));
            try {
                if (map.get(ADDITION_INFO) != null) {
                    client.setAdditionalInformation((Map)MAPPER.readValue((String)map.get(ADDITION_INFO), Map.class));
                }
            }
            catch (Exception e) {
                LOGGER.warn("parser addition info error:{}", (Throwable)e);
            }
            authentication.setDetails((Object)client);
        }
        return authentication;
    }
}

