/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.core.oauth.resource;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.core.oauth.DetailsHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateSerializer
extends JsonSerializer<Date> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateSerializer.class);

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            CustomUserDetails details = DetailsHelper.getUserDetails();
            if (details != null && details.getTimeZone() != null) {
                dateFormatGmt.setTimeZone(TimeZone.getTimeZone(details.getTimeZone()));
            }
            jsonGenerator.writeString(dateFormatGmt.format(date));
        }
        catch (Exception e) {
            LOGGER.warn("date format error : {}", (Throwable)e);
            jsonGenerator.writeNull();
        }
    }
}

