/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis;

import io.choerodon.mybatis.common.CustomProvider;
import io.choerodon.mybatis.entity.DbType;
import io.choerodon.mybatis.interceptor.AuditInterceptor;
import io.choerodon.mybatis.interceptor.MultiLanguageInterceptor;
import io.choerodon.mybatis.interceptor.OvnInterceptor;
import io.choerodon.mybatis.interceptor.SequenceInterceptor;
import io.choerodon.mybatis.util.OGNL;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
@PropertySource(value={"classpath:default-choerodon-mybatis-config.properties"})
public class ChoerodonMybatisAutoConfiguration {
    @Value(value="${db.type}")
    private String dbType;
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisAutoConfiguration.class);
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactories;
    @Autowired(required=false)
    private List<CustomProvider> customProviders;

    @PostConstruct
    public void setLanguageProvider() {
        if (this.customProviders == null || this.customProviders.isEmpty()) {
            LOGGER.warn("\u8bf7\u5b9e\u73b0 CustomProvider \u63a5\u53e3\u4ee5\u63d0\u4f9b\u5f53\u524d\u8bed\u8a00\u3002");
        } else {
            OGNL.customProvider = this.customProviders.get(0);
        }
    }

    @PostConstruct
    public void addAuditInterceptor() {
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactories) {
            DbType type = DbType.getDbType(this.dbType);
            if (type != null) {
                switch (type) {
                    case HANA: 
                    case ORACLE: 
                    case POSTGRE_SQL: {
                        sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new SequenceInterceptor(type));
                    }
                }
            }
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new MultiLanguageInterceptor());
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new OvnInterceptor());
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new AuditInterceptor());
        }
    }
}

