/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.entity;

import io.choerodon.mybatis.entity.CustomEntityColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;

public class CustomEntityTable
extends EntityTable {
    private boolean multiLanguage = false;
    private LinkedHashSet<EntityColumn> multiLanguageColumns;
    private Set<CustomEntityColumn> allColumns = new LinkedHashSet<CustomEntityColumn>();
    private Map<String, String> aliasMapping = new HashMap<String, String>();
    private Map<String, CustomEntityColumn> joinMapping = new HashMap<String, CustomEntityColumn>();
    private List<EntityColumn> whereColumns = new ArrayList<EntityColumn>();
    private Set<EntityColumn> sortColumns = new LinkedHashSet<EntityColumn>();
    private static final char ALIAS_START = 'A';
    private int currentAliasCharIndex = 0;

    public CustomEntityTable(Class<?> entityClass) {
        super(entityClass);
        this.propertyMap = new HashMap();
        this.createAlias(entityClass.getCanonicalName());
    }

    public boolean isMultiLanguage() {
        return this.multiLanguage;
    }

    public void setMultiLanguage(boolean multiLanguage) {
        this.multiLanguage = multiLanguage;
    }

    public String getMultiLanguageTableName() {
        if (this.getName().toUpperCase().endsWith("_B")) {
            return this.getName().toUpperCase().substring(0, this.getName().length() - 2) + "_TL";
        }
        return this.getName().toUpperCase() + "_TL";
    }

    public LinkedHashSet<EntityColumn> getMultiLanguageColumns() {
        return this.multiLanguageColumns;
    }

    public void setMultiLanguageColumns(LinkedHashSet<EntityColumn> multiLanguageColumns) {
        this.multiLanguageColumns = multiLanguageColumns;
    }

    public void initPropertyMap() {
        for (EntityColumn column : this.getEntityClassColumns()) {
            this.propertyMap.put(column.getProperty(), column);
        }
    }

    public void createAlias(String key) {
        if (!this.aliasMapping.containsKey(key)) {
            this.aliasMapping.put(key, this.generateAlias());
        }
    }

    private String generateAlias() {
        return String.valueOf((char)(65 + this.currentAliasCharIndex++));
    }

    public Map<String, String> getAliasMapping() {
        return this.aliasMapping;
    }

    public void setAliasMapping(Map<String, String> aliasMapping) {
        this.aliasMapping = aliasMapping;
    }

    public Map<String, CustomEntityColumn> getJoinMapping() {
        return this.joinMapping;
    }

    public void setJoinMapping(Map<String, CustomEntityColumn> joinMapping) {
        this.joinMapping = joinMapping;
    }

    public String getAlias(String key) {
        return key == null ? this.aliasMapping.get(this.getEntityClass().getCanonicalName()) : this.aliasMapping.get(key);
    }

    public String getAlias() {
        return this.getAlias(null);
    }

    public List<EntityColumn> getWhereColumns() {
        return this.whereColumns;
    }

    public void setWhereColumns(List<EntityColumn> whereColumns) {
        this.whereColumns = whereColumns;
    }

    public Set<EntityColumn> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(Set<EntityColumn> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public int getCurrentAliasCharIndex() {
        return this.currentAliasCharIndex;
    }

    public void setCurrentAliasCharIndex(int currentAliasCharIndex) {
        this.currentAliasCharIndex = currentAliasCharIndex;
    }

    public Set<CustomEntityColumn> getAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(Set<CustomEntityColumn> allColumns) {
        this.allColumns = allColumns;
    }

    public CustomEntityColumn findColumnByProperty(String property) {
        CustomEntityColumn entityColumn = null;
        for (CustomEntityColumn column : this.getAllColumns()) {
            if (!column.getProperty().equals(property)) continue;
            entityColumn = column;
            break;
        }
        return entityColumn;
    }
}

