/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.entity;

public enum DbType {
    ORACLE("oracle", false, true),
    MYSQL("mysql", true, false),
    SQL_SERVER("sqlserver", true, false),
    H2("h2", true, false),
    HANA("hana", false, true),
    POSTGRE_SQL("postgresql", false, true);

    private final String value;
    private final boolean supportAutoIncrement;
    private final boolean supportSequence;

    private DbType(String value, boolean supportAutoIncrement, boolean supportSequence) {
        this.value = value;
        this.supportAutoIncrement = supportAutoIncrement;
        this.supportSequence = supportSequence;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated
    public boolean isSuppportAutoIncrement() {
        return this.supportAutoIncrement;
    }

    public boolean isSupportAutoIncrement() {
        return this.supportAutoIncrement;
    }

    public boolean isSupportSequence() {
        return this.supportSequence;
    }

    public String toString() {
        return this.value;
    }

    public static DbType getDbType(String type) {
        for (DbType dbType : DbType.values()) {
            if (!dbType.toString().equalsIgnoreCase(type)) continue;
            return dbType;
        }
        return null;
    }
}

