/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.interceptor;

import io.choerodon.mybatis.entity.BaseDTO;
import io.choerodon.mybatis.util.OGNL;
import java.util.Date;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AuditInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter = invocation.getArgs()[1];
        MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
        if (parameter instanceof BaseDTO) {
            switch (statement.getSqlCommandType()) {
                case INSERT: {
                    ((BaseDTO)parameter).setCreatedBy(OGNL.principal());
                    ((BaseDTO)parameter).setCreationDate(new Date());
                }
                case UPDATE: {
                    ((BaseDTO)parameter).setLastUpdatedBy(OGNL.principal());
                    ((BaseDTO)parameter).setLastUpdateDate(new Date());
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

