/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.interceptor;

import io.choerodon.mybatis.annotation.MultiLanguage;
import io.choerodon.mybatis.entity.BaseDTO;
import io.choerodon.mybatis.entity.Criteria;
import io.choerodon.mybatis.entity.CustomEntityColumn;
import io.choerodon.mybatis.entity.CustomEntityTable;
import io.choerodon.mybatis.mapperhelper.MultipleJdbc3KeyGenerator;
import io.choerodon.mybatis.util.OGNL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Table;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityField;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MultiLanguageInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(MultiLanguageInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof Executor) {
            Map map;
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            MetaObject msObject = SystemMetaObject.forObject((Object)mappedStatement);
            KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
            if (keyGenerator instanceof Jdbc3KeyGenerator) {
                msObject.setValue("keyGenerator", (Object)new MultipleJdbc3KeyGenerator());
            }
            Object domain = invocation.getArgs()[1];
            Criteria criteria = null;
            if (domain instanceof MapperMethod.ParamMap && (map = (Map)domain).containsKey("criteria")) {
                criteria = (Criteria)((Map)domain).get("criteria");
                domain = ((Map)domain).get("dto");
            }
            if (domain instanceof BaseDTO) {
                BaseDTO dtoObj = (BaseDTO)domain;
                if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT || mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
                    Object obj = invocation.proceed();
                    this.proceedMultiLanguage(dtoObj, invocation, mappedStatement, criteria);
                    return obj;
                }
                if (mappedStatement.getSqlCommandType() == SqlCommandType.DELETE) {
                    Object obj = invocation.proceed();
                    this.proceedDeleteMultiLanguage(dtoObj, invocation);
                    return obj;
                }
            }
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    private void proceedMultiLanguage(BaseDTO parameterObject, Invocation invocation, MappedStatement mappedStatement, Criteria criteria) throws Exception {
        List<String> updateFields = criteria != null ? criteria.getUpdateFields() : null;
        Class<?> clazz = parameterObject.getClass();
        MultiLanguage multiLanguageTable = clazz.getAnnotation(MultiLanguage.class);
        if (multiLanguageTable == null) {
            return;
        }
        Table table = clazz.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"annotation @Table not found!");
        String tableName = table.name();
        Assert.hasText((String)tableName, (String)"@Table name not found!");
        tableName = MultiLanguageInterceptor.getTlTableName(tableName);
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            this.proceedInsertMultiLanguage(tableName, parameterObject, (Executor)invocation.getTarget());
        } else if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            if (parameterObject.get__tls().isEmpty()) {
                this.proceedUpdateMultiLanguage(tableName, parameterObject, (Executor)invocation.getTarget(), updateFields);
            } else {
                this.proceedUpdateMultiLanguage2(tableName, parameterObject, (Executor)invocation.getTarget(), updateFields);
            }
        }
    }

    private static String getTlTableName(String tableName) {
        return tableName.substring(0, tableName.length() - 2) + "_tl";
    }

    private void proceedDeleteMultiLanguage(BaseDTO parameterObject, Invocation invocation) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        MultiLanguage multiLanguageTable = clazz.getAnnotation(MultiLanguage.class);
        if (multiLanguageTable == null) {
            return;
        }
        Table table = clazz.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"annotation @Table not found!");
        String tableName = table.name();
        Assert.hasText((String)tableName, (String)"@Table name not found!");
        tableName = MultiLanguageInterceptor.getTlTableName(tableName);
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        for (EntityColumn entityColumn : EntityHelper.getEntityTable(clazz).getEntityClassPKColumns()) {
            EntityField f = entityColumn.getEntityField();
            Object v = f.getValue((Object)parameterObject);
            keys.add(entityColumn.getColumn() + "=?");
            objs.add(v);
        }
        for (Object e : objs) {
            if (e != null) continue;
            return;
        }
        if (keys.size() > 0) {
            Executor executor = (Executor)invocation.getTarget();
            StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
            stringBuilder.append(tableName).append(" WHERE ").append(String.join((CharSequence)" AND ", keys));
            this.executeSql(executor.getTransaction().getConnection(), stringBuilder.toString(), objs);
        }
    }

    private void proceedInsertMultiLanguage(String tableName, BaseDTO parameterObject, Executor executor) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> placeholders = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + "(");
        for (EntityColumn c : EntityHelper.getEntityTable(clazz).getEntityClassPKColumns()) {
            EntityField f = c.getEntityField();
            keys.add(c.getColumn());
            placeholders.add("?");
            objs.add(SystemMetaObject.forObject((Object)parameterObject).getValue(f.getName()));
        }
        keys.add("LANG");
        placeholders.add("?");
        objs.add(null);
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassColumns()) {
            CustomEntityColumn customEntityColumn = (CustomEntityColumn)column;
            if (!customEntityColumn.isMultiLanguage()) continue;
            keys.add(column.getColumn());
            placeholders.add("?");
            Map<String, String> tls = parameterObject.get__tls().get(column.getProperty());
            if (tls == null) {
                objs.add(column.getEntityField().getValue((Object)parameterObject));
                continue;
            }
            objs.add(null);
        }
        keys.add("CREATED_BY");
        placeholders.add("" + parameterObject.getCreatedBy());
        keys.add("CREATION_DATE");
        placeholders.add("CURRENT_TIMESTAMP");
        keys.add("LAST_UPDATED_BY");
        placeholders.add("" + parameterObject.getCreatedBy());
        keys.add("LAST_UPDATE_DATE");
        placeholders.add("CURRENT_TIMESTAMP");
        sql.append(String.join((CharSequence)",", keys));
        sql.append(") VALUES (").append(String.join((CharSequence)",", placeholders)).append(")");
        EntityField[] mlFields = (EntityField[])((CustomEntityTable)EntityHelper.getEntityTable(clazz)).getMultiLanguageColumns().stream().map(EntityColumn::getEntityField).toArray(EntityField[]::new);
        Set<String> languages = OGNL.getSupportedLanguages();
        for (String language : languages) {
            objs.set(objs.size() - mlFields.length - 1, language);
            for (int i = 0; i < mlFields.length; ++i) {
                int idx = objs.size() - mlFields.length + i;
                Map<String, String> tls = parameterObject.get__tls().get(mlFields[i].getName());
                if (tls == null) continue;
                objs.set(idx, tls.get(language));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Insert TL(Batch):{}", (Object)sql.toString());
                this.logger.debug("Parameters:{}", objs);
            }
            this.executeSql(executor.getTransaction().getConnection(), sql.toString(), objs);
        }
    }

    private void proceedUpdateMultiLanguage(String tableName, BaseDTO parameterObject, Executor executor, List<String> updateFields) throws Exception {
        Connection connection;
        int updateCount;
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassColumns()) {
            Object value;
            CustomEntityColumn customEntityColumn = (CustomEntityColumn)column;
            if (!customEntityColumn.isMultiLanguage()) continue;
            EntityField field = column.getEntityField();
            if (null != updateFields && !updateFields.isEmpty() && !updateFields.contains(field.getName()) || (value = field.getValue((Object)parameterObject)) == null) continue;
            sets.add(column.getColumn() + "=?");
            objs.add(value);
        }
        if (sets.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("None multi language field has TL value. skip update.");
            }
            return;
        }
        sets.add("LAST_UPDATED_BY=" + parameterObject.getLastUpdatedBy());
        sets.add("LAST_UPDATE_DATE=CURRENT_TIMESTAMP");
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassPKColumns()) {
            EntityField field = column.getEntityField();
            keys.add(column.getColumn() + "=?");
            objs.add(field.getValue((Object)parameterObject));
        }
        keys.add("LANG=?");
        objs.add(OGNL.language());
        sql.append(String.join((CharSequence)",", sets));
        sql.append(" WHERE ").append(String.join((CharSequence)" AND ", keys));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update TL(Classic):{}", (Object)sql.toString());
            this.logger.debug("Parameters:{}", objs);
        }
        if ((updateCount = this.executeSql(connection = executor.getTransaction().getConnection(), sql.toString(), objs)) < 1) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Update TL failed(Classic). update count:" + updateCount);
            }
            this.doInsertForMissingTlData(tableName, OGNL.language(), parameterObject, connection);
        }
    }

    private void proceedUpdateMultiLanguage2(String tableName, BaseDTO parameterObject, Executor executor, List<String> updateFields) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<String> updateFieldNames = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassColumns()) {
            CustomEntityColumn customEntityColumn = (CustomEntityColumn)column;
            if (!customEntityColumn.isMultiLanguage() || null != updateFields && !updateFields.isEmpty() && !updateFields.contains(column.getProperty())) continue;
            Map<String, String> tls = parameterObject.get__tls().get(column.getProperty());
            if (tls == null) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("TL value for field '{}' not exists.", (Object)column.getProperty());
                continue;
            }
            sets.add(column.getColumn() + "=?");
            updateFieldNames.add(column.getProperty());
            objs.add(null);
        }
        if (sets.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("None multi language field has TL value. skip update.");
            return;
        }
        sets.add("LAST_UPDATED_BY=" + parameterObject.getLastUpdatedBy());
        sets.add("LAST_UPDATE_DATE=CURRENT_TIMESTAMP");
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassPKColumns()) {
            keys.add(column.getColumn() + "=?");
            objs.add(column.getEntityField().getValue((Object)parameterObject));
        }
        keys.add("LANG=?");
        objs.add(null);
        sql.append(String.join((CharSequence)",", sets));
        sql.append(" WHERE ").append(String.join((CharSequence)" AND ", keys));
        Connection connection = executor.getTransaction().getConnection();
        Set<String> languages = OGNL.getSupportedLanguages();
        for (String language : languages) {
            int updateCount;
            for (int i = 0; i < updateFieldNames.size(); ++i) {
                Map<String, String> tls = parameterObject.get__tls().get(updateFieldNames.get(i));
                objs.set(i, tls.get(language));
            }
            objs.set(objs.size() - 1, language);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Update TL(Batch):{}", (Object)sql.toString());
                this.logger.debug("Parameters:{}", objs, (Object)", ");
            }
            if ((updateCount = this.executeSql(connection, sql.toString(), objs)) >= 1) continue;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Update TL failed(Batch). update count:{},lang:{}", (Object)updateCount, (Object)language);
            }
            this.doInsertForMissingTlData(tableName, language, parameterObject, connection);
        }
    }

    private void doInsertForMissingTlData(String tableName, String lang, BaseDTO parameterObject, Connection connection) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableName).append(" (");
        ArrayList<Object> values = new ArrayList<Object>();
        int pn = 0;
        for (Object column : EntityHelper.getEntityTable(clazz).getEntityClassPKColumns()) {
            sb.append(column.getColumn()).append(",");
            values.add(column.getEntityField().getValue((Object)parameterObject));
            ++pn;
        }
        sb.append("LANG");
        ++pn;
        values.add(lang);
        Map<String, Map<String, String>> tls = parameterObject.get__tls();
        for (EntityColumn column : EntityHelper.getEntityTable(clazz).getEntityClassColumns()) {
            CustomEntityColumn customEntityColumn = (CustomEntityColumn)column;
            if (!customEntityColumn.isMultiLanguage()) continue;
            sb.append(",").append(column.getColumn());
            if (tls != null && tls.get(column.getProperty()) != null) {
                values.add(tls.get(column.getProperty()).get(lang));
            } else {
                values.add(column.getEntityField().getValue((Object)parameterObject));
            }
            ++pn;
        }
        sb.append(",CREATED_BY");
        values.add(parameterObject.getCreatedBy());
        sb.append(",CREATION_DATE");
        sb.append(",LAST_UPDATED_BY");
        values.add(parameterObject.getLastUpdatedBy());
        sb.append(",LAST_UPDATE_DATE");
        sb.append(") VALUES (");
        for (int i = 0; i < pn; ++i) {
            sb.append("?,");
        }
        sb.append("?");
        sb.append(",CURRENT_TIMESTAMP");
        sb.append(",?");
        sb.append(",CURRENT_TIMESTAMP");
        sb.append(")");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Insert Missing TL record:" + sb.toString());
            this.logger.debug("Parameters: {}", values);
        }
        this.executeSql(connection, sb.toString(), values);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    protected int executeSql(Connection connection, String sql, List<Object> params) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int i = 1;
            for (Object obj : params) {
                ps.setObject(i++, obj);
            }
            ps.execute();
            int n = ps.getUpdateCount();
            return n;
        }
    }
}

