/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.interceptor;

import io.choerodon.mybatis.entity.BaseDTO;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OvnInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Map map;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object domain = args[1];
        if (domain instanceof Map && (map = (Map)domain).containsKey("dto")) {
            domain = ((Map)domain).get("dto");
        }
        if (!(domain instanceof BaseDTO)) {
            return invocation.proceed();
        }
        BaseDTO baseDTO = (BaseDTO)domain;
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            baseDTO.setObjectVersionNumber(1L);
        }
        Object result = invocation.proceed();
        Long ovn = baseDTO.getObjectVersionNumber();
        if (ovn != null && mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            baseDTO.setObjectVersionNumber(ovn + 1L);
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

