/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.interceptor;

import io.choerodon.mybatis.entity.DbType;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SelectKeyGenerator;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SequenceInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(SequenceInterceptor.class);
    private Set<String> processedStatement = new ConcurrentSkipListSet<String>();
    private DbType dbType;

    public SequenceInterceptor(DbType dbType) {
        this.dbType = dbType;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof Executor) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object domain = invocation.getArgs()[1];
            if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
                this.processKey(mappedStatement, domain.getClass());
            }
        }
        return invocation.proceed();
    }

    private void processKey(MappedStatement ms, Class<?> entityClass) {
        try {
            if (!this.processedStatement.contains(ms.getId())) {
                String identity;
                this.processedStatement.add(ms.getId());
                String keyId = ms.getId() + "!selectKey";
                EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                switch (this.dbType) {
                    case HANA: {
                        identity = "SELECT " + entityTable.getName() + "_s.nextval FROM DUMMY";
                        break;
                    }
                    case POSTGRE_SQL: {
                        identity = "SELECT nextval('" + entityTable.getName() + "_s')";
                        break;
                    }
                    default: {
                        identity = "SELECT " + entityTable.getName() + "_s.nextval FROM DUAL";
                    }
                }
                EntityColumn column = (EntityColumn)entityTable.getEntityClassPKColumns().iterator().next();
                RawSqlSource sqlSource = new RawSqlSource(ms.getConfiguration(), identity, entityClass);
                MappedStatement keyStatement = ms.getConfiguration().getMappedStatement(keyId, false);
                MetaObject keyStatementMetaObject = SystemMetaObject.forObject((Object)keyStatement);
                keyStatementMetaObject.setValue("sqlSource", (Object)sqlSource);
                SelectKeyGenerator keyGenerator = new SelectKeyGenerator(keyStatement, true);
                MetaObject msObject = SystemMetaObject.forObject((Object)ms);
                msObject.setValue("keyGenerator", (Object)keyGenerator);
            }
        }
        catch (MapperException mapperException) {
            // empty catch block
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

