/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.mapperhelper;

import io.choerodon.mybatis.annotation.ExtensionAttribute;
import io.choerodon.mybatis.annotation.MultiLanguage;
import io.choerodon.mybatis.annotation.MultiLanguageField;
import io.choerodon.mybatis.common.query.JoinColumn;
import io.choerodon.mybatis.common.query.JoinOn;
import io.choerodon.mybatis.common.query.JoinTable;
import io.choerodon.mybatis.common.query.Where;
import io.choerodon.mybatis.entity.CustomEntityColumn;
import io.choerodon.mybatis.entity.CustomEntityTable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.JoinType;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.annotation.ColumnType;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.annotation.Order;
import tk.mybatis.mapper.code.IdentityDialect;
import tk.mybatis.mapper.code.ORDER;
import tk.mybatis.mapper.code.Style;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityField;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.genid.GenId;
import tk.mybatis.mapper.gensql.GenSql;
import tk.mybatis.mapper.mapperhelper.FieldHelper;
import tk.mybatis.mapper.mapperhelper.resolve.EntityResolve;
import tk.mybatis.mapper.util.SimpleTypeUtil;
import tk.mybatis.mapper.util.SqlReservedWords;
import tk.mybatis.mapper.util.StringUtil;

public class CustomEntityResolve
implements EntityResolve {
    private final Log log = LogFactory.getLog(CustomEntityResolve.class);

    public EntityTable resolveEntity(Class<?> entityClass, Config config) {
        Table table;
        Style style = config.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            style = nameStyle.value();
        }
        CustomEntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !"".equals((table = entityClass.getAnnotation(Table.class)).name())) {
            entityTable = new CustomEntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new CustomEntityTable(entityClass);
            String tableName = StringUtil.convertByStyle((String)entityClass.getSimpleName(), (Style)style);
            if (StringUtil.isNotEmpty((String)config.getWrapKeyword()) && SqlReservedWords.containsWord((String)tableName)) {
                tableName = MessageFormat.format(config.getWrapKeyword(), tableName);
            }
            entityTable.setName(tableName);
        }
        if (entityClass.isAnnotationPresent(MultiLanguage.class)) {
            entityTable.setMultiLanguage(true);
            entityTable.setMultiLanguageColumns(new LinkedHashSet<EntityColumn>());
        }
        entityTable.setEntityClassColumns(new LinkedHashSet());
        entityTable.setEntityClassPKColumns(new LinkedHashSet());
        List fields = null;
        fields = config.isEnableMethodAnnotation() ? FieldHelper.getAll(entityClass) : FieldHelper.getFields(entityClass);
        ExtensionAttribute extensionAttribute = entityClass.getAnnotation(ExtensionAttribute.class);
        boolean useExt = extensionAttribute == null || !extensionAttribute.disable();
        for (EntityField field : fields) {
            if (config.isUseSimpleType() && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(ColumnType.class) && !SimpleTypeUtil.isSimpleType((Class)field.getJavaType()) && (!config.isEnumAsSimpleType() || !Enum.class.isAssignableFrom(field.getJavaType())) || !useExt && field.getName().matches("attribute(\\d+|Category)")) continue;
            this.processField(entityTable, field, config, style);
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        return entityTable;
    }

    protected void processField(final CustomEntityTable entityTable, final EntityField field, Config config, Style style) {
        JoinColumn jc;
        CustomEntityColumn entityColumn = new CustomEntityColumn(entityTable);
        entityColumn.setUseJavaType(config.isUseJavaType());
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        if (field.isAnnotationPresent(Transient.class)) {
            entityColumn.setSelectable(false);
            entityColumn.setInsertable(false);
            entityColumn.setUpdatable(false);
        }
        if (entityTable.isMultiLanguage()) {
            if (field.isAnnotationPresent(Id.class)) {
                JoinTable jt = new JoinTable(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return JoinTable.class;
                    }

                    @Override
                    public String name() {
                        return "multiLanguageJoin";
                    }

                    @Override
                    public boolean joinMultiLanguageTable() {
                        return true;
                    }

                    @Override
                    public Class<?> target() {
                        return entityTable.getEntityClass();
                    }

                    @Override
                    public JoinType type() {
                        return JoinType.INNER;
                    }

                    @Override
                    public JoinOn[] on() {
                        JoinOn on1 = new JoinOn(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return JoinOn.class;
                            }

                            @Override
                            public String joinField() {
                                return field.getName();
                            }

                            @Override
                            public String joinExpression() {
                                return "";
                            }
                        };
                        JoinOn on2 = new JoinOn(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return JoinOn.class;
                            }

                            @Override
                            public String joinField() {
                                return "lang";
                            }

                            @Override
                            public String joinExpression() {
                                return "#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}";
                            }
                        };
                        return new JoinOn[]{on1, on2};
                    }
                };
                entityColumn.addJoinTable(jt);
                entityTable.createAlias(CustomEntityResolve.buildJoinKey(jt));
                entityTable.getJoinMapping().put(jt.name(), entityColumn);
            }
            if (field.isAnnotationPresent(MultiLanguageField.class)) {
                jc = new JoinColumn(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return JoinColumn.class;
                    }

                    @Override
                    public String joinName() {
                        return "multiLanguageJoin";
                    }

                    @Override
                    public String field() {
                        return field.getName();
                    }

                    @Override
                    public String expression() {
                        return "";
                    }
                };
                entityColumn.setJoinColumn(jc);
                entityColumn.setSelectable(true);
            }
        }
        try {
            Field entityField = EntityField.class.getDeclaredField("field");
            entityField.setAccessible(true);
            Field metaFiled = (Field)entityField.get(field);
            JoinTable[] jts = (JoinTable[])metaFiled.getAnnotationsByType(JoinTable.class);
            if (jts != null) {
                for (JoinTable joinTable : jts) {
                    entityColumn.addJoinTable(joinTable);
                    entityTable.createAlias(CustomEntityResolve.buildJoinKey(joinTable));
                    entityTable.getJoinMapping().put(joinTable.name(), entityColumn);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (field.isAnnotationPresent(JoinColumn.class)) {
            jc = (JoinColumn)field.getAnnotation(JoinColumn.class);
            entityColumn.setJoinColumn(jc);
            entityColumn.setSelectable(true);
            entityColumn.setInsertable(false);
            entityColumn.setUpdatable(false);
        }
        if (field.isAnnotationPresent(Where.class)) {
            Where where = (Where)field.getAnnotation(Where.class);
            entityColumn.setWhere(where);
            entityTable.getWhereColumns().add(entityColumn);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = (Column)field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(MultiLanguageField.class)) {
            entityColumn.setMultiLanguage(true);
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = (ColumnType)field.getAnnotation(ColumnType.class);
            entityColumn.setBlob(columnType.isBlob());
            if (StringUtil.isEmpty((String)columnName) && StringUtil.isNotEmpty((String)columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        }
        if (StringUtil.isEmpty((String)columnName)) {
            columnName = StringUtil.convertByStyle((String)field.getName(), (Style)style);
        }
        if (StringUtil.isNotEmpty((String)config.getWrapKeyword()) && SqlReservedWords.containsWord((String)columnName)) {
            columnName = MessageFormat.format(config.getWrapKeyword(), columnName);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.getJavaType().isPrimitive()) {
            this.log.warn("\u901a\u7528 Mapper \u8b66\u544a\u4fe1\u606f: <[" + (Object)((Object)entityColumn) + "]> \u4f7f\u7528\u4e86\u57fa\u672c\u7c7b\u578b\uff0c\u57fa\u672c\u7c7b\u578b\u5728\u52a8\u6001 SQL \u4e2d\u7531\u4e8e\u5b58\u5728\u9ed8\u8ba4\u503c\uff0c\u56e0\u6b64\u4efb\u4f55\u65f6\u5019\u90fd\u4e0d\u7b49\u4e8e null\uff0c\u5efa\u8bae\u4fee\u6539\u57fa\u672c\u7c7b\u578b\u4e3a\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\u578b!");
        }
        this.processOrderBy(entityTable, field, entityColumn);
        this.processKeyGenerator(entityTable, field, entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
        if (entityColumn.isMultiLanguage()) {
            entityTable.getMultiLanguageColumns().add(entityColumn);
        }
        if (!field.isAnnotationPresent(Transient.class)) {
            entityTable.getEntityClassColumns().add(entityColumn);
        }
        if (entityColumn.isSelectable()) {
            entityTable.getAllColumns().add(entityColumn);
        }
    }

    protected void processOrderBy(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        String orderBy = "";
        if (field.isAnnotationPresent(OrderBy.class)) {
            orderBy = ((OrderBy)field.getAnnotation(OrderBy.class)).value();
            if ("".equals(orderBy)) {
                orderBy = "ASC";
            }
            this.log.warn(OrderBy.class + " is outdated, use " + Order.class + " instead!");
        }
        if (field.isAnnotationPresent(Order.class)) {
            Order order = (Order)field.getAnnotation(Order.class);
            orderBy = "".equals(order.value()) && "".equals(orderBy) ? "ASC" : order.value();
            entityColumn.setOrderPriority(order.priority());
        }
        if (StringUtil.isNotEmpty((String)orderBy)) {
            entityColumn.setOrderBy(orderBy);
        }
    }

    protected void processKeyGenerator(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        if (field.isAnnotationPresent(KeySql.class)) {
            this.processKeySql(entityTable, entityColumn, (KeySql)field.getAnnotation(KeySql.class));
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            this.processGeneratedValue(entityTable, entityColumn, (GeneratedValue)field.getAnnotation(GeneratedValue.class));
        }
    }

    protected void processGeneratedValue(EntityTable entityTable, EntityColumn entityColumn, GeneratedValue generatedValue) {
        if ("JDBC".equals(generatedValue.generator())) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
            entityColumn.setIdentity(true);
            if (!"".equals(generatedValue.generator())) {
                String generator = null;
                IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect((String)generatedValue.generator());
                generator = identityDialect != null ? identityDialect.getIdentityRetrievalStatement() : generatedValue.generator();
                entityColumn.setGenerator(generator);
            }
        } else {
            throw new MapperException(entityColumn.getProperty() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n2.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
        }
    }

    protected void processKeySql(EntityTable entityTable, EntityColumn entityColumn, KeySql keySql) {
        if (keySql.useGeneratedKeys()) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (keySql.dialect() == IdentityDialect.DEFAULT) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
        } else if (keySql.dialect() != IdentityDialect.NULL) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
            entityColumn.setGenerator(keySql.dialect().getIdentityRetrievalStatement());
        } else if (StringUtil.isNotEmpty((String)keySql.sql())) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            entityColumn.setGenerator(keySql.sql());
        } else if (keySql.genSql() != GenSql.NULL.class) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            try {
                GenSql genSql = (GenSql)keySql.genSql().newInstance();
                entityColumn.setGenerator(genSql.genSql(entityTable, entityColumn));
            }
            catch (Exception e) {
                this.log.error("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, (Throwable)e);
                throw new MapperException("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, (Throwable)e);
            }
        } else if (keySql.genId() != GenId.NULL.class) {
            entityColumn.setIdentity(false);
            entityColumn.setGenIdClass(keySql.genId());
        } else {
            throw new MapperException(entityTable.getEntityClass().getCanonicalName() + " \u7c7b\u4e2d\u7684 @KeySql \u6ce8\u89e3\u914d\u7f6e\u65e0\u6548!");
        }
    }

    public static String buildJoinKey(JoinTable jt) {
        return jt.target().getCanonicalName() + "." + jt.name();
    }
}

