/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.mapperhelper;

import io.choerodon.mybatis.common.query.Comparison;
import io.choerodon.mybatis.common.query.JoinColumn;
import io.choerodon.mybatis.common.query.JoinOn;
import io.choerodon.mybatis.common.query.JoinTable;
import io.choerodon.mybatis.common.query.Selection;
import io.choerodon.mybatis.common.query.SortField;
import io.choerodon.mybatis.common.query.Where;
import io.choerodon.mybatis.common.query.WhereField;
import io.choerodon.mybatis.entity.BaseDTO;
import io.choerodon.mybatis.entity.Criteria;
import io.choerodon.mybatis.entity.CustomEntityColumn;
import io.choerodon.mybatis.entity.CustomEntityTable;
import io.choerodon.mybatis.mapperhelper.CustomEntityResolve;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Table;
import javax.persistence.criteria.JoinType;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.annotation.Version;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;
import tk.mybatis.mapper.version.VersionException;

public class CustomHelper {
    public static String getAllColumns_TL(Class<?> entityClass) {
        Set columnList = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        for (EntityColumn entityColumn : columnList) {
            if (entityColumn instanceof CustomEntityColumn && ((CustomEntityColumn)entityColumn).isMultiLanguage()) {
                sql.append("t.");
            } else {
                sql.append("b.");
            }
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String updateSetColumnsWithOption(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (column.isId() || !column.isUpdatable() || column.getEntityField().isAnnotationPresent(Version.class)) continue;
            sql.append(CustomHelper.getIfNotNullWithOptions(column, column.getColumnEqualsHolder("dto") + ","));
        }
        sql.append(CustomHelper.updateSetVersion(entityClass, "dto", false));
        sql.append("</set>");
        return sql.toString();
    }

    public static String getIfNotNullWithOptions(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        sql.append("null== criteria || null == criteria.updateFields || criteria.updateFields.isEmpty() || ");
        sql.append("criteria.updateFields").append(".contains('");
        sql.append(column.getProperty()).append("')");
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String selectAllColumns_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(CustomHelper.getAllColumns_TL(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String fromTable_TL(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM ");
        String tableName = entityClass.getAnnotation(Table.class).name();
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.append(tableName).append(" b ");
        if (tableName.toUpperCase().endsWith("_B")) {
            sql.append("LEFT OUTER JOIN ").append(tableName.substring(0, tableName.length() - 2) + "_TL t ");
        } else {
            sql.append("LEFT OUTER JOIN ").append(tableName + "_TL t ");
        }
        sql.append("ON (");
        for (EntityColumn column : entityTable.getEntityClassPKColumns()) {
            sql.append("b.").append(column.getColumn()).append("=t.").append(column.getColumn()).append(" AND ");
        }
        sql.append("t.LANG='${@io.choerodon.mybatis.util.OGNL@language()}') ");
        return sql.toString();
    }

    public static String wherePKColumns(Class<?> entityClass, String entityName, boolean useVersion, boolean useBaseTable) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set columnSet = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            if (useBaseTable) {
                sql.append(" AND b.").append(column.getColumnEqualsHolder(entityName));
                continue;
            }
            sql.append(" AND ").append(column.getColumnEqualsHolder(entityName));
        }
        if (useVersion) {
            sql.append(CustomHelper.whereVersion(entityClass, entityName, useBaseTable));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereVersion(Class<?> entityClass, String entityName, boolean useBaseTable) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        boolean hasVersion = false;
        String result = "";
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (hasVersion) {
                throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasVersion = true;
            if (useBaseTable) {
                result = " AND b." + column.getColumnEqualsHolder(entityName);
                continue;
            }
            result = " AND " + column.getColumnEqualsHolder(entityName);
        }
        return result;
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        boolean hasLogicDelete = false;
        sql.append("<where>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn logicDeleteColumn = SqlHelper.getLogicDeleteColumn(entityClass);
        for (EntityColumn column : columnSet) {
            if (useVersion && column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                hasLogicDelete = true;
                continue;
            }
            Where where = (Where)column.getEntityField().getAnnotation(Where.class);
            if (where != null && where.exclude()) continue;
            String whereSql = null;
            whereSql = where != null ? CustomHelper.getWhereHolder(where, column) : column.getColumnEqualsHolder();
            sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)(" AND " + whereSql), (boolean)empty));
        }
        if (useVersion) {
            sql.append(SqlHelper.whereVersion(entityClass));
        }
        if (hasLogicDelete) {
            sql.append(SqlHelper.whereLogicDelete(entityClass, (boolean)false));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereAllIfColumns_TL(Class<?> entityClass, boolean empty, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        boolean hasLogicDelete = false;
        sql.append("<where>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn logicDeleteColumn = SqlHelper.getLogicDeleteColumn(entityClass);
        for (EntityColumn column : columnSet) {
            if (useVersion && column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                hasLogicDelete = true;
                continue;
            }
            Where where = (Where)column.getEntityField().getAnnotation(Where.class);
            if (where != null && where.exclude()) continue;
            String whereSql = null;
            whereSql = where != null ? CustomHelper.getWhereHolder(where, column) : column.getColumnEqualsHolder();
            if (column instanceof CustomEntityColumn && ((CustomEntityColumn)column).isMultiLanguage()) {
                sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)(" AND t." + whereSql), (boolean)empty));
                continue;
            }
            sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)(" AND b." + whereSql), (boolean)empty));
        }
        if (useVersion) {
            sql.append(SqlHelper.whereVersion(entityClass));
        }
        if (hasLogicDelete) {
            sql.append(SqlHelper.whereLogicDelete(entityClass, (boolean)false));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String getWhereHolder(Where where, EntityColumn column) {
        return column.getColumn() + CustomHelper.formatComparisonSQL(where.comparison().sql(), column.getColumnHolder(), true);
    }

    public static String orderByDefault_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append(" ORDER BY b.");
            sql.append(orderByClause);
        }
        return sql.toString();
    }

    public static String exampleSelectColumns_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@tk.mybatis.mapper.util.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" separator=\",\">");
        sql.append("<choose>");
        sql.append("<when test=\"@io.choerodon.mybatis.util.OGNL@isMultiLanguageColumn(_parameter, selectColumn)\">");
        sql.append("t.${selectColumn}");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append("b.${selectColumn}");
        sql.append("</otherwise>");
        sql.append("</choose>");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(CustomHelper.getAllColumns_TL(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String exampleOrderBy_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"orderByClause != null\">");
        sql.append("order by b.${orderByClause}");
        sql.append("</if>");
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append("<if test=\"orderByClause == null\">");
            sql.append("ORDER BY b.");
            sql.append(orderByClause);
            sql.append("</if>");
        }
        return sql.toString();
    }

    public static String updateSetVersion(Class<?> entityClass, String entityName, boolean useBaseTable) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        boolean hasVersion = false;
        StringBuilder result = new StringBuilder();
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (hasVersion) {
                throw new VersionException(entityClass.getCanonicalName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasVersion = true;
            Version version = (Version)column.getEntityField().getAnnotation(Version.class);
            String versionClass = version.nextVersion().getCanonicalName();
            result.append("<bind name=\"").append(column.getProperty()).append("Version\" value=\"");
            result.append("@tk.mybatis.mapper.version.VersionUtil@nextVersion(").append("@").append(versionClass).append("@class, ");
            if (StringUtil.isNotEmpty((String)entityName)) {
                result.append(entityName).append(".");
            }
            result.append(column.getProperty()).append(")\"/>");
            result.append(column.getColumn()).append(" = #{").append(column.getProperty()).append("Version},");
        }
        return result.toString();
    }

    public static String buildSelectByPrimaryKeySQL(BaseDTO dto) {
        EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        Criteria criteria = new Criteria();
        for (EntityColumn pkColumn : table.getEntityClassPKColumns()) {
            criteria.where(pkColumn.getProperty());
        }
        return CustomHelper.buildSelectSelectiveSql(dto, criteria);
    }

    public static String buildSelectSelectiveSql(final BaseDTO dto, final Criteria criteria) {
        final CustomEntityTable table = (CustomEntityTable)EntityHelper.getEntityTable(dto.getClass());
        final ArrayList<Selection> selectFields = new ArrayList<Selection>(50);
        List<Selection> selections = criteria.getSelectFields();
        if (selections == null || selections.isEmpty()) {
            for (EntityColumn entityColumn : table.getAllColumns()) {
                if (criteria.getExcludeSelectFields() != null && criteria.getExcludeSelectFields().contains(entityColumn.getProperty())) continue;
                selectFields.add(new Selection(entityColumn.getProperty()));
            }
        } else {
            for (Selection selection : selections) {
                if (criteria.getExcludeSelectFields() != null && criteria.getExcludeSelectFields().contains(selection.getField())) continue;
                selectFields.add(selection);
            }
        }
        String sql = ((StringBuilder)new SQL(){
            {
                List<SortField> list2;
                for (Selection selection : selectFields) {
                    String selectionSql = CustomHelper.generateSelectionSQL(dto, selection);
                    if (StringUtils.isEmpty((Object)selectionSql)) continue;
                    this.SELECT(selectionSql);
                }
                this.FROM(table.getName() + " " + table.getAlias());
                for (Map.Entry entry : table.getJoinMapping().entrySet()) {
                    JoinTable jt;
                    CustomEntityColumn column = (CustomEntityColumn)((Object)entry.getValue());
                    String joinSql = CustomHelper.generateJoinSQL(dto, column, jt = column.findJoinTableByName((String)entry.getKey()), selectFields);
                    if (StringUtils.isEmpty((Object)joinSql)) continue;
                    JoinType joinType = jt.type();
                    switch (joinType) {
                        case LEFT: {
                            this.LEFT_OUTER_JOIN(joinSql);
                            break;
                        }
                        case INNER: {
                            this.INNER_JOIN(joinSql);
                            break;
                        }
                        case RIGHT: {
                            this.RIGHT_OUTER_JOIN(joinSql);
                        }
                    }
                }
                String whereSql = CustomHelper.generateWhereClauseSQL(dto, criteria);
                if (!StringUtils.isEmpty((Object)whereSql)) {
                    this.WHERE(whereSql);
                }
                if ((list2 = criteria.getSortFields()) != null && !list2.isEmpty()) {
                    block7: for (SortField sortField : list2) {
                        for (EntityColumn sortColumn : table.getEntityClassColumns()) {
                            if (!sortColumn.getProperty().equals(sortField.getField())) continue;
                            this.ORDER_BY(CustomHelper.findColumnNameByField(dto, sortField.getField(), false) + sortField.getSortType().sql());
                            continue block7;
                        }
                    }
                } else {
                    for (EntityColumn sortColumn : table.getEntityClassColumns()) {
                        if (sortColumn.getOrderBy() == null) continue;
                        this.ORDER_BY(CustomHelper.findColumnNameByField(dto, (CustomEntityColumn)sortColumn, false) + " " + sortColumn.getOrderBy());
                    }
                }
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
        return sql;
    }

    private static String generateSelectionSQL(BaseDTO dto, Selection selection) {
        return CustomHelper.findColumnNameByField(dto, selection.getField(), true);
    }

    private static String findColumnNameByField(BaseDTO dto, String field, boolean withAlias) {
        CustomEntityTable table = (CustomEntityTable)EntityHelper.getEntityTable(dto.getClass());
        CustomEntityColumn entityColumn = table.findColumnByProperty(field);
        return CustomHelper.findColumnNameByField(dto, entityColumn, withAlias);
    }

    private static String findColumnNameByField(BaseDTO dto, CustomEntityColumn entityColumn, boolean withAlias) {
        CustomEntityTable table = (CustomEntityTable)EntityHelper.getEntityTable(dto.getClass());
        StringBuilder sb = new StringBuilder();
        if (entityColumn != null) {
            JoinColumn jc = entityColumn.getJoinColumn();
            if (jc != null) {
                CustomEntityColumn joinField = table.getJoinMapping().get(jc.joinName());
                JoinTable joinTable = joinField.findJoinTableByName(jc.joinName());
                if (joinField != null && joinTable != null) {
                    CustomEntityTable joinEntityTable = (CustomEntityTable)EntityHelper.getEntityTable(joinTable.target());
                    CustomEntityColumn refColumn = joinEntityTable.findColumnByProperty(jc.field());
                    sb.append(table.getAlias(CustomEntityResolve.buildJoinKey(joinTable))).append(".").append(refColumn.getColumn());
                    if (withAlias) {
                        sb.append(" AS ").append(entityColumn.getColumn());
                    }
                }
            } else {
                sb.append(table.getAlias()).append(".").append(entityColumn.getColumn());
            }
        }
        return sb.toString();
    }

    private static String generateJoinSQL(BaseDTO dto, EntityColumn localColumn, JoinTable joinTable, List<Selection> selections) {
        StringBuilder sb = new StringBuilder();
        CustomEntityTable localTable = (CustomEntityTable)EntityHelper.getEntityTable(dto.getClass());
        String joinKey = CustomEntityResolve.buildJoinKey(joinTable);
        CustomEntityTable foreignTable = (CustomEntityTable)EntityHelper.getEntityTable(joinTable.target());
        boolean foundJoinColumn = false;
        for (Selection selection : selections) {
            CustomEntityColumn entityColumn = localTable.findColumnByProperty(selection.getField());
            if (entityColumn == null || entityColumn.getJoinColumn() == null || !joinTable.name().equals(entityColumn.getJoinColumn().joinName())) continue;
            foundJoinColumn = true;
            break;
        }
        if (foundJoinColumn) {
            String jointTableName = foreignTable.getName();
            if (joinTable.joinMultiLanguageTable()) {
                jointTableName = jointTableName.toUpperCase().endsWith("_B") ? jointTableName.substring(0, jointTableName.length() - 2) + "_TL" : jointTableName + "_TL";
            }
            sb.append(jointTableName).append(" ").append(localTable.getAlias(joinKey)).append(" ON ");
            JoinOn[] joinOns = joinTable.on();
            int j = joinOns.length;
            for (int i = 0; i < j; ++i) {
                CustomEntityColumn foreignColumn;
                String columnName;
                JoinOn joinOn = joinOns[i];
                String joinField = joinOn.joinField();
                if (StringUtils.isEmpty((Object)joinField)) continue;
                if (i != 0) {
                    sb.append(" AND ");
                }
                String string = columnName = (foreignColumn = foreignTable.findColumnByProperty(joinField)) != null ? foreignColumn.getColumn() : StringUtil.camelhumpToUnderline((String)joinField);
                if (StringUtils.isEmpty((Object)joinOn.joinExpression())) {
                    sb.append(localTable.getAlias()).append(".").append(localColumn.getColumn()).append(" = ");
                    sb.append(localTable.getAlias(joinKey)).append(".").append(columnName);
                    continue;
                }
                sb.append(localTable.getAlias(joinKey)).append(".").append(columnName);
                sb.append(" = ").append(joinOn.joinExpression());
            }
        }
        return sb.toString();
    }

    private static String generateWhereClauseSQL(BaseDTO dto, Criteria criteria) {
        StringBuilder sb = new StringBuilder();
        List<WhereField> whereFields = criteria.getWhereFields();
        CustomEntityTable table = (CustomEntityTable)EntityHelper.getEntityTable(dto.getClass());
        for (EntityColumn column : table.getEntityClassColumns()) {
            try {
                Where where;
                CustomEntityColumn hapEntityColumn = (CustomEntityColumn)column;
                if (column.getEntityField().getValue((Object)dto) == null || (where = hapEntityColumn.getWhere()) == null) continue;
                Comparison comparison = where.comparison();
                boolean isWhereField = false;
                if (whereFields != null && !whereFields.isEmpty()) {
                    for (WhereField whereField : whereFields) {
                        String f = whereField.getField();
                        if (f == null || !f.equals(column.getProperty())) continue;
                        isWhereField = true;
                        if (whereField.getComparison() == null) break;
                        comparison = whereField.getComparison();
                        break;
                    }
                    if (!isWhereField) continue;
                }
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                String columnName = column.getColumn();
                JoinColumn jc = hapEntityColumn.getJoinColumn();
                if (jc != null) {
                    CustomEntityColumn joinField = table.getJoinMapping().get(jc.joinName());
                    JoinTable jt = joinField.findJoinTableByName(jc.joinName());
                    CustomEntityTable foreignTable = (CustomEntityTable)EntityHelper.getEntityTable(jt.target());
                    CustomEntityColumn foreignColumn = foreignTable.findColumnByProperty(jc.field());
                    columnName = foreignColumn.getColumn();
                    sb.append(table.getAlias(CustomEntityResolve.buildJoinKey(jt))).append(".");
                } else {
                    sb.append(table.getAlias()).append(".");
                }
                sb.append(columnName).append(CustomHelper.formatComparisonSQL(comparison.sql(), column.getColumnHolder("dto"), false));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private static String formatComparisonSQL(String format, String placeHolder, boolean replace) {
        String result = null;
        if (format.contains("{0}")) {
            MessageFormat mf = new MessageFormat(format);
            result = mf.format(new String[]{placeHolder});
        } else {
            result = format + placeHolder;
        }
        if (replace) {
            return result.replace("<", "&lt;").replace(">", "&gt;");
        }
        return result;
    }
}

