/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.mybatis.provider;

import io.choerodon.mybatis.entity.CustomEntityTable;
import io.choerodon.mybatis.mapperhelper.CustomHelper;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.provider.base.BaseSelectProvider;

public class MultiLanguageSelectProvider
extends BaseSelectProvider {
    public MultiLanguageSelectProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String selectOne(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        EntityTable entityTable = EntityHelper.getEntityTable((Class)entityClass);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (entityTable instanceof CustomEntityTable && ((CustomEntityTable)entityTable).isMultiLanguage()) {
            sql.append(CustomHelper.selectAllColumns_TL(entityClass));
            sql.append(CustomHelper.fromTable_TL(entityClass, this.tableName(entityClass)));
            sql.append(CustomHelper.whereAllIfColumns_TL(entityClass, this.isNotEmpty(), false));
            return sql.toString();
        }
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(CustomHelper.whereAllIfColumns(entityClass, this.isNotEmpty(), false));
        return sql.toString();
    }

    public String select(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        EntityTable entityTable = EntityHelper.getEntityTable((Class)entityClass);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        if (entityTable instanceof CustomEntityTable && ((CustomEntityTable)entityTable).isMultiLanguage()) {
            sql.append(CustomHelper.selectAllColumns_TL(entityClass));
            sql.append(CustomHelper.fromTable_TL(entityClass, this.tableName(entityClass)));
            sql.append(CustomHelper.whereAllIfColumns_TL(entityClass, this.isNotEmpty(), false));
            sql.append(CustomHelper.orderByDefault_TL(entityClass));
            return sql.toString();
        }
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(CustomHelper.whereAllIfColumns(entityClass, this.isNotEmpty(), false));
        sql.append(SqlHelper.orderByDefault((Class)entityClass));
        return sql.toString();
    }

    public String selectByPrimaryKey(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        EntityTable entityTable = EntityHelper.getEntityTable((Class)entityClass);
        if (entityTable instanceof CustomEntityTable && ((CustomEntityTable)entityTable).isMultiLanguage()) {
            this.setResultType(ms, entityClass);
            StringBuilder sql = new StringBuilder();
            sql.append(CustomHelper.selectAllColumns_TL(entityClass));
            sql.append(CustomHelper.fromTable_TL(entityClass, this.tableName(entityClass)));
            sql.append(CustomHelper.wherePKColumns(entityClass, null, false, true));
            return sql.toString();
        }
        return super.selectByPrimaryKey(ms);
    }

    public String selectAll(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        EntityTable entityTable = EntityHelper.getEntityTable((Class)entityClass);
        if (entityTable instanceof CustomEntityTable && ((CustomEntityTable)entityTable).isMultiLanguage()) {
            this.setResultType(ms, entityClass);
            StringBuilder sql = new StringBuilder();
            sql.append(CustomHelper.selectAllColumns_TL(entityClass));
            sql.append(CustomHelper.fromTable_TL(entityClass, this.tableName(entityClass)));
            sql.append(CustomHelper.orderByDefault_TL(entityClass));
            return sql.toString();
        }
        return super.selectAll(ms);
    }

    public String selectAllWithoutMultiLanguage(MappedStatement ms) {
        return super.selectAll(ms);
    }

    public String selectByExample(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        EntityTable entityTable = EntityHelper.getEntityTable((Class)entityClass);
        if (entityTable instanceof CustomEntityTable && ((CustomEntityTable)entityTable).isMultiLanguage()) {
            this.setResultType(ms, entityClass);
            StringBuilder sql = new StringBuilder("SELECT ");
            if (this.isCheckExampleEntityClass()) {
                sql.append(SqlHelper.exampleCheck((Class)entityClass));
            }
            sql.append("<if test=\"distinct\">distinct</if>");
            sql.append(CustomHelper.exampleSelectColumns_TL(entityClass));
            sql.append(CustomHelper.fromTable_TL(entityClass, this.tableName(entityClass)));
            sql.append(SqlHelper.exampleWhereClause());
            sql.append(CustomHelper.exampleOrderBy_TL(entityClass));
            sql.append(SqlHelper.exampleForUpdate());
            return sql.toString();
        }
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.isCheckExampleEntityClass()) {
            sql.append(SqlHelper.exampleCheck((Class)entityClass));
        }
        sql.append("<if test=\"distinct\">distinct</if>");
        sql.append(SqlHelper.exampleSelectColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.exampleWhereClause());
        sql.append(SqlHelper.exampleOrderBy((Class)entityClass));
        sql.append(SqlHelper.exampleForUpdate());
        return sql.toString();
    }
}

