/*
 * Decompiled with CFR 0.152.
 */
package io.chrisdavenport.rediculous;

import cats.Applicative$;
import cats.ApplicativeError;
import cats.Foldable;
import cats.Functor$;
import cats.MonadError;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.package$;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.Semaphore$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.LeftOps$;
import cats.syntax.OptionIdOps$;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters;
import io.chrisdavenport.rediculous.Redis;
import io.chrisdavenport.rediculous.RedisConnection$;
import io.chrisdavenport.rediculous.RedisConnection$Cluster$;
import io.chrisdavenport.rediculous.RedisConnection$ClusterConnectionBuilder$;
import io.chrisdavenport.rediculous.RedisConnection$DirectConnection$;
import io.chrisdavenport.rediculous.RedisConnection$PooledConnection$;
import io.chrisdavenport.rediculous.RedisConnection$Queued$;
import io.chrisdavenport.rediculous.RedisCtx$;
import io.chrisdavenport.rediculous.RedisResult;
import io.chrisdavenport.rediculous.Resp;
import io.chrisdavenport.rediculous.Resp$;
import io.chrisdavenport.rediculous.Resp$Error$;
import io.chrisdavenport.rediculous.cluster.ClusterCommands;
import io.chrisdavenport.rediculous.cluster.ClusterCommands$;
import io.chrisdavenport.rediculous.cluster.HashSlot$;
import java.io.Serializable;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.KeyPool$;
import org.typelevel.keypool.KeyPoolBuilder$;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Managed$;
import org.typelevel.keypool.Reusable;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public interface RedisConnection<F> {
    public static <F, A> Object closeReturn(Either<Resp, A> either, MonadError<F, Throwable> monadError) {
        return RedisConnection$.MODULE$.closeReturn(either, monadError);
    }

    public static <F> ClusterConnectionBuilder<F> cluster(Async<F> async) {
        return RedisConnection$.MODULE$.cluster(async);
    }

    public static <F> DirectConnectionBuilder<F> direct(Async<F> async) {
        return RedisConnection$.MODULE$.direct(async);
    }

    public static <F> Object explicitPipelineRequest(Socket<F> socket, Chunk<Resp> chunk, int n, Option<FiniteDuration> option, GenConcurrent<F, Throwable> genConcurrent) {
        return RedisConnection$.MODULE$.explicitPipelineRequest(socket, chunk, n, option, genConcurrent);
    }

    public static <F> Object head(Chunk<Resp> chunk, ApplicativeError<F, Throwable> applicativeError) {
        return RedisConnection$.MODULE$.head(chunk, applicativeError);
    }

    public static int ordinal(RedisConnection redisConnection) {
        return RedisConnection$.MODULE$.ordinal(redisConnection);
    }

    public static <F> PooledConnectionBuilder<F> pool(Async<F> async) {
        return RedisConnection$.MODULE$.pool(async);
    }

    public static <F> QueuedConnectionBuilder<F> queued(Async<F> async) {
        return RedisConnection$.MODULE$.queued(async);
    }

    public static <F, A> Object runRequest(RedisConnection<F> redisConnection, NonEmptyList<ByteVector> nonEmptyList, Option<ByteVector> option, GenConcurrent<F, Throwable> genConcurrent, RedisResult<A> redisResult) {
        return RedisConnection$.MODULE$.runRequest(redisConnection, nonEmptyList, option, genConcurrent, redisResult);
    }

    public static <F> Object runRequestInternal(RedisConnection<F> redisConnection, Chunk<NonEmptyList<ByteVector>> chunk, Option<ByteVector> option, GenConcurrent<F, Throwable> genConcurrent) {
        return RedisConnection$.MODULE$.runRequestInternal(redisConnection, chunk, option, genConcurrent);
    }

    public static <F, A> Redis<F, A> runRequestTotal(NonEmptyList<ByteVector> nonEmptyList, Option<ByteVector> option, GenConcurrent<F, Throwable> genConcurrent, RedisResult<A> redisResult) {
        return RedisConnection$.MODULE$.runRequestTotal(nonEmptyList, option, genConcurrent, redisResult);
    }

    public static <F> Object toNel(Chunk<Resp> chunk, ApplicativeError<F, Throwable> applicativeError) {
        return RedisConnection$.MODULE$.toNel(chunk, applicativeError);
    }

    public static <F> int explicitPipelineRequest$default$3() {
        return RedisConnection$.MODULE$.explicitPipelineRequest$default$3();
    }

    public static <F> Option<FiniteDuration> explicitPipelineRequest$default$4() {
        return RedisConnection$.MODULE$.explicitPipelineRequest$default$4();
    }

    public static class Cluster<F>
    implements RedisConnection<F>,
    Product,
    Serializable {
        private final Queue queue;
        private final Object slots;
        private final Function2 usePool;

        public static <F> Cluster<F> apply(Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, Object>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue, Object object, Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> function2) {
            return RedisConnection$Cluster$.MODULE$.apply(queue, object, function2);
        }

        public static Cluster fromProduct(Product product) {
            return RedisConnection$Cluster$.MODULE$.fromProduct(product);
        }

        public static <F> Cluster<F> unapply(Cluster<F> cluster) {
            return RedisConnection$Cluster$.MODULE$.unapply(cluster);
        }

        public Cluster(Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, Object>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue, Object slots, Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> usePool) {
            this.queue = queue;
            this.slots = slots;
            this.usePool = usePool;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cluster)) return false;
            Cluster cluster = (Cluster)object;
            Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, F>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue = this.queue();
            Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, F>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue2 = cluster.queue();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            if (!BoxesRunTime.equals(this.slots(), cluster.slots())) return false;
            Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> function2 = this.usePool();
            Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> function22 = cluster.usePool();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            if (!cluster.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cluster;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Cluster";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "queue";
                    break;
                }
                case 1: {
                    string = "slots";
                    break;
                }
                case 2: {
                    string = "usePool";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, F>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue() {
            return this.queue;
        }

        public F slots() {
            return (F)this.slots;
        }

        public Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> usePool() {
            return this.usePool;
        }

        public <F> Cluster<F> copy(Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, Object>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> queue, Object slots, Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> usePool) {
            return new Cluster<F>(queue, slots, usePool);
        }

        public <F> Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, F>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> copy$default$1() {
            return this.queue();
        }

        public <F> F copy$default$2() {
            return this.slots();
        }

        public <F> Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> copy$default$3() {
            return this.usePool();
        }

        public Queue<F, Chunk<Tuple5<Function1<Either<Throwable, Resp>, F>, Option<ByteVector>, Option<Tuple2<Host, Port>>, Object, Resp>>> _1() {
            return this.queue();
        }

        public F _2() {
            return this.slots();
        }

        public Function2<Host, Port, Resource<F, Managed<F, Socket<F>>>> _3() {
            return this.usePool();
        }
    }

    public static class ClusterConnectionBuilder<F> {
        private final SocketGroup sg;
        private final Host host;
        private final Port port;
        private final Option tlsContext;
        private final TLSParameters tlsParameters;
        private final int maxQueued;
        private final int workers;
        private final int chunkSizeLimit;
        private final int parallelServerCalls;
        private final boolean useDynamicRefreshSource;
        private final FiniteDuration cacheTopologySeconds;
        private final Async<F> evidence$17;

        public static <F> int $lessinit$greater$default$9() {
            return RedisConnection$ClusterConnectionBuilder$.MODULE$.$lessinit$greater$default$9();
        }

        public static <F> boolean $lessinit$greater$default$10() {
            return RedisConnection$ClusterConnectionBuilder$.MODULE$.$lessinit$greater$default$10();
        }

        public static <F> FiniteDuration $lessinit$greater$default$11() {
            return RedisConnection$ClusterConnectionBuilder$.MODULE$.$lessinit$greater$default$11();
        }

        public ClusterConnectionBuilder(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, int maxQueued, int workers, int chunkSizeLimit, int parallelServerCalls, boolean useDynamicRefreshSource, FiniteDuration cacheTopologySeconds, Async<F> evidence$17) {
            this.sg = sg;
            this.host = host;
            this.port = port;
            this.tlsContext = tlsContext;
            this.tlsParameters = tlsParameters;
            this.maxQueued = maxQueued;
            this.workers = workers;
            this.chunkSizeLimit = chunkSizeLimit;
            this.parallelServerCalls = parallelServerCalls;
            this.useDynamicRefreshSource = useDynamicRefreshSource;
            this.cacheTopologySeconds = cacheTopologySeconds;
            this.evidence$17 = evidence$17;
        }

        private SocketGroup<F> sg() {
            return this.sg;
        }

        private Host host() {
            return this.host;
        }

        private Port port() {
            return this.port;
        }

        private Option<TLSContext<F>> tlsContext() {
            return this.tlsContext;
        }

        private TLSParameters tlsParameters() {
            return this.tlsParameters;
        }

        private int maxQueued() {
            return this.maxQueued;
        }

        private int workers() {
            return this.workers;
        }

        private int chunkSizeLimit() {
            return this.chunkSizeLimit;
        }

        private int parallelServerCalls() {
            return this.parallelServerCalls;
        }

        private boolean useDynamicRefreshSource() {
            return this.useDynamicRefreshSource;
        }

        private FiniteDuration cacheTopologySeconds() {
            return this.cacheTopologySeconds;
        }

        private ClusterConnectionBuilder<F> copy(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, int maxQueued, int workers, int chunkSizeLimit, int parallelServerCalls, boolean useDynamicRefreshSource, FiniteDuration cacheTopologySeconds) {
            return new ClusterConnectionBuilder<F>(sg, host, port, tlsContext, tlsParameters, maxQueued, workers, chunkSizeLimit, parallelServerCalls, useDynamicRefreshSource, cacheTopologySeconds, this.evidence$17);
        }

        private SocketGroup<F> copy$default$1() {
            return this.sg();
        }

        private Host copy$default$2() {
            return this.host();
        }

        private Port copy$default$3() {
            return this.port();
        }

        private Option<TLSContext<F>> copy$default$4() {
            return this.tlsContext();
        }

        private TLSParameters copy$default$5() {
            return this.tlsParameters();
        }

        private int copy$default$6() {
            return this.maxQueued();
        }

        private int copy$default$7() {
            return this.workers();
        }

        private int copy$default$8() {
            return this.chunkSizeLimit();
        }

        private int copy$default$9() {
            return this.parallelServerCalls();
        }

        private boolean copy$default$10() {
            return this.useDynamicRefreshSource();
        }

        private FiniteDuration copy$default$11() {
            return this.cacheTopologySeconds();
        }

        public ClusterConnectionBuilder<F> withHost(Host host) {
            return this.copy(this.copy$default$1(), host, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withPort(Port port) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), port, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withTLSContext(TLSContext<F> tlsContext) {
            TLSContext tLSContext = (TLSContext)cats.implicits$.MODULE$.catsSyntaxOptionId(tlsContext);
            Option option = OptionIdOps$.MODULE$.some$extension((Object)tLSContext);
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            int n = this.copy$default$6();
            int n2 = this.copy$default$7();
            int n3 = this.copy$default$8();
            int n4 = this.copy$default$9();
            boolean bl = this.copy$default$10();
            FiniteDuration finiteDuration = this.copy$default$11();
            return this.copy(socketGroup, host, port, option, tLSParameters, n, n2, n3, n4, bl, finiteDuration);
        }

        public ClusterConnectionBuilder<F> withoutTLSContext() {
            None$ none$ = None$.MODULE$;
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            int n = this.copy$default$6();
            int n2 = this.copy$default$7();
            int n3 = this.copy$default$8();
            int n4 = this.copy$default$9();
            boolean bl = this.copy$default$10();
            FiniteDuration finiteDuration = this.copy$default$11();
            return this.copy(socketGroup, host, port, (Option<TLSContext<F>>)none$, tLSParameters, n, n2, n3, n4, bl, finiteDuration);
        }

        public ClusterConnectionBuilder<F> withTLSParameters(TLSParameters tlsParameters) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), tlsParameters, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withSocketGroup(SocketGroup<F> sg) {
            return this.copy(sg, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withMaxQueued(int maxQueued) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), maxQueued, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withWorkers(int workers) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), workers, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withChunkSizeLimit(int chunkSizeLimit) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), chunkSizeLimit, this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withParallelServerCalls(int parallelServerCalls) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), parallelServerCalls, this.copy$default$10(), this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withUseDynamicRefreshSource(boolean useDynamicRefreshSource) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), useDynamicRefreshSource, this.copy$default$11());
        }

        public ClusterConnectionBuilder<F> withCacheTopologySeconds(FiniteDuration cacheTopologySeconds) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), cacheTopologySeconds);
        }

        public Resource<F, RedisConnection<F>> build() {
            return KeyPoolBuilder$.MODULE$.apply((Function1 & Serializable)t -> this.sg().client(SocketAddress$.MODULE$.apply(this.host(), this.port()), (List)scala.package$.MODULE$.Nil()).flatMap((Function1 & Serializable)_$39 -> RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$elevateSocket(_$39, this.tlsContext(), this.tlsParameters())).allocated(this.evidence$17), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object shutdown = tuple2._2();
                return shutdown;
            }, this.evidence$17).build().flatMap((Function1 & Serializable)keypool -> package$.MODULE$.Resource().eval(keypool.take((Object)Tuple2$.MODULE$.apply((Object)this.host(), (Object)this.port())).map((Function1 & Serializable)_$40 -> (Socket)((Tuple2)_$40.value())._1()).map((Function1 & Serializable)_$41 -> RedisConnection$DirectConnection$.MODULE$.apply(_$41)).use((Function1 & Serializable)_$43 -> ((Redis)ClusterCommands$.MODULE$.clusterslots(RedisCtx$.MODULE$.redis(this.evidence$17))).run(_$43, this.evidence$17), this.evidence$17)).flatMap((Function1 & Serializable)sockets -> package$.MODULE$.Resource().eval(cats.implicits$.MODULE$.toFunctorOps(package$.MODULE$.Temporal().apply(this.evidence$17, DummyImplicit$.MODULE$.dummyImplicit()).realTime(), this.evidence$17).map((Function1 & Serializable)_$44 -> _$44.toMillis())).flatMap((Function1 & Serializable)now -> this.build$$anonfun$17$$anonfun$13$$anonfun$10((KeyPool)keypool, (ClusterCommands.ClusterSlots)sockets, BoxesRunTime.unboxToLong((Object)now)))));
        }

        private final /* synthetic */ Object $anonfun$10$$anonfun$6$$anonfun$2$$anonfun$2(Ref refTopology$4, ClusterCommands.ClusterSlots s$1, long now) {
            return refTopology$4.set((Object)Tuple2$.MODULE$.apply((Object)s$1, (Object)BoxesRunTime.boxToLong((long)now)));
        }

        private final Option $anonfun$20$$anonfun$2$$anonfun$2$$anonfun$2(ClusterCommands.ClusterSlots topo$2, Option s$2) {
            return s$2.flatMap((Function1 & Serializable)key -> topo$2.served(HashSlot$.MODULE$.find((ByteVector)key, HashSlot$.MODULE$.find$default$2((ByteVector)key))));
        }

        private final Tuple2 $anonfun$21$$anonfun$3$$anonfun$3$$anonfun$3(Tuple2 default$2) {
            return default$2;
        }

        private final Object $anonfun$27$$anonfun$8$$anonfun$8$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1() {
            return Applicative$.MODULE$.apply(this.evidence$17).unit();
        }

        private final Object $anonfun$28$$anonfun$9$$anonfun$9$$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2(Function1 toSet$2, Resp.Error e$3) {
            return cats.implicits$.MODULE$.toFunctorOps(toSet$2.apply((Object)EitherObjectOps$.MODULE$.right$extension(cats.implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)e$3)), this.evidence$17).void();
        }

        private final Object $anonfun$29$$anonfun$10$$anonfun$10$$anonfun$6$$anonfun$3$$anonfun$3(Cluster cluster$7, Function1 toSet$1, Option key$4, int retries$1, Resp initialCommand$1, String s$3, Resp.Error e$2) {
            Object object = cats.implicits$.MODULE$.catsSyntaxIfM(cluster$7.queue().tryOffer((Object)Chunk$.MODULE$.singleton((Object)Tuple5$.MODULE$.apply((Object)toSet$1, (Object)key$4, RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$extractServer(s$3), (Object)BoxesRunTime.boxToInteger((int)(retries$1 + 1)), (Object)initialCommand$1))), this.evidence$17);
            return IfMOps$.MODULE$.ifM$extension(object, this::$anonfun$27$$anonfun$8$$anonfun$8$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1, () -> this.$anonfun$28$$anonfun$9$$anonfun$9$$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2(toSet$1, e$2), this.evidence$17);
        }

        private final Object $anonfun$33$$anonfun$11$$anonfun$11$$anonfun$7$$anonfun$4$$anonfun$4() {
            return Applicative$.MODULE$.apply(this.evidence$17).unit();
        }

        private final Object $anonfun$34$$anonfun$12$$anonfun$12$$anonfun$8$$anonfun$5$$anonfun$5(Function1 toSet$3, Resp.Error e$4) {
            return toSet$3.apply((Object)EitherObjectOps$.MODULE$.right$extension(cats.implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)e$4));
        }

        private final Object $anonfun$37$$anonfun$15$$anonfun$15$$anonfun$11$$anonfun$8(List rest$4, Left e$5) {
            return cats.implicits$.MODULE$.toFoldableOps((Object)rest$4, (Foldable)cats.implicits$.MODULE$.catsStdInstancesForList()).traverse_((Function1 & Serializable)x$1 -> {
                Tuple5 tuple5 = x$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                Function1 deff = (Function1)tuple5._1();
                return deff.apply((Object)((Either)e$5));
            }, this.evidence$17);
        }

        private final Stream build$$anonfun$11$$anonfun$7$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1() {
            return Stream$.MODULE$.exec(package$.MODULE$.Concurrent().apply(this.evidence$17, DummyImplicit$.MODULE$.dummyImplicit()).cede());
        }

        private final /* synthetic */ Resource build$$anonfun$17$$anonfun$13$$anonfun$10(KeyPool keypool$3, ClusterCommands.ClusterSlots sockets$1, long now) {
            return package$.MODULE$.Resource().eval(Semaphore$.MODULE$.apply(1L, this.evidence$17)).flatMap((Function1 & Serializable)refreshLock -> {
                Ref.Make make = package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance(this.evidence$17));
                return package$.MODULE$.Resource().eval(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)Tuple2$.MODULE$.apply((Object)sockets$1, (Object)BoxesRunTime.boxToLong((long)now)))).map((Function1 & Serializable)refTopology -> {
                    Object refreshTopology = refreshLock.permit().use((Function1 & Serializable)_$45 -> cats.implicits$.MODULE$.toFlatMapOps(cats.implicits$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(cats.implicits$.MODULE$.toFlatMapOps(refTopology.get(), this.evidence$17).flatMap((Function1 & Serializable)x$1 -> {
                        long setAt;
                        ClusterCommands.ClusterSlots topo;
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            topo = (ClusterCommands.ClusterSlots)tuple2._1();
                            setAt = BoxesRunTime.unboxToLong((Object)tuple2._2());
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        return this.useDynamicRefreshSource() ? Applicative$.MODULE$.apply(this.evidence$17).pure((Object)Tuple2$.MODULE$.apply((Object)NonEmptyList$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.host(), (Object)this.port()), topo.l().flatMap((Function1 & Serializable)c -> c.replicas()).map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply((Object)r.host(), (Object)r.port()))), (Object)BoxesRunTime.boxToLong((long)setAt))) : Applicative$.MODULE$.apply(this.evidence$17).pure((Object)Tuple2$.MODULE$.apply((Object)NonEmptyList$.MODULE$.of((Object)Tuple2$.MODULE$.apply((Object)this.host(), (Object)this.port()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Object)BoxesRunTime.boxToLong((long)setAt)));
                    }), cats.implicits$.MODULE$.toFunctorOps(package$.MODULE$.Temporal().apply(this.evidence$17, DummyImplicit$.MODULE$.dummyImplicit()).realTime(), this.evidence$17).map((Function1 & Serializable)_$46 -> _$46.toMillis()))).tupled(this.evidence$17, this.evidence$17), this.evidence$17).flatMap((Function1 & Serializable)x$12 -> {
                        Object object;
                        Tuple2 tuple2;
                        Tuple2 tuple22 = x$12;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                            long now;
                            long setAt = BoxesRunTime.unboxToLong((Object)tuple2._2());
                            if (setAt >= (now = BoxesRunTime.unboxToLong((Object)tuple22._2())) - this.cacheTopologySeconds().toMillis()) {
                                object = Applicative$.MODULE$.apply(this.evidence$17).unit();
                            } else {
                                NonEmptyList l = (NonEmptyList)tuple2._1();
                                NonEmptyList nelActions = l.map((Function1 & Serializable)x$1 -> {
                                    Tuple2 tuple2 = x$1;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    Host host = (Host)tuple2._1();
                                    Port port = (Port)tuple2._2();
                                    return keypool$3.take((Object)Tuple2$.MODULE$.apply((Object)host, (Object)port)).map((Function1 & Serializable)_$47 -> (Socket)((Tuple2)_$47.value())._1()).map((Function1 & Serializable)_$48 -> RedisConnection$DirectConnection$.MODULE$.apply(_$48)).use((Function1 & Serializable)_$50 -> ((Redis)ClusterCommands$.MODULE$.clusterslots(RedisCtx$.MODULE$.redis(this.evidence$17))).run(_$50, this.evidence$17), this.evidence$17);
                                });
                                object = cats.implicits$.MODULE$.toFlatMapOps(RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$raceNThrowFirst((NonEmptyList<Object>)nelActions, this.evidence$17), this.evidence$17).flatMap((Function1 & Serializable)s -> cats.implicits$.MODULE$.toFlatMapOps(cats.implicits$.MODULE$.toFunctorOps(package$.MODULE$.Clock().apply(this.evidence$17).realTime(), this.evidence$17).map((Function1 & Serializable)_$51 -> _$51.toMillis()), this.evidence$17).flatMap((Function1 & Serializable)now -> this.$anonfun$10$$anonfun$6$$anonfun$2$$anonfun$2((Ref)refTopology, (ClusterCommands.ClusterSlots)s, BoxesRunTime.unboxToLong((Object)now))));
                            }
                        } else {
                            throw new MatchError((Object)tuple22);
                        }
                        return object;
                    }), this.evidence$17);
                    return Tuple2$.MODULE$.apply(refTopology, refreshTopology);
                }).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Ref refTopology = (Ref)tuple2._1();
                    Object refreshTopology = tuple2._2();
                    return package$.MODULE$.Resource().eval(Queue$.MODULE$.bounded(this.maxQueued(), this.evidence$17)).map((Function1 & Serializable)queue -> {
                        Cluster cluster = RedisConnection$Cluster$.MODULE$.apply(queue, cats.implicits$.MODULE$.toFunctorOps(refTopology.get(), this.evidence$17).map((Function1 & Serializable)_$52 -> (ClusterCommands.ClusterSlots)_$52._1()), (Function2 & Serializable)(x$1, x$2) -> {
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Host host = (Host)tuple2._1();
                            Port port = (Port)tuple2._2();
                            return keypool$3.take((Object)Tuple2$.MODULE$.apply((Object)host, (Object)port)).map((Function1 & Serializable)_$53 -> (Managed)cats.implicits$.MODULE$.toFunctorOps(_$53, Managed$.MODULE$.managedFunctor()).map((Function1 & Serializable)_$54 -> (Socket)_$54._1()));
                        });
                        return Tuple2$.MODULE$.apply(queue, cluster);
                    }).flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Queue queue = (Queue)tuple2._1();
                        Cluster cluster = (Cluster)tuple2._2();
                        Stream stream = Stream$.MODULE$.NestedStreamOps(Stream$.MODULE$.fromQueueUnterminatedChunk(queue, this.chunkSizeLimit(), this.evidence$17).chunks().map((Function1 & Serializable)chunk -> {
                            Stream stream;
                            if (chunk.nonEmpty()) {
                                Stream stream2 = Stream$.MODULE$.NestedStreamOps(Stream$.MODULE$.eval(refTopology.get()).map((Function1 & Serializable)x$1 -> {
                                    Tuple2 tuple22 = x$1;
                                    if (tuple22 == null) {
                                        throw new MatchError((Object)tuple22);
                                    }
                                    ClusterCommands.ClusterSlots topo = (ClusterCommands.ClusterSlots)tuple22._1();
                                    return Stream$.MODULE$.eval(topo.random(this.evidence$17)).flatMap((Function1 & Serializable)tuple2 -> Stream$.MODULE$.emits((Seq)chunk.toList().groupBy((Function1 & Serializable)x$1 -> {
                                        Tuple5 tuple5 = x$1;
                                        if (tuple5 == null) {
                                            throw new MatchError((Object)tuple5);
                                        }
                                        Option s = (Option)tuple5._2();
                                        Option server = (Option)tuple5._3();
                                        return (Tuple2)server.orElse(() -> this.$anonfun$20$$anonfun$2$$anonfun$2$$anonfun$2(topo, s)).getOrElse(() -> this.$anonfun$21$$anonfun$3$$anonfun$3$$anonfun$3(tuple2));
                                    }).toSeq()).evalMap((Function1 & Serializable)x$1 -> {
                                        Tuple2 tuple2 = x$1;
                                        if (tuple2 == null) {
                                            throw new MatchError((Object)tuple2);
                                        }
                                        Tuple2 server = (Tuple2)tuple2._1();
                                        List rest = (List)tuple2._2();
                                        return cats.implicits$.MODULE$.toFlatMapOps(((KeyPool)Functor$.MODULE$.apply(KeyPool$.MODULE$.keypoolFunctor()).map((Object)keypool$3, (Function1 & Serializable)_$56 -> (Socket)_$56._1())).take((Object)server).attempt(this.evidence$17).use((Function1 & Serializable)x$12 -> {
                                            Object object;
                                            Either either = x$12;
                                            if (either instanceof Right) {
                                                Managed m = (Managed)((Right)either).value();
                                                Chunk out = Chunk$.MODULE$.seq((Seq)rest.map((Function1 & Serializable)_$57 -> (Resp)_$57._5()));
                                                Object object2 = cats.implicits$.MODULE$.catsSyntaxApplicativeError(RedisConnection$.MODULE$.explicitPipelineRequest((Socket)m.value(), (Chunk<Resp>)out, RedisConnection$.MODULE$.explicitPipelineRequest$default$3(), RedisConnection$.MODULE$.explicitPipelineRequest$default$4(), this.evidence$17), this.evidence$17);
                                                object = cats.implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.evidence$17), this.evidence$17).flatTap((Function1 & Serializable)x$1 -> {
                                                    Either either = x$1;
                                                    return either instanceof Left ? m.canBeReused().set((Object)Reusable.DontReuse$.MODULE$) : Applicative$.MODULE$.apply(this.evidence$17).unit();
                                                });
                                            } else if (either instanceof Left) {
                                                Left l = (Left)either;
                                                Left left = cats.implicits$.MODULE$.catsSyntaxLeft(l);
                                                Either either2 = (Either)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)LeftOps$.MODULE$.rightCast$extension(left));
                                                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)either2, this.evidence$17);
                                            } else {
                                                throw new MatchError((Object)either);
                                            }
                                            return object;
                                        }, this.evidence$17), this.evidence$17).flatMap((Function1 & Serializable)x$12 -> {
                                            Object object;
                                            Either either = x$12;
                                            if (either instanceof Right) {
                                                Chunk n = (Chunk)((Right)either).value();
                                                object = cats.implicits$.MODULE$.toFoldableOps((Object)n.zipWithIndex(), (Foldable)Chunk$.MODULE$.instance()).traverse_((Function1 & Serializable)x$1 -> {
                                                    Object object;
                                                    Tuple2 tuple2 = x$1;
                                                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                                                    Resp ref = (Resp)tuple2._1();
                                                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                                    Tuple5 tuple5 = (Tuple5)rest.apply(i);
                                                    if (tuple5 == null) throw new MatchError((Object)tuple5);
                                                    Function1 toSet = (Function1)tuple5._1();
                                                    Option key = (Option)tuple5._2();
                                                    int retries = BoxesRunTime.unboxToInt((Object)tuple5._4());
                                                    Resp initialCommand = (Resp)tuple5._5();
                                                    Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)toSet, (Object)key, (Object)BoxesRunTime.boxToInteger((int)retries), (Object)initialCommand);
                                                    Function1 toSet2 = (Function1)tuple4._1();
                                                    Option key2 = (Option)tuple4._2();
                                                    int retries2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
                                                    Resp initialCommand2 = (Resp)tuple4._4();
                                                    Resp resp = ref;
                                                    if (resp instanceof Resp.Error) {
                                                        String string;
                                                        Resp.Error error = (Resp.Error)resp;
                                                        Resp.Error error2 = Resp$Error$.MODULE$.unapply(error);
                                                        String s = string = error2._1();
                                                        Resp.Error e = error;
                                                        if (s.startsWith("MOVED") && retries2 <= 5) {
                                                            Object object2 = cats.implicits$.MODULE$.catsSyntaxApplicativeError(refreshTopology, this.evidence$17);
                                                            Object object3 = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(cats.implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.evidence$17), this.evidence$17).void(), this.evidence$17);
                                                            object = FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.$anonfun$29$$anonfun$10$$anonfun$10$$anonfun$6$$anonfun$3$$anonfun$3(cluster, toSet2, key2, retries2, initialCommand2, s, e), this.evidence$17);
                                                            return object;
                                                        }
                                                        String s2 = string;
                                                        Resp.Error e2 = error;
                                                        if (s2.startsWith("ASK") && retries2 <= 5) {
                                                            Option<Tuple2<Host, Port>> serverRedirect = RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$extractServer(s2);
                                                            Option<Tuple2<Host, Port>> option = serverRedirect;
                                                            if (option instanceof Some) {
                                                                Some s3 = (Some)option;
                                                                Tuple5 asking = Tuple5$.MODULE$.apply((Function1 & Serializable)_$58 -> Applicative$.MODULE$.apply(this.evidence$17).unit(), (Object)key2, (Object)s3, (Object)BoxesRunTime.boxToInteger((int)6), (Object)Resp$.MODULE$.renderRequest((NonEmptyList<ByteVector>)NonEmptyList$.MODULE$.of(ByteVector$.MODULE$.encodeAscii("ASKING").fold((Function1 & Serializable)_$59 -> {
                                                                    throw _$59;
                                                                }, (Function1 & Serializable)_$60 -> (ByteVector)Predef$.MODULE$.identity(_$60)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteVector[0]))));
                                                                Tuple5 repeat = Tuple5$.MODULE$.apply((Object)toSet2, (Object)key2, (Object)s3, (Object)BoxesRunTime.boxToInteger((int)(retries2 + 1)), (Object)initialCommand2);
                                                                Chunk chunk = Chunk$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple5[]{asking, repeat}));
                                                                Object object4 = cats.implicits$.MODULE$.catsSyntaxIfM(cluster.queue().tryOffer((Object)chunk), this.evidence$17);
                                                                object = IfMOps$.MODULE$.ifM$extension(object4, this::$anonfun$33$$anonfun$11$$anonfun$11$$anonfun$7$$anonfun$4$$anonfun$4, () -> this.$anonfun$34$$anonfun$12$$anonfun$12$$anonfun$8$$anonfun$5$$anonfun$5(toSet2, e2), this.evidence$17);
                                                                return object;
                                                            }
                                                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                                                            object = toSet2.apply((Object)EitherObjectOps$.MODULE$.right$extension(cats.implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)e2));
                                                            return object;
                                                        }
                                                    }
                                                    Resp otherwise = resp;
                                                    object = toSet2.apply((Object)EitherObjectOps$.MODULE$.right$extension(cats.implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)otherwise));
                                                    return object;
                                                }, this.evidence$17);
                                            } else if (either instanceof Left) {
                                                Left e = (Left)either;
                                                Object object2 = cats.implicits$.MODULE$.catsSyntaxApplicativeError(refreshTopology, this.evidence$17);
                                                Object object3 = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(cats.implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.evidence$17), this.evidence$17).void(), this.evidence$17);
                                                object = FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.$anonfun$37$$anonfun$15$$anonfun$15$$anonfun$11$$anonfun$8(rest, e), this.evidence$17);
                                            } else {
                                                throw new MatchError((Object)either);
                                            }
                                            return object;
                                        });
                                    }), NotGiven$.MODULE$.value());
                                }));
                                stream = Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream2, this.parallelServerCalls(), this.evidence$17);
                            } else {
                                stream = Stream$.MODULE$.empty();
                            }
                            Stream s = stream;
                            return s.$plus$plus(this::build$$anonfun$11$$anonfun$7$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1);
                        }));
                        Object object = implicits$.MODULE$.genSpawnOps(Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream, this.workers(), this.evidence$17).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$17))).drain(), this.evidence$17);
                        return GenSpawnOps$.MODULE$.background$extension(object, this.evidence$17).map((Function1 & Serializable)x$1 -> {
                            Object object = x$1;
                            return cluster;
                        });
                    });
                });
            });
        }
    }

    public static class DirectConnection<F>
    implements RedisConnection<F>,
    Product,
    Serializable {
        private final Socket socket;

        public static <F> DirectConnection<F> apply(Socket<F> socket) {
            return RedisConnection$DirectConnection$.MODULE$.apply(socket);
        }

        public static DirectConnection fromProduct(Product product) {
            return RedisConnection$DirectConnection$.MODULE$.fromProduct(product);
        }

        public static <F> DirectConnection<F> unapply(DirectConnection<F> directConnection) {
            return RedisConnection$DirectConnection$.MODULE$.unapply(directConnection);
        }

        public DirectConnection(Socket<F> socket) {
            this.socket = socket;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DirectConnection)) return false;
            DirectConnection directConnection = (DirectConnection)object;
            Socket<F> socket = this.socket();
            Socket<F> socket2 = directConnection.socket();
            if (socket == null) {
                if (socket2 != null) {
                    return false;
                }
            } else if (!socket.equals(socket2)) return false;
            if (!directConnection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DirectConnection;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DirectConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "socket";
        }

        public Socket<F> socket() {
            return this.socket;
        }

        public <F> DirectConnection<F> copy(Socket<F> socket) {
            return new DirectConnection<F>(socket);
        }

        public <F> Socket<F> copy$default$1() {
            return this.socket();
        }

        public Socket<F> _1() {
            return this.socket();
        }
    }

    public static class DirectConnectionBuilder<F> {
        private final SocketGroup sg;
        private final Host host;
        private final Port port;
        private final Option tlsContext;
        private final TLSParameters tlsParameters;
        private final GenConcurrent<F, Throwable> evidence$11;

        public DirectConnectionBuilder(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, GenConcurrent<F, Throwable> evidence$11) {
            this.sg = sg;
            this.host = host;
            this.port = port;
            this.tlsContext = tlsContext;
            this.tlsParameters = tlsParameters;
            this.evidence$11 = evidence$11;
        }

        private SocketGroup<F> sg() {
            return this.sg;
        }

        private Host host() {
            return this.host;
        }

        private Port port() {
            return this.port;
        }

        private Option<TLSContext<F>> tlsContext() {
            return this.tlsContext;
        }

        private TLSParameters tlsParameters() {
            return this.tlsParameters;
        }

        private DirectConnectionBuilder<F> copy(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters) {
            return new DirectConnectionBuilder<F>(sg, host, port, tlsContext, tlsParameters, this.evidence$11);
        }

        private SocketGroup<F> copy$default$1() {
            return this.sg();
        }

        private Host copy$default$2() {
            return this.host();
        }

        private Port copy$default$3() {
            return this.port();
        }

        private Option<TLSContext<F>> copy$default$4() {
            return this.tlsContext();
        }

        private TLSParameters copy$default$5() {
            return this.tlsParameters();
        }

        public DirectConnectionBuilder<F> withHost(Host host) {
            return this.copy(this.copy$default$1(), host, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public DirectConnectionBuilder<F> withPort(Port port) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), port, this.copy$default$4(), this.copy$default$5());
        }

        public DirectConnectionBuilder<F> withTLSContext(TLSContext<F> tlsContext) {
            TLSContext tLSContext = (TLSContext)cats.implicits$.MODULE$.catsSyntaxOptionId(tlsContext);
            Option option = OptionIdOps$.MODULE$.some$extension((Object)tLSContext);
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            return this.copy(socketGroup, host, port, option, tLSParameters);
        }

        public DirectConnectionBuilder<F> withoutTLSContext() {
            None$ none$ = None$.MODULE$;
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            return this.copy(socketGroup, host, port, (Option<TLSContext<F>>)none$, tLSParameters);
        }

        public DirectConnectionBuilder<F> withTLSParameters(TLSParameters tlsParameters) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), tlsParameters);
        }

        public DirectConnectionBuilder<F> withSocketGroup(SocketGroup<F> sg) {
            return this.copy(sg, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Resource<F, RedisConnection<F>> build() {
            return this.sg().client(SocketAddress$.MODULE$.apply(this.host(), this.port()), (List)scala.package$.MODULE$.Nil()).flatMap((Function1 & Serializable)socket -> RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$elevateSocket(socket, this.tlsContext(), this.tlsParameters()).map((Function1 & Serializable)out -> RedisConnection$DirectConnection$.MODULE$.apply(out)));
        }
    }

    public static class PooledConnection<F>
    implements RedisConnection<F>,
    Product,
    Serializable {
        private final KeyPool pool;

        public static <F> PooledConnection<F> apply(KeyPool<F, BoxedUnit, Tuple2<Socket<F>, Object>> keyPool) {
            return RedisConnection$PooledConnection$.MODULE$.apply(keyPool);
        }

        public static PooledConnection fromProduct(Product product) {
            return RedisConnection$PooledConnection$.MODULE$.fromProduct(product);
        }

        public static <F> PooledConnection<F> unapply(PooledConnection<F> pooledConnection) {
            return RedisConnection$PooledConnection$.MODULE$.unapply(pooledConnection);
        }

        public PooledConnection(KeyPool<F, BoxedUnit, Tuple2<Socket<F>, Object>> pool) {
            this.pool = pool;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PooledConnection)) return false;
            PooledConnection pooledConnection = (PooledConnection)object;
            KeyPool<F, BoxedUnit, Tuple2<Socket<F>, F>> keyPool = this.pool();
            KeyPool<F, BoxedUnit, Tuple2<Socket<F>, F>> keyPool2 = pooledConnection.pool();
            if (keyPool == null) {
                if (keyPool2 != null) {
                    return false;
                }
            } else if (!keyPool.equals(keyPool2)) return false;
            if (!pooledConnection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PooledConnection;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PooledConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "pool";
        }

        public KeyPool<F, BoxedUnit, Tuple2<Socket<F>, F>> pool() {
            return this.pool;
        }

        public <F> PooledConnection<F> copy(KeyPool<F, BoxedUnit, Tuple2<Socket<F>, Object>> pool) {
            return new PooledConnection<F>(pool);
        }

        public <F> KeyPool<F, BoxedUnit, Tuple2<Socket<F>, F>> copy$default$1() {
            return this.pool();
        }

        public KeyPool<F, BoxedUnit, Tuple2<Socket<F>, F>> _1() {
            return this.pool();
        }
    }

    public static class PooledConnectionBuilder<F> {
        private final SocketGroup sg;
        private final Host host;
        private final Port port;
        private final Option tlsContext;
        private final TLSParameters tlsParameters;
        private final Async<F> evidence$13;

        public PooledConnectionBuilder(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, Async<F> evidence$13) {
            this.sg = sg;
            this.host = host;
            this.port = port;
            this.tlsContext = tlsContext;
            this.tlsParameters = tlsParameters;
            this.evidence$13 = evidence$13;
        }

        private SocketGroup<F> sg() {
            return this.sg;
        }

        private Host host() {
            return this.host;
        }

        private Port port() {
            return this.port;
        }

        private Option<TLSContext<F>> tlsContext() {
            return this.tlsContext;
        }

        private TLSParameters tlsParameters() {
            return this.tlsParameters;
        }

        private PooledConnectionBuilder<F> copy(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters) {
            return new PooledConnectionBuilder<F>(sg, host, port, tlsContext, tlsParameters, this.evidence$13);
        }

        private SocketGroup<F> copy$default$1() {
            return this.sg();
        }

        private Host copy$default$2() {
            return this.host();
        }

        private Port copy$default$3() {
            return this.port();
        }

        private Option<TLSContext<F>> copy$default$4() {
            return this.tlsContext();
        }

        private TLSParameters copy$default$5() {
            return this.tlsParameters();
        }

        public PooledConnectionBuilder<F> withHost(Host host) {
            return this.copy(this.copy$default$1(), host, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public PooledConnectionBuilder<F> withPort(Port port) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), port, this.copy$default$4(), this.copy$default$5());
        }

        public PooledConnectionBuilder<F> withTLSContext(TLSContext<F> tlsContext) {
            TLSContext tLSContext = (TLSContext)cats.implicits$.MODULE$.catsSyntaxOptionId(tlsContext);
            Option option = OptionIdOps$.MODULE$.some$extension((Object)tLSContext);
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            return this.copy(socketGroup, host, port, option, tLSParameters);
        }

        public PooledConnectionBuilder<F> withoutTLSContext() {
            None$ none$ = None$.MODULE$;
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            return this.copy(socketGroup, host, port, (Option<TLSContext<F>>)none$, tLSParameters);
        }

        public PooledConnectionBuilder<F> withTLSParameters(TLSParameters tlsParameters) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), tlsParameters);
        }

        public PooledConnectionBuilder<F> withSocketGroup(SocketGroup<F> sg) {
            return this.copy(sg, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Resource<F, RedisConnection<F>> build() {
            return KeyPoolBuilder$.MODULE$.apply((Function1 & Serializable)_$24 -> this.sg().client(SocketAddress$.MODULE$.apply(this.host(), this.port()), (List)scala.package$.MODULE$.Nil()).flatMap((Function1 & Serializable)_$25 -> RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$elevateSocket(_$25, this.tlsContext(), this.tlsParameters())).allocated(this.evidence$13), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object shutdown = tuple2._2();
                return shutdown;
            }, this.evidence$13).build().map((Function1 & Serializable)_$26 -> RedisConnection$PooledConnection$.MODULE$.apply(_$26));
        }
    }

    public static class Queued<F>
    implements RedisConnection<F>,
    Product,
    Serializable {
        private final Queue queue;
        private final Resource usePool;

        public static <F> Queued<F> apply(Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, Object>, Resp>>> queue, Resource<F, Managed<F, Socket<F>>> resource) {
            return RedisConnection$Queued$.MODULE$.apply(queue, resource);
        }

        public static Queued fromProduct(Product product) {
            return RedisConnection$Queued$.MODULE$.fromProduct(product);
        }

        public static <F> Queued<F> unapply(Queued<F> queued) {
            return RedisConnection$Queued$.MODULE$.unapply(queued);
        }

        public Queued(Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, Object>, Resp>>> queue, Resource<F, Managed<F, Socket<F>>> usePool) {
            this.queue = queue;
            this.usePool = usePool;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Queued)) return false;
            Queued queued = (Queued)object;
            Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> queue = this.queue();
            Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> queue2 = queued.queue();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            Resource<F, Managed<F, Socket<F>>> resource = this.usePool();
            Resource<F, Managed<F, Socket<F>>> resource2 = queued.usePool();
            if (resource == null) {
                if (resource2 != null) {
                    return false;
                }
            } else if (!resource.equals(resource2)) return false;
            if (!queued.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Queued;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Queued";
        }

        public Object productElement(int n) {
            Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> queue;
            int n2 = n;
            if (0 == n2) {
                queue = this._1();
            } else if (1 == n2) {
                queue = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return queue;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "queue";
            } else if (1 == n2) {
                string = "usePool";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> queue() {
            return this.queue;
        }

        public Resource<F, Managed<F, Socket<F>>> usePool() {
            return this.usePool;
        }

        public <F> Queued<F> copy(Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, Object>, Resp>>> queue, Resource<F, Managed<F, Socket<F>>> usePool) {
            return new Queued<F>(queue, usePool);
        }

        public <F> Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> copy$default$1() {
            return this.queue();
        }

        public <F> Resource<F, Managed<F, Socket<F>>> copy$default$2() {
            return this.usePool();
        }

        public Queue<F, Chunk<Tuple2<Function1<Either<Throwable, Resp>, F>, Resp>>> _1() {
            return this.queue();
        }

        public Resource<F, Managed<F, Socket<F>>> _2() {
            return this.usePool();
        }
    }

    public static class QueuedConnectionBuilder<F> {
        private final SocketGroup sg;
        private final Host host;
        private final Port port;
        private final Option tlsContext;
        private final TLSParameters tlsParameters;
        private final int maxQueued;
        private final int workers;
        private final int chunkSizeLimit;
        private final Async<F> evidence$15;

        public QueuedConnectionBuilder(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, int maxQueued, int workers, int chunkSizeLimit, Async<F> evidence$15) {
            this.sg = sg;
            this.host = host;
            this.port = port;
            this.tlsContext = tlsContext;
            this.tlsParameters = tlsParameters;
            this.maxQueued = maxQueued;
            this.workers = workers;
            this.chunkSizeLimit = chunkSizeLimit;
            this.evidence$15 = evidence$15;
        }

        private SocketGroup<F> sg() {
            return this.sg;
        }

        private Host host() {
            return this.host;
        }

        private Port port() {
            return this.port;
        }

        private Option<TLSContext<F>> tlsContext() {
            return this.tlsContext;
        }

        private TLSParameters tlsParameters() {
            return this.tlsParameters;
        }

        private int maxQueued() {
            return this.maxQueued;
        }

        private int workers() {
            return this.workers;
        }

        private int chunkSizeLimit() {
            return this.chunkSizeLimit;
        }

        private QueuedConnectionBuilder<F> copy(SocketGroup<F> sg, Host host, Port port, Option<TLSContext<F>> tlsContext, TLSParameters tlsParameters, int maxQueued, int workers, int chunkSizeLimit) {
            return new QueuedConnectionBuilder<F>(sg, host, port, tlsContext, tlsParameters, maxQueued, workers, chunkSizeLimit, this.evidence$15);
        }

        private SocketGroup<F> copy$default$1() {
            return this.sg();
        }

        private Host copy$default$2() {
            return this.host();
        }

        private Port copy$default$3() {
            return this.port();
        }

        private Option<TLSContext<F>> copy$default$4() {
            return this.tlsContext();
        }

        private TLSParameters copy$default$5() {
            return this.tlsParameters();
        }

        private int copy$default$6() {
            return this.maxQueued();
        }

        private int copy$default$7() {
            return this.workers();
        }

        private int copy$default$8() {
            return this.chunkSizeLimit();
        }

        public QueuedConnectionBuilder<F> withHost(Host host) {
            return this.copy(this.copy$default$1(), host, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withPort(Port port) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), port, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withTLSContext(TLSContext<F> tlsContext) {
            TLSContext tLSContext = (TLSContext)cats.implicits$.MODULE$.catsSyntaxOptionId(tlsContext);
            Option option = OptionIdOps$.MODULE$.some$extension((Object)tLSContext);
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            int n = this.copy$default$6();
            int n2 = this.copy$default$7();
            int n3 = this.copy$default$8();
            return this.copy(socketGroup, host, port, option, tLSParameters, n, n2, n3);
        }

        public QueuedConnectionBuilder<F> withoutTLSContext() {
            None$ none$ = None$.MODULE$;
            SocketGroup<F> socketGroup = this.copy$default$1();
            Host host = this.copy$default$2();
            Port port = this.copy$default$3();
            TLSParameters tLSParameters = this.copy$default$5();
            int n = this.copy$default$6();
            int n2 = this.copy$default$7();
            int n3 = this.copy$default$8();
            return this.copy(socketGroup, host, port, (Option<TLSContext<F>>)none$, tLSParameters, n, n2, n3);
        }

        public QueuedConnectionBuilder<F> withTLSParameters(TLSParameters tlsParameters) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), tlsParameters, this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withSocketGroup(SocketGroup<F> sg) {
            return this.copy(sg, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withMaxQueued(int maxQueued) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), maxQueued, this.copy$default$7(), this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withWorkers(int workers) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), workers, this.copy$default$8());
        }

        public QueuedConnectionBuilder<F> withChunkSizeLimit(int chunkSizeLimit) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), chunkSizeLimit);
        }

        public Resource<F, RedisConnection<F>> build() {
            return package$.MODULE$.Resource().eval(Queue$.MODULE$.bounded(this.maxQueued(), this.evidence$15)).flatMap((Function1 & Serializable)queue -> KeyPoolBuilder$.MODULE$.apply((Function1 & Serializable)_$29 -> this.sg().client(SocketAddress$.MODULE$.apply(this.host(), this.port()), (List)scala.package$.MODULE$.Nil()).flatMap((Function1 & Serializable)_$30 -> RedisConnection$.MODULE$.io$chrisdavenport$rediculous$RedisConnection$$$elevateSocket(_$30, this.tlsContext(), this.tlsParameters())).allocated(this.evidence$15), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object shutdown = tuple2._2();
                return shutdown;
            }, this.evidence$15).build().flatMap((Function1 & Serializable)keypool -> {
                Stream stream = Stream$.MODULE$.NestedStreamOps(Stream$.MODULE$.fromQueueUnterminatedChunk(queue, this.chunkSizeLimit(), this.evidence$15).chunks().map((Function1 & Serializable)chunk -> {
                    Stream s = chunk.nonEmpty() ? Stream$.MODULE$.eval(cats.implicits$.MODULE$.toFlatMapOps(((KeyPool)Functor$.MODULE$.apply(KeyPool$.MODULE$.keypoolFunctor()).map(keypool, (Function1 & Serializable)_$32 -> (Socket)_$32._1())).take((Object)BoxedUnit.UNIT).attempt(this.evidence$15).use((Function1 & Serializable)x$12 -> {
                        Object object;
                        Either either = x$12;
                        if (either instanceof Right) {
                            Managed m = (Managed)((Right)either).value();
                            Chunk out = chunk.map((Function1 & Serializable)_$33 -> (Resp)_$33._2());
                            Object object2 = cats.implicits$.MODULE$.catsSyntaxApplicativeError(RedisConnection$.MODULE$.explicitPipelineRequest((Socket)m.value(), (Chunk<Resp>)out, RedisConnection$.MODULE$.explicitPipelineRequest$default$3(), RedisConnection$.MODULE$.explicitPipelineRequest$default$4(), this.evidence$15), this.evidence$15);
                            object = cats.implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.evidence$15), this.evidence$15).flatTap((Function1 & Serializable)x$1 -> {
                                Either either = x$1;
                                return either instanceof Left ? m.canBeReused().set((Object)Reusable.DontReuse$.MODULE$) : Applicative$.MODULE$.apply(this.evidence$15).unit();
                            });
                        } else if (either instanceof Left) {
                            Left l = (Left)either;
                            Left left = cats.implicits$.MODULE$.catsSyntaxLeft(l);
                            Either either2 = (Either)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)LeftOps$.MODULE$.rightCast$extension(left));
                            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)either2, this.evidence$15);
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return object;
                    }, this.evidence$15), this.evidence$15).flatMap((Function1 & Serializable)x$12 -> {
                        Object object;
                        Either either = x$12;
                        if (either instanceof Right) {
                            Chunk n = (Chunk)((Right)either).value();
                            object = cats.implicits$.MODULE$.toFoldableOps((Object)n.zipWithIndex(), (Foldable)Chunk$.MODULE$.instance()).traverse_((Function1 & Serializable)x$1 -> {
                                Function1 toSet;
                                Resp ref;
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    ref = (Resp)tuple2._1();
                                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                    Tuple2 tuple22 = (Tuple2)chunk.apply(i);
                                    if (tuple22 == null) {
                                        throw new MatchError((Object)tuple22);
                                    }
                                    toSet = (Function1)tuple22._1();
                                } else {
                                    throw new MatchError((Object)tuple2);
                                }
                                Function1 toSet2 = toSet;
                                return toSet2.apply((Object)EitherObjectOps$.MODULE$.right$extension(cats.implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)ref));
                            }, this.evidence$15);
                        } else if (either instanceof Left) {
                            Left e = (Left)either;
                            object = cats.implicits$.MODULE$.toFoldableOps(chunk, (Foldable)Chunk$.MODULE$.instance()).traverse_((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Function1 deff = (Function1)tuple2._1();
                                return deff.apply((Object)((Either)e));
                            }, this.evidence$15);
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return object;
                    })) : Stream$.MODULE$.empty();
                    return s.$plus$plus(this::build$$anonfun$5$$anonfun$4$$anonfun$1$$anonfun$1);
                }));
                Object object = implicits$.MODULE$.genSpawnOps(Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream, this.workers(), this.evidence$15).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$15))).drain(), this.evidence$15);
                return GenSpawnOps$.MODULE$.background$extension(object, this.evidence$15).map((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    return RedisConnection$Queued$.MODULE$.apply(queue, keypool.take((Object)BoxedUnit.UNIT).map((Function1 & Serializable)_$35 -> (Managed)Functor$.MODULE$.apply(Managed$.MODULE$.managedFunctor()).map(_$35, (Function1 & Serializable)_$36 -> (Socket)_$36._1())));
                });
            }));
        }

        private final Stream build$$anonfun$5$$anonfun$4$$anonfun$1$$anonfun$1() {
            return Stream$.MODULE$.exec(package$.MODULE$.Concurrent().apply(this.evidence$15, DummyImplicit$.MODULE$.dummyImplicit()).cede());
        }
    }
}

