/*
 * Decompiled with CFR 0.152.
 */
package io.cloudracer.mocktcpserver.datastream;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataStream
implements Closeable {
    private Logger logger;
    public static final int DEFAULT_TAIL_MAXIMUM_LENGTH = 3;
    private ByteArrayOutputStream output;
    private Deque<Byte> tailQueue = null;
    private Byte lastByte;
    private Integer tailMaximumLength = null;
    private String rootLoggerName;

    public DataStream(String rootLoggerName) {
        this.setRootLoggerName(rootLoggerName);
    }

    public DataStream(int tailMaximumLength) {
        this.setTailMaximumLength(tailMaximumLength);
    }

    public DataStream(int tailMaximumLength, String rootLoggerName) {
        this.setTailMaximumLength(tailMaximumLength);
        this.setRootLoggerName(rootLoggerName);
    }

    public synchronized int write(int data) throws IOException {
        this.getOutput().write(data);
        return data;
    }

    @Override
    public void close() throws IOException {
        this.setOutput(null);
    }

    public void reset() {
        this.getOutput().reset();
    }

    public synchronized int size() {
        return this.getOutput().size();
    }

    private synchronized ByteArrayOutputStream getOutput() {
        if (this.output == null) {
            this.output = new ByteArrayOutputStream(){

                @Override
                public synchronized void write(int b) {
                    super.write(b);
                    DataStream.this.setLastByte((byte)b);
                    DataStream.this.addToTailList();
                }
            };
        }
        return this.output;
    }

    public synchronized byte[] toByteArray() {
        return this.getOutput().toByteArray();
    }

    public PipedInputStream toInputStream() throws IOException {
        PipedInputStream inputStream;
        if (this.getOutput().size() == 0) {
            inputStream = new PipedInputStream();
        } else {
            inputStream = new PipedInputStream(this.getOutput().size());
            PipedOutputStream outputStream = new PipedOutputStream(inputStream);
            Thread copy = new Thread(() -> {
                try {
                    this.getOutput().writeTo(outputStream);
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
            copy.setName(String.format("%s-InputStream-Creator", this.getThreadName()));
            copy.start();
            try {
                copy.join();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)e.getCause(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return inputStream;
    }

    private void setOutput(ByteArrayOutputStream output) throws IOException {
        if (output == null && this.output != null) {
            IOUtils.closeQuietly((OutputStream)this.output);
        }
        this.output = output;
    }

    public int getTailMaximumLength() {
        if (this.tailMaximumLength == null) {
            this.tailMaximumLength = 3;
        }
        return this.tailMaximumLength;
    }

    private void setTailMaximumLength(int tailLength) {
        this.tailMaximumLength = tailLength;
    }

    private Deque<Byte> getTailQueue() {
        if (this.tailQueue == null) {
            this.tailQueue = new ArrayDeque<Byte>(this.getTailMaximumLength());
        }
        return this.tailQueue;
    }

    public byte[] getTail() {
        byte[] tail = new byte[this.getTailQueue().size()];
        int i = 0;
        for (Byte nextByte : this.getTailQueue()) {
            tail[i] = nextByte;
            ++i;
        }
        return tail;
    }

    private void addToTailList() {
        this.getTailQueue().addLast(this.getLastByte());
        if (this.getTailQueue().size() > this.getTailMaximumLength()) {
            this.getTailQueue().removeFirst();
        }
    }

    public Byte getLastByte() {
        return this.lastByte;
    }

    private void setLastByte(byte lastByte) {
        this.lastByte = lastByte;
    }

    private String getRootLoggerName() {
        if (this.rootLoggerName == null) {
            this.rootLoggerName = this.getClssName();
        }
        return new String(this.rootLoggerName);
    }

    private void setRootLoggerName(String rootLoggerName) {
        this.rootLoggerName = new String(rootLoggerName);
        this.logger = LogManager.getLogger((String)String.format("%s.%s", this.rootLoggerName, this.getClssName()));
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger((String)String.format("%s.%s", this.getRootLoggerName(), this.getClssName()));
        }
        return this.logger;
    }

    private String getThreadName() {
        String name;
        String delimeter = ".";
        String regEx = "\\.";
        if (this.getClass().getSimpleName() != null && this.getClass().getSimpleName().length() > 0) {
            name = this.getClass().getSimpleName();
        } else if (this.getClass().getName().contains(".")) {
            String[] nameSegments = this.getClass().getName().split("\\.");
            name = String.format("%s-%s", this.getClass().getSuperclass().getSimpleName(), nameSegments[nameSegments.length - 1]);
        } else {
            name = this.getClass().getName();
        }
        return name;
    }

    private String getClssName() {
        String name;
        String delimeter = ".";
        String regEx = "\\.";
        if (this.getClass().getSimpleName() != null && this.getClass().getSimpleName().length() != 0) {
            name = this.getClass().getSimpleName();
        } else if (this.getClass().getName().contains(".")) {
            String[] nameSegments = this.getClass().getName().split("\\.");
            name = nameSegments[nameSegments.length - 1];
        } else {
            name = this.getClass().getName();
        }
        return name;
    }

    public String toString() {
        String returnValue = null;
        try {
            returnValue = this.getOutput().toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }
}

