/*
 * Decompiled with CFR 0.152.
 */
package io.cloudracer.mocktcpserver.tcpclient;

import io.cloudracer.mocktcpserver.datastream.DataStream;
import io.cloudracer.mocktcpserver.tcpclient.TCPClientUnexpectedResponseException;
import io.cloudracer.properties.ConfigurationSettings;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPClient
implements Closeable {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getSimpleName());
    private final ConfigurationSettings configurationSettings = new ConfigurationSettings();
    private static final byte[] DEFAULT_ACK = new byte[]{65};
    private byte[] ack;
    private static final byte[] DEFAULT_NAK = new byte[]{78};
    private byte[] nak;
    private static final byte[] DEFAULT_RESPONSE_TERMINATOR = new byte[]{13, 10};
    private byte[] responseTerminator = DEFAULT_RESPONSE_TERMINATOR;
    private String hostName = null;
    private Integer port = null;
    private Socket socket;
    private DataOutputStream dataOutputStream;
    private DataInputStream dataInputStream;

    public TCPClient() {
        this(null);
    }

    public TCPClient(Integer port) {
        if (port == null) {
            this.getPort();
        } else {
            this.setPort(port);
        }
    }

    public TCPClient(String hostName, int port) throws IOException {
        this(port);
        this.setHostName(hostName);
    }

    @Override
    public void close() throws IOException {
        this.setSocket(null);
    }

    public void connect() throws IOException {
        this.getSocket();
    }

    public DataStream send(String message) throws IOException {
        return this.send(message, true);
    }

    public DataStream send(String message, boolean waitForResponse) throws IOException {
        return this.send(message, waitForResponse, this.getResponseTerminator());
    }

    private DataStream send(String message, boolean waitForResponse, byte[] responseTerminator) throws IOException {
        this.logger.info(String.format("Sending the message %s.", message));
        this.getDataOutputStream().write(message.getBytes(), 0, message.getBytes().length);
        if (waitForResponse) {
            try {
                if (responseTerminator == null) {
                    return this.getResponse();
                }
                return this.getResponse(responseTerminator);
            }
            catch (TCPClientUnexpectedResponseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                this.close();
                return null;
            }
        }
        return null;
    }

    public DataStream getResponse() throws IOException, TCPClientUnexpectedResponseException {
        return this.getResponse(this.getResponseTerminator());
    }

    private DataStream getResponse(byte[] terminator) throws IOException, TCPClientUnexpectedResponseException {
        this.setDataInputStream(new DataInputStream(this.getSocket().getInputStream()));
        DataStream dataStream = terminator == null ? new DataStream(this.getClass().getSimpleName()) : new DataStream(terminator.length, this.getClass().getSimpleName());
        while (dataStream.write(this.getDataInputStream().read()) != -1 && !this.isTerminated(dataStream, terminator)) {
        }
        return dataStream;
    }

    private boolean isTerminated(DataStream dataStream, byte[] terminator) throws TCPClientUnexpectedResponseException {
        boolean terminated;
        boolean bl = terminated = Arrays.equals(dataStream.getTail(), terminator) || Arrays.equals(dataStream.toByteArray(), this.getACK()) || Arrays.equals(dataStream.toByteArray(), this.getNAK());
        if (!(terminator != null || terminated || dataStream.size() != this.getACK().length && dataStream.size() != this.getNAK().length)) {
            throw new TCPClientUnexpectedResponseException(dataStream);
        }
        return terminated;
    }

    public int getPort() {
        if (this.port == null) {
            try {
                this.port = this.configurationSettings.getPort();
            }
            catch (ConfigurationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.port;
    }

    private void setPort(int port) {
        this.port = port;
    }

    public String getHostName() throws UnknownHostException {
        if (this.hostName == null) {
            InetAddress host = InetAddress.getLocalHost();
            this.hostName = host.getHostName();
        }
        return this.hostName;
    }

    private void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public byte[] getNAK() {
        if (this.nak == null) {
            this.nak = DEFAULT_NAK;
        }
        return this.nak;
    }

    public void setNAK(byte[] nak) {
        this.nak = nak;
    }

    public byte[] getACK() {
        if (this.ack == null) {
            this.ack = DEFAULT_ACK;
        }
        return this.ack;
    }

    public void setACK(byte[] ack) {
        this.ack = ack;
    }

    public byte[] getResponseTerminator() {
        return this.responseTerminator;
    }

    public void setResponseTerminator(byte[] responseTerminator) {
        this.responseTerminator = responseTerminator;
    }

    private Socket getSocket() throws IOException {
        if (this.socket == null) {
            try {
                this.socket = new Socket(this.getHostName(), this.getPort());
            }
            catch (IOException e) {
                throw new IOException(String.format("Unable to connect to the Server \"%s\" on the port %d.", this.getHostName(), this.getPort()), e);
            }
        }
        return this.socket;
    }

    private void setSocket(Socket socket) throws IOException {
        if (socket == null && this.socket != null) {
            this.setDataInputStream(null);
            this.setDataOutputStream(null);
            IOUtils.closeQuietly((Socket)this.socket);
            try {
                long sleepDuration = 20L;
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.socket = socket;
    }

    private DataOutputStream getDataOutputStream() throws IOException {
        if (this.dataOutputStream == null) {
            this.setDataOutputStream(new DataOutputStream(this.getSocket().getOutputStream()));
        }
        return this.dataOutputStream;
    }

    private void setDataOutputStream(DataOutputStream dataOutputStream) throws IOException {
        if (dataOutputStream == null && this.dataOutputStream != null) {
            IOUtils.closeQuietly((OutputStream)this.getDataOutputStream());
        }
        this.dataOutputStream = dataOutputStream;
    }

    private DataInputStream getDataInputStream() throws IOException {
        if (this.dataInputStream == null) {
            this.setDataInputStream(new DataInputStream(this.getSocket().getInputStream()));
        }
        return this.dataInputStream;
    }

    private void setDataInputStream(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null && this.dataInputStream != null) {
            IOUtils.closeQuietly((InputStream)this.getDataInputStream());
        }
        this.dataInputStream = dataInputStream;
    }
}

