/*
 * Decompiled with CFR 0.152.
 */
package io.cloudracer.mocktcpserver;

import io.cloudracer.mocktcpserver.datastream.DataStream;
import io.cloudracer.mocktcpserver.datastream.DataStreamRegexMatcher;
import io.cloudracer.properties.ConfigurationSettings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MockTCPServer
extends Thread
implements Closeable {
    private final Logger logger = LogManager.getLogger((String)this.getRootLoggerName());
    private static final byte[] DEFAULT_TERMINATOR = new byte[]{13, 10, 10};
    private static final byte[] DEFAULT_ACK = new byte[]{65};
    private static final byte[] DEFAULT_NAK = new byte[]{78};
    private byte[] terminator = null;
    private byte[] ack = null;
    private byte[] nak = null;
    private AssertionError assertionError;
    private ServerSocket socket;
    private BufferedReader inputStream;
    private DataOutputStream outputStream;
    private DataStreamRegexMatcher expectedMessage;
    private DataStream dataStream;
    private Socket connectionSocket;
    private Integer port;
    private boolean setIsAlwaysNAKResponse = false;
    private boolean setIsAlwaysNoResponse = false;
    private boolean isCloseAfterNextResponse = false;
    private int messagesReceivedCount = 0;
    private Status status = Status.OPEN;
    private final ConfigurationSettings configurationSettings = new ConfigurationSettings();

    public MockTCPServer() {
        this((Integer)null);
    }

    public MockTCPServer(Integer port) {
        this.logger.info("Starting...");
        if (port != null) {
            this.setPort(port);
        }
        super.setName(String.format("%s-%d", this.getThreadName(), this.getPort()));
        this.start();
        try {
            long sleepDuration = 20L;
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block9: {
            final Logger logger = LogManager.getLogger();
            try {
                MockTCPServer mockTCPServer;
                CommandLine commandLine = new DefaultParser().parse(MockTCPServer.getCommandLineOptions(), args);
                if (commandLine.hasOption("version")) {
                    Print.printVersion();
                    break block9;
                }
                if (commandLine.hasOption("help")) {
                    Print.printHelp();
                    break block9;
                }
                if (commandLine.hasOption("port")) {
                    int port = Integer.parseInt(commandLine.getOptionValue("port"));
                    mockTCPServer = new MockTCPServer(port);
                } else {
                    mockTCPServer = new MockTCPServer();
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        logger.info("Operating System interrupt detected.");
                        mockTCPServer.close();
                    }
                });
                try {
                    MockTCPServer.waitForThread(logger, mockTCPServer, 0L);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)mockTCPServer);
                }
            }
            catch (ParseException e1) {
                Print.printHelp(e1);
            }
        }
    }

    private static void waitForThread(Logger logger, Thread thread, long maximumDurationToWait) {
        try {
            thread.join(maximumDurationToWait);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        try {
            while (this.getStatus() == Status.OPEN && this.getSocket() != null) {
                this.readIncomingStream();
            }
        }
        catch (SocketException e) {
            this.logger.warn((Object)e);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.setStatus(Status.CLOSING);
            this.close();
        }
    }

    private void readIncomingStream() throws IOException {
        this.setDataStream(null);
        while (this.getDataStream().write(this.getInputStream().read()) != -1) {
            if (!Arrays.equals(this.getDataStream().getTail(), this.getTerminator())) continue;
            this.incrementMessagesReceivedCount();
            break;
        }
        if (this.getDataStream().getLastByte() == -1) {
            this.closeStreams();
        } else if (this.getDataStream().size() > 0) {
            this.processIncomingMessage();
        }
    }

    private void processIncomingMessage() throws IOException {
        this.setAssertionError(null);
        try {
            if (this.getExpectedMessage() != null) {
                Assert.assertThat((String)"Unexpected message from the AM Host Client.", (Object)this.getDataStream(), (Matcher)this.getExpectedMessage());
            }
        }
        catch (AssertionError e) {
            this.setAssertionError(e);
        }
        this.onMessage(this.getDataStream());
        if (this.getDataStream().getLastByte() != -1 && !this.getIsAlwaysNoResponse()) {
            byte[] response = this.getAssertionError() == null && !this.getIsAlwaysNAKResponse() ? this.getACK() : this.getNAK();
            this.getOutputStream().write(response);
            this.afterResponse(response);
        }
    }

    public byte[] getTerminator() {
        if (this.terminator == null) {
            this.terminator = DEFAULT_TERMINATOR;
        }
        return this.terminator;
    }

    public synchronized void setTerminator(byte[] terminator) {
        this.terminator = terminator;
    }

    public byte[] getACK() {
        if (this.ack == null) {
            this.ack = DEFAULT_ACK;
        }
        return this.ack;
    }

    public synchronized void setACK(byte[] ack) {
        this.ack = ack;
    }

    public byte[] getNAK() {
        if (this.nak == null) {
            this.nak = DEFAULT_NAK;
        }
        return this.nak;
    }

    public synchronized void setNAK(byte[] nak) {
        this.nak = nak;
    }

    public synchronized void afterResponse(byte[] response) {
        this.logger.debug(String.format("Sent the response: %s.", new String(response)));
        if (this.getIsCloseAfterNextResponse()) {
            this.setStatus(Status.CLOSED);
        }
    }

    public void onMessage(DataStream message) {
        this.logger.info(String.format("Received: %s.", message.toString()));
    }

    public AssertionError getAssertionError() {
        return this.assertionError;
    }

    private void setAssertionError(AssertionError assertionError) {
        this.assertionError = assertionError;
    }

    public boolean getIsAlwaysNAKResponse() {
        return this.setIsAlwaysNAKResponse;
    }

    public synchronized void setIsAlwaysNAKResponse(boolean isAlwaysNAKResponse) {
        this.setIsAlwaysNAKResponse = isAlwaysNAKResponse;
    }

    public boolean getIsAlwaysNoResponse() {
        return this.setIsAlwaysNoResponse;
    }

    public synchronized void setIsAlwaysNoResponse(boolean isAlwaysNoResponse) {
        this.setIsAlwaysNoResponse = isAlwaysNoResponse;
    }

    public boolean getIsCloseAfterNextResponse() {
        return this.isCloseAfterNextResponse;
    }

    public synchronized void setIsCloseAfterNextResponse(boolean isCloseAfterNextResponse) {
        this.isCloseAfterNextResponse = isCloseAfterNextResponse;
    }

    public DataStreamRegexMatcher getExpectedMessage() {
        return this.expectedMessage;
    }

    public synchronized void setExpectedMessage(String expectedMessage) {
        this.expectedMessage = new DataStreamRegexMatcher(expectedMessage);
    }

    public synchronized void setExpectedMessage(StringBuilder expectedMessage) {
        this.setExpectedMessage(expectedMessage.toString());
    }

    public int getMessagesReceivedCount() {
        return this.messagesReceivedCount;
    }

    private void incrementMessagesReceivedCount() {
        ++this.messagesReceivedCount;
    }

    @Override
    public synchronized void close() {
        this.logger.info("Closing...");
        if (this.getStatus() != Status.CLOSING) {
            this.setStatus(Status.CLOSED);
        }
        this.closeStreams();
        while (super.isAlive() && this.getStatus() != Status.CLOSING) {
            long maximumTimeToWait = 10000L;
            try {
                super.join(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!super.isAlive()) continue;
            this.logger.warn(String.format("Failed to close the Server(%s) in %d milliseconds. Trying again to shutdown the Server...", super.getName(), 10000L));
            if (super.isInterrupted()) continue;
            this.logger.trace(String.format("Interrupting the Server Thread(%s)...", super.getName()));
            this.closeStreams();
        }
        this.logger.info("Closed.");
    }

    private void closeStreams() {
        try {
            if (this.getConnectionSocket() != null && !this.getConnectionSocket().isInputShutdown()) {
                this.getConnectionSocket().shutdownInput();
            }
            if (this.getConnectionSocket() != null && !this.getConnectionSocket().isOutputShutdown()) {
                this.getConnectionSocket().shutdownOutput();
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.setInputStream(null);
        this.setOutputStream(null);
        this.logger.info("Closing the socket...");
        IOUtils.closeQuietly((ServerSocket)this.socket);
        this.logger.info("Closed the socket.");
    }

    private Status getStatus() {
        return this.status;
    }

    private synchronized void setStatus(Status status) {
        this.status = status;
    }

    private int getPort() {
        try {
            if (this.port == null) {
                this.port = this.configurationSettings.getPort();
            }
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return this.port;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private ServerSocket getSocket() throws IOException, ConfigurationException {
        if (this.socket == null || this.socket.isClosed()) {
            this.logger.info(String.format("Opening a socket on port %d...", this.getPort()));
            this.setSocket(new ServerSocket(this.getPort()));
            this.logger.info("Waiting for a connection...");
            this.setConnectionSocket(this.socket.accept());
            this.logger.info("Accepted a connection.");
            this.setInputStream(new BufferedReader(new InputStreamReader(this.getConnectionSocket().getInputStream())));
            this.setOutputStream(new DataOutputStream(this.getConnectionSocket().getOutputStream()));
            this.logger.info("Ready to receive input.");
        }
        return this.socket;
    }

    private void setSocket(ServerSocket socket) {
        this.socket = socket;
    }

    private Socket getConnectionSocket() {
        return this.connectionSocket;
    }

    private void setConnectionSocket(Socket connectionSocket) {
        this.connectionSocket = connectionSocket;
    }

    private DataStream getDataStream() {
        if (this.dataStream == null) {
            this.dataStream = new DataStream(this.getTerminator().length, this.getRootLoggerName());
        }
        return this.dataStream;
    }

    private void setDataStream(DataStream dataStream) {
        this.logger.debug("Closing the DataStream...");
        IOUtils.closeQuietly((Closeable)this.dataStream);
        this.logger.debug("Closed the DataStream.");
        this.dataStream = dataStream;
    }

    private BufferedReader getInputStream() {
        return this.inputStream;
    }

    private void setInputStream(BufferedReader inputStream) {
        this.logger.info("Closing input stream...");
        IOUtils.closeQuietly((Reader)this.inputStream);
        this.logger.info("Closed input stream.");
        this.inputStream = inputStream;
    }

    private DataOutputStream getOutputStream() {
        return this.outputStream;
    }

    private void setOutputStream(DataOutputStream outputStream) {
        this.logger.info("Closing the output stream...");
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        this.logger.info("Closed the output stream.");
        this.outputStream = outputStream;
    }

    private static Options getCommandLineOptions() {
        Options options = new Options();
        options.addOption("p", "port", false, "use this port instead of the default one, or the one specified in the configuration file.");
        options.getOption("port").setArgs(1);
        options.addOption("h", "help", false, "print these usage instructions and exit.");
        options.addOption("?", "help", false, "print these usage instructions and exit.");
        options.addOption("v", "version", false, "print product version and exit.");
        return options;
    }

    public String getRootLoggerName() {
        return this.getThreadName().replaceAll("-", ".");
    }

    private String getThreadName() {
        String name;
        String delimeter = ".";
        String regEx = "\\.";
        if (StringUtils.isNotBlank((CharSequence)this.getClass().getSimpleName())) {
            name = this.getClass().getSimpleName();
        } else if (this.getClass().getName().contains(".")) {
            String[] nameSegments = this.getClass().getName().split("\\.");
            name = String.format("%s-%s", this.getClass().getSuperclass().getSimpleName(), nameSegments[nameSegments.length - 1]);
        } else {
            name = this.getClass().getName();
        }
        return name;
    }

    private static abstract class Print {
        private static final Logger logger = LogManager.getLogger((String)Print.class.getName());

        private Print() {
        }

        private static void printVersion() {
            Pattern pattern;
            java.util.regex.Matcher matcher;
            String ideWorkingFolder = "classes";
            File executableLocation = new File(MockTCPServer.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            String version = executableLocation.getName();
            if (version.equals("classes")) {
                version = executableLocation.getAbsoluteFile().toString();
            }
            if ((matcher = (pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+")).matcher(version)).find()) {
                logger.info(matcher.group(0));
            } else {
                logger.info("Version number cannot be identified.");
            }
        }

        private static void printHelp() {
            Print.printHelp(null);
        }

        private static void printHelp(ParseException e1) {
            if (e1 != null) {
                logger.info(String.format("Invalid command line: %s", e1.getMessage()));
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("MockTCPServer", MockTCPServer.getCommandLineOptions());
        }
    }

    private static enum Status {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

