/*
 * Decompiled with CFR 0.152.
 */
package io.cloudracer.properties;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationSettings
extends AbstractConfiguration {
    private static final String UNSUPPORTED = "Unsupported.";
    private Logger logger;
    public static final String CONFIGURATION_INITIALISATION_ENABLED = "mocktcpserver.configuration.initialisation.enabled";
    public static final String FILENAME = "mocktcpserver.xml";
    public static final String FILENAME_PATH = "configuration";
    public static final String DEFAULT_FILENAME = String.format("%s%s%s", "configuration", Character.valueOf(File.separatorChar), "mocktcpserver.xml");
    private static final String PORT_PROPERTY_NAME = "server[@port]";
    private URL propertiesFile;
    private FileBasedConfigurationBuilder<XMLConfiguration> configurationBuilder;

    public int getPort() throws ConfigurationException {
        return Integer.parseInt(((XMLConfiguration)this.getConfigurationBuilder().getConfiguration()).getProperty(PORT_PROPERTY_NAME).toString());
    }

    public void setPort(int port) throws ConfigurationException {
        ((XMLConfiguration)this.getConfigurationBuilder().getConfiguration()).setProperty(PORT_PROPERTY_NAME, (Object)port);
    }

    public URL getFileName() {
        if (this.propertiesFile == null) {
            List<FileLocationStrategy> subs = Arrays.asList(new ProvidedURLLocationStrategy(), new FileSystemLocationStrategy(), new ClasspathLocationStrategy());
            CombinedLocationStrategy strategy = new CombinedLocationStrategy(subs);
            FileLocator fileLocator = FileLocatorUtils.fileLocator().basePath(this.getDefaultFile().getParent()).fileName(this.getDefaultFile().getName()).create();
            if (!new File(FileLocatorUtils.locate((FileLocator)fileLocator).getFile()).exists()) {
                fileLocator = FileLocatorUtils.fileLocator().fileName(this.getDefaultFile().getName()).locationStrategy((FileLocationStrategy)strategy).create();
            }
            this.propertiesFile = FileLocatorUtils.locate((FileLocator)fileLocator);
            this.getConfigurationBuilder();
        }
        return this.propertiesFile;
    }

    private File getDefaultFile() {
        return new File(DEFAULT_FILENAME);
    }

    protected void addPropertyDirect(String arg0, Object arg1) {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    protected void clearPropertyDirect(String arg0) {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    protected boolean containsKeyInternal(String arg0) {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    protected Iterator<String> getKeysInternal() {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    protected Object getPropertyInternal(String arg0) {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    protected boolean isEmptyInternal() {
        throw new NotImplementedException(UNSUPPORTED, (Throwable)new UnsupportedOperationException());
    }

    private FileBasedConfigurationBuilder<XMLConfiguration> getConfigurationBuilder() {
        if (this.configurationBuilder == null) {
            Parameters params = new Parameters();
            this.configurationBuilder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)params.xml().setURL(this.getFileName())).setValidating(false)});
            this.configurationBuilder.setAutoSave(true);
            if (this.isConfigurationInitialisationEnabled() && !this.getDefaultFile().exists()) {
                this.propertiesFile = null;
                this.save();
                this.configurationBuilder = null;
                this.getConfigurationBuilder();
            }
        }
        return this.configurationBuilder;
    }

    public boolean isConfigurationInitialisationEnabled() {
        return BooleanUtils.toBoolean((String)System.getProperties().getProperty(CONFIGURATION_INITIALISATION_ENABLED, BooleanUtils.toStringTrueFalse((Boolean)Boolean.FALSE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() {
        try {
            FileUtils.forceMkdir((File)this.getDefaultFile().getParentFile());
            return;
        }
        catch (IOException e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            try (FileWriter fileWriter = new FileWriter(this.getDefaultFile());){
                ((XMLConfiguration)this.getConfigurationBuilder().getConfiguration()).write((Writer)fileWriter);
            }
            catch (IOException | ConfigurationException e) {
                this.getLog().error(e.getMessage(), e);
            }
        }
    }

    private Logger getLog() {
        if (this.logger == null) {
            this.logger = LogManager.getFormatterLogger();
        }
        return this.logger;
    }
}

