@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.cloudassembly.schema

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.cloudassembly.schema.DockerImageAsset
import software.amazon.awscdk.cloudassembly.schema.DockerImageDestination
import software.amazon.awscdk.cloudassembly.schema.DockerImageSource
import kotlin.String
import kotlin.Unit
import kotlin.collections.Map

/**
 * A file asset.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * DockerImageAsset dockerImageAsset = DockerImageAsset.builder()
 * .destinations(Map.of(
 * "destinationsKey", DockerImageDestination.builder()
 * .imageTag("imageTag")
 * .repositoryName("repositoryName")
 * // the properties below are optional
 * .assumeRoleArn("assumeRoleArn")
 * .assumeRoleExternalId("assumeRoleExternalId")
 * .region("region")
 * .build()))
 * .source(DockerImageSource.builder()
 * .cacheFrom(List.of(DockerCacheOption.builder()
 * .type("type")
 * // the properties below are optional
 * .params(Map.of(
 * "paramsKey", "params"))
 * .build()))
 * .cacheTo(DockerCacheOption.builder()
 * .type("type")
 * // the properties below are optional
 * .params(Map.of(
 * "paramsKey", "params"))
 * .build())
 * .directory("directory")
 * .dockerBuildArgs(Map.of(
 * "dockerBuildArgsKey", "dockerBuildArgs"))
 * .dockerBuildSecrets(Map.of(
 * "dockerBuildSecretsKey", "dockerBuildSecrets"))
 * .dockerBuildTarget("dockerBuildTarget")
 * .dockerFile("dockerFile")
 * .dockerOutputs(List.of("dockerOutputs"))
 * .executable(List.of("executable"))
 * .networkMode("networkMode")
 * .platform("platform")
 * .build())
 * .build();
 * ```
 */
@CdkDslMarker
public class DockerImageAssetDsl {
    private val cdkBuilder: DockerImageAsset.Builder = DockerImageAsset.builder()

    /**
     * @param destinations Destinations for this file asset.
     */
    public fun destinations(destinations: Map<String, DockerImageDestination>) {
        cdkBuilder.destinations(destinations)
    }

    /**
     * @param source Source description for file assets.
     */
    public fun source(source: DockerImageSourceDsl.() -> Unit = {}) {
        val builder = DockerImageSourceDsl()
        builder.apply(source)
        cdkBuilder.source(builder.build())
    }

    /**
     * @param source Source description for file assets.
     */
    public fun source(source: DockerImageSource) {
        cdkBuilder.source(source)
    }

    public fun build(): DockerImageAsset = cdkBuilder.build()
}
