@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.pipelines

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.pipelines.IFileSetProducer
import software.amazon.awscdk.pipelines.PipelineBaseProps

/**
 * Properties for a `Pipeline`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.pipelines.*;
 * IFileSetProducer fileSetProducer;
 * PipelineBaseProps pipelineBaseProps = PipelineBaseProps.builder()
 * .synth(fileSetProducer)
 * .build();
 * ```
 */
@CdkDslMarker
public class PipelineBasePropsDsl {
    private val cdkBuilder: PipelineBaseProps.Builder = PipelineBaseProps.builder()

    /**
     * @param synth The build step that produces the CDK Cloud Assembly.
     * The primary output of this step needs to be the `cdk.out` directory
     * generated by the `cdk synth` command.
     *
     * If you use a `ShellStep` here and you don't configure an output directory,
     * the output directory will automatically be assumed to be `cdk.out`.
     */
    public fun synth(synth: IFileSetProducer) {
        cdkBuilder.synth(synth)
    }

    public fun build(): PipelineBaseProps = cdkBuilder.build()
}
