@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.apigatewayv2

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.services.apigatewayv2.CfnApiGatewayManagedOverrides

/**
 * The `RouteOverrides` property overrides the route configuration for an API Gateway-managed route.
 *
 * If you remove this property, API Gateway restores the default values.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * RouteOverridesProperty routeOverridesProperty = RouteOverridesProperty.builder()
 * .authorizationScopes(List.of("authorizationScopes"))
 * .authorizationType("authorizationType")
 * .authorizerId("authorizerId")
 * .operationName("operationName")
 * .target("target")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-apigatewaymanagedoverrides-routeoverrides.html)
 */
@CdkDslMarker
public class CfnApiGatewayManagedOverridesRouteOverridesPropertyDsl {
  private val cdkBuilder: CfnApiGatewayManagedOverrides.RouteOverridesProperty.Builder =
      CfnApiGatewayManagedOverrides.RouteOverridesProperty.builder()

  private val _authorizationScopes: MutableList<String> = mutableListOf()

  /**
   * @param authorizationScopes The authorization scopes supported by this route.
   */
  public fun authorizationScopes(vararg authorizationScopes: String) {
    _authorizationScopes.addAll(listOf(*authorizationScopes))
  }

  /**
   * @param authorizationScopes The authorization scopes supported by this route.
   */
  public fun authorizationScopes(authorizationScopes: Collection<String>) {
    _authorizationScopes.addAll(authorizationScopes)
  }

  /**
   * @param authorizationType The authorization type for the route.
   * To learn more, see
   * [AuthorizationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html#cfn-apigatewayv2-route-authorizationtype)
   * .
   */
  public fun authorizationType(authorizationType: String) {
    cdkBuilder.authorizationType(authorizationType)
  }

  /**
   * @param authorizerId The identifier of the `Authorizer` resource to be associated with this
   * route.
   * The authorizer identifier is generated by API Gateway when you created the authorizer.
   */
  public fun authorizerId(authorizerId: String) {
    cdkBuilder.authorizerId(authorizerId)
  }

  /**
   * @param operationName The operation name for the route.
   */
  public fun operationName(operationName: String) {
    cdkBuilder.operationName(operationName)
  }

  /**
   * @param target For HTTP integrations, specify a fully qualified URL.
   * For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY
   * or AWS_PROXY, respectively.
   */
  public fun target(target: String) {
    cdkBuilder.target(target)
  }

  public fun build(): CfnApiGatewayManagedOverrides.RouteOverridesProperty {
    if(_authorizationScopes.isNotEmpty()) cdkBuilder.authorizationScopes(_authorizationScopes)
    return cdkBuilder.build()
  }
}
